#include "PayProcess.h"
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <pthread.h>
#include "SQLiteOperate.h"
#include "../base/FM_ErrorCode.h"
#include "../utility/utility.h"
#include "../base/common.h"
#include "../3rdParty/easylogging/easylogging++.h"
#include "json.h"

#define SOCKET_ERROR            (-1)
#define PAY_BACK_PORT           23771
#define TAKEWAY_PORT            23772
#define BUFFER_SIZE             1024*10 //接收数据缓冲区大小

int pay_server_fd;
int connect_fd;
bool g_exit = false;
IOperation *dbOperation;
//支付返回数据处理线程
void *PayRecv(void *ptr)
{
	SQLite sqlite;
	//sqlite初始化
	sqlite.initSQLite();

	struct sockaddr_in servaddr;
	char* szRecvBuf = new char[BUFFER_SIZE];       //支付数据接收区
	int nRecvLen = 0;

	//初始化Socket
	if ((pay_server_fd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
        LOG(ERROR)<<"create socket error:"<<strerror(errno)<<" errno:"<<errno;
		exit(0);
	}

	//初始化
	memset(&servaddr, 0, sizeof(servaddr));
	servaddr.sin_family = AF_INET;
	servaddr.sin_addr.s_addr = htonl(INADDR_ANY);//IP地址设置成INADDR_ANY,让系统自动获取本机的IP地址。
	servaddr.sin_port = htons(PAY_BACK_PORT);//设置的端口为DEFAULT_PORT
    // 设置套接字选项避免地址使用错误  
	int flag = 1;
	if ((setsockopt(pay_server_fd, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag)))<0)
    {  
        LOG(ERROR)<<"setsockopt failed";
		exit(0);
    }  
	//将本地地址绑定到所创建的套接字上
	if (bind(pay_server_fd, (struct sockaddr*)&servaddr, sizeof(servaddr)) == -1)
	{
        LOG(ERROR)<<"bind socket error:"<<strerror(errno)<<" errno:"<<errno;
		exit(0);
	}

	//开始监听是否有客户端连接
	if (listen(pay_server_fd, 10) == -1)
	{
        LOG(ERROR)<<"listen socket error:"<<strerror(errno)<<" errno:"<<errno;
		exit(0);
	}
    LOG(INFO)<<"======waiting for client's request======";
	while (!g_exit)
	{
		//阻塞直到有客户端连接
		if ((connect_fd = accept(pay_server_fd, (struct sockaddr*)NULL, NULL)) == -1)
		{
            LOG(ERROR)<<"accept socket error:"<<strerror(errno)<<" errno:"<<errno;
			continue;
		}
		//接收客户端传过来的数据
		//nRecvLen = recv(connect_fd, szRecvBuf, BUFFER_SIZE, 0);
		nRecvLen = socketRecvData(szRecvBuf, BUFFER_SIZE, connect_fd);
		if (nRecvLen > 0)
		{
			szRecvBuf[nRecvLen] = '\0';
            LOG(INFO)<<"recv msg from client:"<<szRecvBuf;
			PayBackData bkRecord = sqlite.writeDataToSQLite(szRecvBuf);
			char szStatus[20] = { 0 };

			sprintf_s(szStatus, 20, "%d", bkRecord.status);
			//if (dbOperation->SetPayResult(bkRecord.orderId, std::string(szStatus), bkRecord.pay_ebcode) != EC_OK)
			{
				LOG(INFO)<<"回写支付结果失败";
			}
		}		
		close(connect_fd);
	}
    LOG(INFO)<<"quit PayRecv thread.";
}

/*
//支付返回线程
DWORD WINAPI FunPayRecv(LPVOID lpParamter)
{
    SQLite sqlite;
    //sqlite初始化
    sqlite.initSQLite(); 
    SOCKADDR_IN addrServer;
    SOCKADDR_IN addrClient;
    char* payRecvBuf=new char[BUFFER_SIZE*10];       //支付数据接收区

    sockPayRecvServer = socket(AF_INET, SOCK_STREAM, 0);
    addrServer.sin_addr.S_un.S_addr = htonl(INADDR_ANY);//INADDR_ANY表示任何IP
    addrServer.sin_family = AF_INET;
    addrServer.sin_port = htons(23771);//绑定端口
    bind(sockPayRecvServer, (SOCKADDR*)&addrServer, sizeof(SOCKADDR));

    //Listen监听端
    listen(sockPayRecvServer, 5);//5为等待连接数目
    int len = sizeof(SOCKADDR);
    while(!g_exit)
    {
        sockPayRecvClient = accept(sockPayRecvServer, (SOCKADDR*)&addrClient, &len);
        if(sockPayRecvClient == SOCKET_ERROR)
        {
            continue;
        }
        //接收并打印客户端数据
        int rlt = socketRecvData(payRecvBuf,BUFFER_SIZE*10,sockPayRecvClient);
        if (0 < rlt)
        {
            payRecvBuf[rlt] = '\0';
            int lenGBK = CCodeConv::UTF8ToGBK(payRecvBuf,NULL,NULL);
            char* lpGBK = new char[lenGBK];
            CCodeConv::UTF8ToGBK(payRecvBuf,lpGBK,lenGBK);
            LOG_INFO("返回支付数据：\n%s",lpGBK)
            PayBackData bkRecord = sqlite.writeDataToSQLite(lpGBK);   //支付返回数据写入sqlite
            delete[] lpGBK;
            char szStatus[20] = {0};
            sprintf_s(szStatus,20, "%d",bkRecord.status);
            if(dbOperation->SetPayResult(bkRecord.orderId,std::string(szStatus),bkRecord.pay_ebcode) != EC_OK)
            {
               LOG_INFO("回写支付结果失败")
            }
        //    bkRecord.pos_payType= GetPosPayType(bkRecord.pay_ebcode); 
        //    //更新数据到SQL Server中
        //    database.setReturnToRecord(bkRecord);
        }
        closesocket(sockPayRecvClient);
    }
    delete []payRecvBuf;
    sqlite.closeSQLite();
    return 0;
}
*/
//外卖线程
#define CHINA_CHAR_START   0x80
#define LATIN_CTRL_START   0x80
#define LATIN_CTRL_END     0x9F
#define C_MASK             0x7F

//转换前后长度不变
void utf8_to_latin1(char * pcSrcStr, char *pcDstStr)
{
    int strLen = strlen(pcSrcStr);
    
    for(int idx = 0; idx < strLen; idx++)
    {
        unsigned char cc = (unsigned char)pcSrcStr[idx];
        if (LATIN_CTRL_START <= cc && LATIN_CTRL_END >= cc)  
        {
            cc &= C_MASK;
            cc += 1;
        }
        
        pcDstStr[idx] = cc;
    }
    
    pcDstStr[strLen] = 0;
}

//转换前后长度不变，pcSrcStr从数据库里读出来后，要在最后一字符后面一个字节置0，即字符结束符
void latin1_to_utf8(char * pcSrcStr, char *pcDstStr)
{
    int strLen = strlen(pcSrcStr);
    int cFlag = 0;
    
    for(int idx = 0; idx < strLen; idx++)
    {
        unsigned char cc = (unsigned char)pcSrcStr[idx];
        
        if (cFlag)
        {
            if (CHINA_CHAR_START > cc)
            {
                cc--;
                cc |= (~C_MASK);
            }  
            
            cFlag = 0;          
        }
        else
        {
            if (CHINA_CHAR_START <= cc)  
            {
                cFlag = 1;            
            }
        }        
        
        pcDstStr[idx] = cc;
    }  
    pcDstStr[strLen] = 0;  
}

void *FunTakeaway(void* lpParamter)
{      
    int socket_fd, connect_fd;
    struct sockaddr_in servaddr;
    char* takeWayRecvBuf = new char[BUFFER_SIZE];       //支付数据接收区
    int nRecvLen = 0;

    TakeawayOrder order;
    int nErrCode = EC_OK;

    //初始化Socket  
    if((socket_fd = socket(AF_INET, SOCK_STREAM, 0)) == -1 ){  
        LOG(ERROR)<<"create takeway socket error:"<<strerror(errno)<<" errno:"<<errno;
        exit(0);  
    }  
    //初始化  
    memset(&servaddr, 0, sizeof(servaddr));  
    servaddr.sin_family = AF_INET;  
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);//IP地址设置成INADDR_ANY,让系统自动获取本机的IP地址。  
    servaddr.sin_port = htons(TAKEWAY_PORT);//设置的端口为DEFAULT_PORT  
  
      // 设置套接字选项避免地址使用错误  
    int flag = 1;
    if ((setsockopt(pay_server_fd, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag)))<0)
    {  
        LOG(ERROR)<<"setsockopt takeway failed";
        exit(0);
    } 

    //将本地地址绑定到所创建的套接字上  
    if( bind(socket_fd, (struct sockaddr*)&servaddr, sizeof(servaddr)) == -1){  
        LOG(ERROR)<<"bind takeway socket error:"<<strerror(errno)<<" errno:"<<errno;
        exit(0);  
    }  
    //开始监听是否有客户端连接  
    if( listen(socket_fd, 10) == -1){  
        LOG(ERROR)<<"listen takeway socket error:"<<strerror(errno)<<" errno:"<<errno;
        exit(0);  
    }  
    LOG(INFO)<<"======waiting for takeway client's request======";

    while(!g_exit){  
        //阻塞直到有客户端连接，不然多浪费CPU资源。  
        if( (connect_fd = accept(socket_fd, (struct sockaddr*)NULL, NULL)) == -1){  
            LOG(ERROR)<<"accept socket error:"<<strerror(errno)<<" errno:"<<errno;  
            continue;  
        }  
        //接受客户端传过来的数据  
        int rlt = socketRecvData(takeWayRecvBuf, BUFFER_SIZE, connect_fd);
        if (rlt > 0)
        {
            takeWayRecvBuf[rlt] = '\0';
            //int lenGBK = CCodeConv::UTF8ToGBK(takeWayRecvBuf,NULL,NULL);
            //char* strGBK = new char[lenGBK];
            //CCodeConv::UTF8ToGBK(takeWayRecvBuf,strGBK,lenGBK);
            
            //--------------------test
            // char* latinbuf = new char[rlt+1];  
            // utf8_to_latin1(takeWayRecvBuf,latinbuf);
            // LOG(INFO)<<"++++++++utf8转latin："<<latinbuf;

            // char* utf8buf = new char[rlt+1];  
            // latin1_to_utf8(latinbuf,utf8buf);
            // LOG(INFO)<<"++++++++latin转utf8："<<utf8buf;
            // delete[] utf8buf;
            // delete[] latinbuf;
            //---------------test end
            //
            LOG(INFO)<<"外卖请求："<<takeWayRecvBuf;
            order.vecProducts.clear();
            GetTakeawayOrder(takeWayRecvBuf,order);
            //根据请求类型进行不同操作
            int statusCode;
            std::string msg;

            if(order.fm_cmd  == "put_order")
            {
                LOG(INFO)<<"新外卖订单，fmId:"<<order.fm_id.data();
                
                nErrCode = dbOperation->SetTakeawayOrder(order);
                LOG(INFO)<<"---------------nErrCode："<<nErrCode;
                if(nErrCode == EC_OK)
                {
                    statusCode = 100;
                    msg = "";
                }
                else if(nErrCode == EC_EXIST_ORDER){
                    statusCode=100;
                    msg = "order exist";
                }
                else 
                {
                    statusCode=101;
                    msg = "order：write error";
                }                
            }
            else if(order.fm_cmd  == "refund_order")
            {
                LOG(INFO)<<"-----------------------------------退单";
                nErrCode = dbOperation->CancleTakeaway(order);
                if(nErrCode == EC_OK)
                {
                    statusCode = 100;
                    msg = "";
                }
                else if(nErrCode == EC_NOTEXIST_ORDER){
                    LOG(INFO)<<"退单:该订单不存在或者已退单";
                    statusCode = 100;
                    msg = "refund order:this order not exist or has been refunded";
                }
                else
                {
                    statusCode = 101;
                    msg = "refund order：write error";
                }
            }
            else if(order.fm_cmd  == "get_menu"){
                LOG(INFO)<<"------get pos menu------";
                std::vector<PrinterMenu> &vecMenu = dbOperation->GetPOSMenu();
                std::map<std::string, std::vector<SetMenuItem>> &mapSetMenu = dbOperation->GetSetMenu();
                // for(auto menu:vecMenu){
                //     LOG(INFO)<<"idMenu"<<menu.idMenu<<" idPrinter:"<<menu.idPrinter<<" device:"<<menu.device;
                // }
                std::string resJson = GetPOSMenuJson(vecMenu,mapSetMenu);
                //LOG(INFO)<<"res JOSN"<<resJson.data();
                // statusCode=1001;
                // msg="hello world";
                // std::string strReturnJson = GetTakeawayResultJson(statusCode,msg.data());
                socketSendData(resJson.data(), connect_fd);
            }
            LOG(INFO)<<"外卖:"<<order.order_index<<" 写数据库:"<<statusCode;
            //delete[] strGBK;

            if(order.fm_cmd  == "put_order" || order.fm_cmd  == "refund_order")
            {
                std::string strReturnJson = GetTakeawayResultJson(statusCode,msg.data());
                //发送返回数据    
                //int result = send(connect_fd, strReturnJson.data(), strReturnJson.length(), 0);                
                int result = socketSendData(strReturnJson.data(), connect_fd);
                LOG(INFO)<<"外卖发送处理结果："<<strReturnJson.c_str();
            }
            close(connect_fd);
        }  
    }  
    close(socket_fd);
    delete[] takeWayRecvBuf;
}


//socket 数据接收
//返回值   成功：接收长度
//         失败：  -1 
int socketRecvData(char * recvBuf, int bufSize, int socket_fd)
{
    int rcvedLength = 0;
    int rcvFlag = 0; //firstly, to rcv header
    int needLength = sizeof(FMSOCKHEADER);
    int rlt = 0;

    FMSOCKHEADER headx;
    char * pcRcvBufer = (char *)(&headx);

    while(0 < needLength)
    {
        //接收并打印客户端数据
		int length = recv(socket_fd, pcRcvBufer + rcvedLength, needLength, 0);
        if (0 < length)
        {
            needLength -= length;
            rcvedLength += length;

            if (0 == needLength)
            {
                if (0 == rcvFlag)
                {
					//header rcved complete
                    rcvFlag = 1;//to rcv payload

                    int flag = headx.flag;
                    int len  = headx.len;
                    int ver  = headx.ver;

                    //need to check payloadLength is valid or not
                    if(len > bufSize)
                    {
                        rlt = -1;
						LOG(ERROR)<<"socket recv 接收数据长度大于接收缓冲区："<<len;
						break;
                    }
                    needLength = len;
                    pcRcvBufer = recvBuf;
                    rcvedLength = 0;
                    continue;
                }
                else
                {
					//payload rcved complete
                    rlt = rcvedLength;
                    break;
                }
            }
        }
        else if(length == 0)
        {
			//socket error
            rlt = -1;
			LOG(ERROR)<<"socket recv 返回值:"<<length;
            break;
        }
    }
    return rlt;
}

//通过 sockClient 发送数据
int socketSendData(const char * sendBuf, int socket_fd)
{
    int toSendLength = strlen(sendBuf);
    char * pcSendBuf = (char *)sendBuf;
    int curSendLength = 0;
    int rlt=0;

    while(curSendLength < toSendLength)
    {
		int res = send(socket_fd, pcSendBuf + curSendLength, toSendLength - curSendLength, 0);

        if(res == SOCKET_ERROR)
		{
			LOG(ERROR)<<"发送数据给fm服务端失败！";
			rlt=-1;
            break;
        }

        curSendLength += res;
    }
    if(curSendLength != toSendLength)
	{
        rlt=-1;
		LOG(ERROR)<<"socket数据发送不完整！";
    }
    return rlt;
}
