//订单信息相关操作

#ifndef ORDERINFO_H
#define ORDERINFO_H

#include "../base/IOperation.h"
#include "../base/MySQLService.h"
#include <pthread.h>  
#include <unistd.h>  

#define IN
#define OUT

//菜品信息（兼容套餐）
struct DishInfo
{
    int consume_num;               //数量
    int original_price;            //价格
    std::string pid;                //商品编码
    int index;                     //父商品索引
    int childCount;                //子类数量
    int type;
    std::string isPrintCheck;
};

class COrderInfo:public IOperation
{
public:
    COrderInfo();
    virtual ~COrderInfo();

    //初始化操作
    int DBConnect();
    int Init();

    //根据订单id从数据库中查找订单信息
    int GetOrderInfo(IN std::string &strOrderId,
                            OUT FM_ORDER_INFO **pFMOrderInfo);

    //监测是否有新订单产生
    int MonitorNewOrder(OUT std::string & strNewOrderId);

    //向数据库中写入支付结果信息
    int SetPayResult(IN std::string& strOrderId,                //订单id
                            IN std::string& strStatusCode,       //错误码
                            IN std::string& strPayType);       //支付类型

    //所有的清除操作
    void UnInit();

    //释放为订单数据结构申请的内存
    //在GetOrderInfo()函数中申请
    void FreeOrderBuf(FM_ORDER_INFO * pbuf);

    //设置 非码-商户 支付类型对照表
    void SetPayTypes(std::vector<fmPOSType> &vecPay);

    //设置 非码-商户 外卖类型对照表
    void SetTakewayTypes(std::vector<fmPOSType> &vecTakeway);
    //////////////////////////////////////////////////////////////////////////
    //外卖订单相关操作

    //设置外卖订单信息数据表
    int SetTakeawayOrder(TakeawayOrder &order);

    //外卖退单数据库操作
    int CancleTakeaway(TakeawayOrder &order);
    //////////////////////////////////////////////////////////////////////////
    
    std::vector<PrinterMenu>& GetPOSMenu();
    //获取套餐信息
    std::map<std::string, std::vector<SetMenuItem>>& GetSetMenu();

    std::string m_FMPay;

    std::string m_LastPayId;
    bool m_bFirstTime;            //第一次查询

private:
    void GetPosPayType(IN std::string fmPayType,OUT fmPOSType &payType);
    void GetTakewayType(IN std::string strType,OUT fmPOSType &takewayType);

    std::vector<fmPOSType> vecPayTypes;         //非码-商户 支付类型对应表
    std::vector<fmPOSType> vecTakewayTypes;     //非码-商户 外卖类型对应表
    std::vector<PrinterMenu> vecPrinterMenus;   //菜单-打印机 类型对应表
    std::vector<std::string> vecSetMenu;        //菜单中是套餐的项目
    std::map<std::string, std::vector<SetMenuItem>> mapSetMenu;     //套餐（key:套餐id、value:套餐条目）

    char* UTF8ToLatin1(const char *str);
    void CleanOldData();       //清理超过六个月数据

    //获取菜品对应打印机及打印设备
    bool GetMenuPrinter();

    //向数据库总添加：fmTemp表 | 触发器 | fmTakeaway表 | fmTakeaway_products表 
    int AddFMTable();

    pthread_mutex_t mutex; //互斥锁
    MySQLService *mysql;
    DB db;
    char* _tempLatin1;    //utf8转换为Latin1后，存放在此变量中
    std::string strMonitorDeamon;  //monitor守护进程脚本文件路径
    std::string strTakeoutDeamon;  //takeout守护进程脚本文件路径
    int _percent;            //商户从平台拿到百分比(总订单金额)
};

#endif
