//订单信息相关操作

#ifndef ORDERINFO_H
#define ORDERINFO_H

#include "../base/IOperation.h"
#include "../base/MySQLService.h"
#include <pthread.h>  
#include <unistd.h>  

#define IN
#define OUT

//菜品信息（兼容套餐）
struct DishInfo
{
    int consume_num;               //数量
    int original_price;            //价格
    std::string pid;                //商品编码
    int index;                     //父商品索引
    int childCount;                //子类数量
    int type;
    std::string isPrintCheck;
};

class COrderInfo:public IOperation
{
public:
    COrderInfo();
    virtual ~COrderInfo();

    //初始化操作
    int DBConnect();
    int Init();

    //根据订单id从数据库中查找订单信息
    int GetOrderInfo(IN std::string &strOrderId,
                            OUT FM_ORDER_INFO **pFMOrderInfo);

    //监测是否有新订单产生
    int MonitorNewOrder(OUT std::string & strNewOrderId);

    //向数据库中写入支付结果信息
    int SetPayResult(IN std::string& strOrderId,                //订单id
                            IN std::string& strStatusCode,       //错误码
                            IN std::string& strPayType);       //支付类型

    //所有的清除操作
    void UnInit();

    //释放为订单数据结构申请的内存
    //在GetOrderInfo()函数中申请
    void FreeOrderBuf(FM_ORDER_INFO * pbuf);

    //设置 非码-商户 支付类型对照表
    void SetPayTypes(std::vector<fmPOSType> &vecPay);

    //设置 非码-商户 外卖类型对照表
    void SetTakewayTypes(std::vector<fmPOSType> &vecTakeway);
    //////////////////////////////////////////////////////////////////////////
    //外卖订单相关操作

    //设置外卖订单信息数据表
    int SetTakeawayOrder(IN TakeawayOrder &order,OUT std::string &orderId);

    //外卖退单数据库操作
    int CancleTakeaway(TakeawayOrder &order);
    //////////////////////////////////////////////////////////////////////////
    
    std::vector<PrinterMenu>& GetPOSMenu();
    //获取套餐信息
    std::map<std::string, std::vector<SetMenuItem>>& GetSetMenu();

    //小票打印
    int PrintLable(LableObj &print);

    std::string m_FMPay;

    std::string m_LastPayId;
    bool m_bFirstTime;            //第一次查询

private:
    void GetPosPayType(IN std::string fmPayType,OUT fmPOSType &payType);
    void GetTakewayType(IN std::string strType,OUT fmPOSType &takewayType);

    std::vector<fmPOSType> vecPayTypes;         //非码-商户 支付类型对应表
    std::vector<fmPOSType> vecTakewayTypes;     //非码-商户 外卖类型对应表
    std::vector<PrinterMenu> vecPrinterMenus;   //菜单-打印机 类型对应表
    std::vector<std::string> vecSetMenu;        //菜单中是套餐的项目
    std::map<std::string, std::vector<SetMenuItem>> mapSetMenu;     //套餐（key:套餐id、value:套餐条目）

    void CleanOldData();       //清理超过六个月数据

    int charset_convert(const char* charset_from, const char* charset_to
                        , const std::string& string_from, std::string& string_to);

    /* 功能:utf8转GB18030
     * 参数:[1]utf8字符
     * 返回:GB18030字符
     * */
    std::string charset_u2g(const std::string& utf8);

    //获取菜品对应打印机及打印设备
    bool GetMenuPrinter();

    //向数据库总添加：fmTemp表 | 触发器 | fmTakeaway表 | fmTakeaway_products表 
    int AddFMTable();
    void rollbackData(std::string orderid);
    int AddDiscountType();             //添加优惠类型

    pthread_mutex_t mutex; //互斥锁
    MySQLService *mysql;
    DB db;
    std::string strMonitorDeamon;  //monitor守护进程脚本文件路径
    std::string strTakeoutDeamon;  //takeout守护进程脚本文件路径

    int _merchantDisId;      //优惠类型id(商户减免)
    int _plantformFeeId;     //优惠类型id(平台服务费)
    std::string _boxSku;     //餐盒SKU
};

#endif
