#ifndef IOPERATION_H 
#define IOPERATION_H  
#include <iostream>
#include <map>
#include "BaseDefine.h"
#include "CommonStruct.h"

#define IN
#define OUT

class IOperation 
{  
public:
    //初始化操作
    virtual int DBConnect()=0;
    virtual int Init()=0;

    //根据订单id从数据库中查找订单信息
    virtual int GetOrderInfo(IN std::string &strOrderId,
        OUT FM_ORDER_INFO **pFMOrderInfo)=0;

    //监测是否有新订单产生
    virtual int MonitorNewOrder(OUT std::string & strNewOrderId)=0;

    //向数据库中写入支付结果信息
    virtual int SetPayResult(IN std::string& strOrderId,                //订单id
        IN std::string& strStatusCode,       //错误码
        IN std::string& strPayType)=0;       //支付类型

    //所有的清除操作
    virtual void UnInit()=0;

    //释放为订单数据结构申请的内存
    //在GetOrderInfo()函数中申请
    virtual void FreeOrderBuf(FM_ORDER_INFO * pbuf)=0;

    //设置 非码-商户 支付类型对照表
    virtual void SetPayTypes(std::vector<fmPOSType> &vecPay)=0;

    //设置 非码-商户 外卖类型对照表
    virtual void SetTakewayTypes(std::vector<fmPOSType> &vecTakeway)=0;
    //////////////////////////////////////////////////////////////////////////
    //外卖订单相关操作

    //设置外卖订单信息数据表
    virtual int SetTakeawayOrder(IN TakeawayOrder &order,OUT std::string &orderId)=0;

    //外卖退单数据库操作
    virtual int CancleTakeaway(TakeawayOrder &order)=0;

    //获取POS菜单
    virtual std::vector<PrinterMenu>& GetPOSMenu()=0;

    //获取套餐信息（套餐包含项目）
    virtual std::map<std::string, std::vector<SetMenuItem>>& GetSetMenu()=0;
    virtual int PrintLable(LableObj &print)=0;
};  

#ifdef WIN32
bool _declspec(dllimport) GetOperationObject(void** _RtObject);  
#else
bool GetOperationObject(void** _RtObject);  
#endif

#endif  