#include "utility.h"
#include <stdio.h> 
#include <stdlib.h> 
#include <cstring>
#include <stdarg.h> 

#ifdef WIN32
#include <Windows.h>
#else
#include <unistd.h>
#endif

//: GetProcDir() 
//  : ȡǰ· 
std::string GetProcDir()
{
    std::string strDir;
#ifdef WIN32
#else    
    char szBuffer[256]; 
    int npos = 0; 
    npos = readlink( "/proc/self/exe", szBuffer, 256 ); 
    if ( npos < 0 || npos >= 256 ) 
    { 
        printf( "readlink failed.\n" ); 
        return strDir; 
    } 
    szBuffer[npos] = '\0'; 
    char *ptr = NULL;  
    char c = '/';      
    ptr = strrchr(szBuffer,c);  
    if(ptr != NULL)
        *(ptr +1) = 0;
    strDir = szBuffer;
#endif
    return strDir;
}

#ifdef _DO_NOT_HAVE_S
int sprintf_s(
    char *buffer,
    size_t sizeOfBuffer,
    const char *format ,...)
{
    va_list ap;

    va_start(ap, format);
    int res = vsprintf(buffer, format, ap);
    va_end(ap);
    return res;
}
#endif

#ifdef WIN32
#else
void OutputDebugString(const char* lpOutputString)
{

}
#endif