// FMDbMonitor.cpp : 定义控制台应用程序的入口点。
//

#include <iostream>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <pthread.h>
#include <ifaddrs.h>
#include <string.h>
#include "../base/FM_ErrorCode.h"
#include "SQLiteOperate.h"
#include "PayProcess.h"
#include "json.h"
#include "../utility/utility.h"
#include "../utility/zini.h"

#define ELPP_NO_DEFAULT_LOG_FILE
#include "../3rdParty/easylogging/easylogging++.h"


#define BUFFER_SIZE             1024 //缓冲区大小
void InitSystem();
void Init();
INITIALIZE_EASYLOGGINGPP

//IOperation *dbOperation;       //订单相关操作类
void app_stopped(int sig);      //SIGINT(Ctrl + C)

int main()
{
    /*HANDLE hObject = CreateMutex(NULL,FALSE,L"FmSingleMonitorConsole");
    if(GetLastError() == ERROR_ALREADY_EXISTS)
    {
        CloseHandle(hObject);
        MessageBox(NULL,L"程序已经运行!",NULL,NULL);
        return FALSE;
    }*/
    el::Loggers::addFlag(el::LoggingFlag::StrictLogFileSizeCheck);
    std::string strLogPath = GetProcDir(); 
    strLogPath.append("log.conf");
    el::Configurations conf(strLogPath.data());
    /// 设置全部logger的配置  
    el::Loggers::reconfigureAllLoggers(conf);

    InitSystem();

    //获取dll对象
    void* pObj=NULL;  
    if(GetOperationObject(&pObj))
    {
        dbOperation=(IOperation*)pObj;  
    }
    else
    {
        LOG(INFO)<<"调用动态库失败";
        return false;
    }

    //SetUnhandledExceptionFilter(FMExcpHandler); 
    signal(SIGINT, app_stopped);
    LOG(INFO)<<"启动 FMDbMonitor";

    int nrlt = EC_OK;
    while (dbOperation->DBConnect()!= EC_OK)
    {
        LOG(INFO)<<"连接数据库错误";
        sleep(1);
    }
    LOG(INFO)<<"连接数据库成功";
    Init();
    std::string strNewOrderId;          //新订单id
    FM_ORDER_INFO * pstOrderData;
    

    int    sockfd;
    char    sendline[4096];
    struct sockaddr_in    servaddr;

    while(true)
    {
        LOG(INFO)<<"监测新订单...";
        int nrlt = dbOperation->MonitorNewOrder(strNewOrderId);
        LOG(INFO)<<"新订单，订单id:"<<strNewOrderId.c_str();
        if(nrlt != EC_OK)
        {
            LOG(INFO)<<"监测新订单错误："<<nrlt;
            continue;
        }
        pstOrderData = NULL;
        sleep(1);      //由于获取数据时，数据库可能还未准备好，所以增加延时
        nrlt = dbOperation->GetOrderInfo(strNewOrderId,&pstOrderData);

        if( nrlt!= EC_OK)
        {
            if(nrlt == EC_NOT_FM_PAY_MODE)
            {
                LOG(INFO)<<"不是非码支付类型";
            }
            else
            {
                LOG(INFO)<<"获取订单信息错误："<<nrlt;
            }
            dbOperation->FreeOrderBuf(pstOrderData);
            continue;
        }
        float fPayTotal = stof(pstOrderData->payTotal);
        if(fPayTotal < 0.000001)
        {
            LOG(INFO)<<"订单金额："<<nrlt;
            dbOperation->FreeOrderBuf(pstOrderData);
            continue;
        }
        LOG(INFO)<<"新订单："<<strNewOrderId.c_str();
        ////------------------数据包装-------------------------

        std::string payJson = GetPayJson(*pstOrderData); //支付
        ////------------------数据包装 end----------------------

        dbOperation->FreeOrderBuf(pstOrderData);

        //--------------------转发数据--------------------------------

        //新建客户端socket
        //transSockClient = socket(AF_INET, SOCK_STREAM, 0);
        ////定义要连接的服务端地址
        //transAddrServer.sin_addr.S_un.S_addr = inet_addr("127.0.0.1");//目标IP(127.0.0.1是回送地址)
        //transAddrServer.sin_family = AF_INET;
        //transAddrServer.sin_port = htons(23770);//连接端口

        ////连接到服务端
        //int con= connect(transSockClient, (SOCKADDR*)&transAddrServer, sizeof(SOCKADDR));
        //if(con != 0)
        //{
        //    con = WSAGetLastError();
        //    LOG_ERROR("连接fm服务端失败！错误值：%d",con)
        //    continue;
        //}

        ////发送数据
        //int rlt = socketSendData(payJson.data(), transSockClient);


        if( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
        {
            LOG(ERROR)<<"create socket error:"<<strerror(errno)<<" errno:"<<errno;
            exit(0);
        }

        memset(&servaddr, 0, sizeof(servaddr));
        servaddr.sin_family = AF_INET;
        servaddr.sin_port = htons(23770);
        if( inet_pton(AF_INET, "127.0.0.1", &servaddr.sin_addr) <= 0)
        {
            LOG(ERROR)<<"inet_pton error";
            exit(0);
        }


        if( connect(sockfd, (struct sockaddr*)&servaddr, sizeof(servaddr)) < 0){
            LOG(ERROR)<<"connect error:"<<strerror(errno)<<" errno:"<<errno;
            exit(0);
        }


        LOG(INFO)<<"send msg to server: "<<payJson.c_str();
        int rlt =  send(sockfd, payJson.c_str(), strlen(payJson.c_str()), 0);
        if(rlt < 0)
        {
            LOG(ERROR)<<"send msg error:"<<strerror(errno)<<" errno:"<<errno;
            exit(0);
        }

        if(0 == rlt && payJson.length() < BUFFER_SIZE*20)
        {
            LOG(INFO)<<"发送给服务端支付数据："<<payJson.data();
        }

        //关闭socket
        close(sockfd);
    }
    return 0;
}

void Init()
{
    //读取sqlite中基础信息
    SQLite sqlite;
    sqlite.initSQLite(); 
    sqlite.GetPayTypeFromDB();
    sqlite.GetTakewayTypeFromDB();
    if(sqlite.vecPay.size()==0)
    {
        LOG(INFO)<<"未读取到支付类型";
    }
    dbOperation->SetPayTypes(sqlite.vecPay);

    if(sqlite.vecTakeway.size()==0)
    {
        LOG(INFO)<<"未读取到外卖类型";
    }
    dbOperation->SetTakewayTypes(sqlite.vecTakeway);
    sqlite.closeSQLite();
    int ret = dbOperation->Init();
    if(ret!=EC_OK){
        LOG(INFO)<<"dbOperation->Init() "<<ret;
        exit(0);
    }
    

    pthread_t id;
    ret = pthread_create(&id, NULL, PayRecv, NULL);

    ////支付返回值监控线程
    //hPayRecv = CreateThread(NULL, 0, FunPayRecv, NULL, 0, NULL);

    //启动外卖监控线程
    pthread_t takewayId;
    ret = pthread_create(&takewayId, NULL, FunTakeaway, NULL);

    //启动打印线程
    pthread_t printId;
    ret = pthread_create(&printId, NULL, FunPrintLable, NULL);
}

void app_stopped(int sig)
{
    LOG(INFO)<<"退出 FMDBMonitor";
    g_exit = true;
    close(pay_server_fd);
    shutdown(pay_server_fd, SHUT_RDWR); 
    return;
}

void InitSystem()
{
    std::string strIniPath = GetProcDir();  
    strIniPath.append("monitor.ini");
    std::string pos = ZIni::readString("SYS","pos", "",strIniPath.c_str());
    std::string serverip = ZIni::readString("SYS","serverip", "",strIniPath.c_str());
    if(pos.compare("bifengtang")==0){
        LOG(INFO)<<"避风塘POS";
        struct ifaddrs * ifAddrStruct=NULL;
        void * tmpAddrPtr=NULL;

        getifaddrs(&ifAddrStruct);

        while (ifAddrStruct!=NULL) {
            if (ifAddrStruct->ifa_addr->sa_family==AF_INET) { // check it is IP4
                // is a valid IP4 Address
                std::string ifaName=ifAddrStruct->ifa_name;
                if(ifaName.compare("eth0")==0){
                    tmpAddrPtr=&((struct sockaddr_in *)ifAddrStruct->ifa_addr)->sin_addr;
                    char addressBuffer[INET_ADDRSTRLEN];
                    inet_ntop(AF_INET, tmpAddrPtr, addressBuffer, INET_ADDRSTRLEN);
                    std::string ip=addressBuffer;
                    if(serverip.compare(ip)==0){
                        return;
                    }
                    else{
                        LOG(INFO)<<"运行机器ip:"<<addressBuffer<<" 不是服务端，程序退出！";
                        exit(0);
                    }
                }

            }
            ifAddrStruct=ifAddrStruct->ifa_next;
        }
    }


}