﻿
#include "SQLiteOperate.h"
#include "rapidjsonheader.h"
#include "../utility/utility.h"
#include "../utility/zini.h"
#include "../3rdParty/easylogging/easylogging++.h"
#include <sqlite3.h>
#include <iostream>

#define BUFFER_SIZE             1024 //缓冲区大小
using namespace std;

std::vector<fmPOSType> vecPayTypes;   
std::vector<fmPOSType> vecTakewayTypes;   

SQLite::SQLite()
{
    pDB=NULL;
    errMsg=NULL;
}

SQLite::~SQLite()
{

}

bool SQLite::initSQLite()
{
    std::string strDbFileName;      //*.db 名称
    std::string strPath = GetProcDir();	
    strPath.append("fmdata.db");
    strDbFileName = strPath;

    //打开一个数据库，如果改数据库不存在，则创建一个名字为databaseName的数据库文件
    int res = sqlite3_open(strDbFileName.c_str(), &pDB);
    LOG(INFO)<<"DbFileName:"<<strDbFileName.c_str();
    if(res != SQLITE_OK)
    {
        LOG(ERROR)<<"打开数据库失败:"<<strDbFileName.data();
        return false;
    }
    try
    {
        createTable(); 
    }
    catch(exception &ex)
    {
        LOG(ERROR)<<"创建表异常："<<ex.what();
        return false;
    }
    return true;
}

bool SQLite::createTable()
{
    //插入一个表，返回值为SQLITE_OK为成功，否则输出出错信息
    //函数参数：第一个为操作数据库的指针，第二句为SQL命令字符串
    //第三个参数为callback函数，这里没有用，第四个参数为callback函数
    //中的第一个参数，第五个为出错信息
    int res = sqlite3_exec(pDB, "create table IF NOT EXISTS fmMemberPayReturn(\
                                fm_id varchar(50) NOT NULL,\
                                statusCode int, \
                                msg varchar(200),\
                                prompt bool,\
                                fm_open_id varchar(50),\
                                total_amount int,\
                                paid_total_amount int,\
                                invoice_amount int,\
                                incentives_amount int,\
                                logtime TIMESTAMP default (datetime('now', 'localtime')),\
                                PRIMARY KEY (fm_id))", 0, 0, &errMsg);
    if(res != SQLITE_OK)
    {
        LOG(ERROR)<<"创建表fmPayReturn失败："<<errMsg;
    }
    res = sqlite3_exec(pDB, "create table IF NOT EXISTS fmMemberPayTypes(\
                                fm_id varchar(50), \
                                pay_id varchar(50),\
                                pay_str varchar(50),\
                                paid_total_amount int,\
                                code varchar(50),\
                                logtime TIMESTAMP default (datetime('now', 'localtime')),\
                                FOREIGN KEY(fm_id) REFERENCES fmPayReturn(fm_id))", 0, 0, &errMsg);

    if(res != SQLITE_OK)
    {
        LOG(ERROR)<<"创建表fmPayTypes失败："<<errMsg;
    }
    res = sqlite3_exec(pDB, "create table IF NOT EXISTS fmPayResult(\
                                fm_id varchar(50),\
                                trans_id varchar(50) NOT NULL,\
                                statusCode int,\
                                fm_transId varchar(50),\
                                pay_id varchar(50),\
                                pay_str varchar(50),\
                                pay_amount int,\
                                platform_discount int,\
                                merchant_discount int,\
                                msg varchar(100),\
                                logtime TIMESTAMP default (datetime('now', 'localtime')),\
                                PRIMARY KEY (trans_id))", 0, 0, &errMsg);
    if(res != SQLITE_OK)
        LOG(ERROR)<<"创建表fmPayResult失败："<<errMsg;

    //商户-非码 支付id 对应表
    res = sqlite3_exec(pDB, "create table IF NOT EXISTS PayType(\
                            payName varchar(50) default(0),\
                                   fmPayId varchar(50) default(0), \
                                   merchantPayId varchar(50) default(0),\
                                   ext1 varchar(50) default(0),\
                                   ext2 varchar(50) default(0),\
                                   ext3 varchar(50) default(0))", 0, 0, &errMsg);
    if(res != SQLITE_OK)
        LOG(ERROR)<<"创建表PayType失败："<<errMsg;
    //商户-非码 外卖id 对应表
    res = sqlite3_exec(pDB, "create table IF NOT EXISTS TakewayType(\
                            takewayName varchar(50) default(0), \
                            fmType varchar(50) default(0),\
                            merchantId varchar(50) default(0),\
                            ext1 varchar(50) default(0),\
                            ext2 varchar(50) default(0),\
                            ext3 varchar(50) default(0))", 0, 0, &errMsg);
    if(res != SQLITE_OK)
        LOG(ERROR)<<"创建表TakewayType失败："<<errMsg;

    return true;
}

void SQLite::closeSQLite()
{
    if(pDB)
        sqlite3_close(pDB); 
}

BackRecord SQLite::writeMemberPayDataToSQLite(const char* json)
{
    BackRecord record;
    std::string fmId;
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        // 可通过GetParseError()取得出错代码，
        // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
        // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
        // 函数GetErrorOffset()返回出错发生的位置
        LOG(ERROR)<<"json parse error:"<<document.GetParseError()<<":"<<document.GetErrorOffset();
    }
    else
    {
        vector<PayWay> vecPayWays;
        rapidjson::Value& statusCode = document["statusCode"];
        if(statusCode.GetInt()!=100){
            LOG(ERROR)<<"支付失败";
            return record;
        }

        rapidjson::Value& msg = document["msg"];
        rapidjson::Value& prompt = document["prompt"];
        rapidjson::Value& fm_open_id = document["fm_open_id"];
        rapidjson::Value& fm_id = document["fm_id"];
        rapidjson::Value& total_amount = document["total_amount"];
        rapidjson::Value& paid_total_amount = document["paid_total_amount"];
        rapidjson::Value& invoice_amount = document["invoice_amount"];
        rapidjson::Value& incentives_amount = document["incentives_amount"];
        rapidjson::Value& pay_ids = document["pay_ids"];
        if(pay_ids.IsArray()){
            for(unsigned int i=0;i<pay_ids.Size();i++){
                PayWay payway;
                rapidjson::Value& objValue = pay_ids[i];

                rapidjson::Value& pay_id = objValue["pay_id"];
                rapidjson::Value& pay_str = objValue["pay_str"];
                rapidjson::Value& paid_total_amount = objValue["paid_total_amount"];
                payway.pay_id=pay_id.GetString();
                payway.pay_str=pay_str.GetString();
                payway.paid_total_amount=paid_total_amount.GetInt();
                // 判断某成员是否存在
                if (objValue.HasMember("code"))
                {
                    rapidjson::Value& code = objValue["code"];
                    payway.code=code.GetString();
                }
                vecPayWays.push_back(payway);
            }
        }

        bool isSuccess=true;
        char sqlValue1[BUFFER_SIZE];
        sprintf_s(sqlValue1, BUFFER_SIZE,
            "insert into fmMemberPayReturn(fm_id, statusCode,msg,prompt,fm_open_id,total_amount,paid_total_amount,invoice_amount,incentives_amount)\
                           values('%s',%d, '%s',%d,'%s',%d,%d,%d,%d)", fm_id.GetString(),statusCode.GetInt(),msg.GetString(),prompt.GetInt(),fm_open_id.GetString(),\
                          total_amount.GetInt(),paid_total_amount.GetInt(),invoice_amount.GetInt(),incentives_amount.GetInt());
        int res = sqlite3_exec(pDB,sqlValue1,0,0,&errMsg);
        if(res != SQLITE_OK){
            LOG(ERROR)<<"fmMemberPayReturn 插入数据失败:"<<errMsg;
            isSuccess=false;
        }
            
        for(unsigned int i=0;i<vecPayWays.size();i++){
            char sqlValue2[BUFFER_SIZE];
            sprintf_s(sqlValue2,BUFFER_SIZE,
                "insert into fmMemberPayTypes(fm_id, pay_id,pay_str,paid_total_amount,code)values('%s','%s', '%s',%d, '%s')",\
                fm_id.GetString(), vecPayWays[i].pay_id.c_str(),vecPayWays[i].pay_str.c_str(),vecPayWays[i].paid_total_amount,vecPayWays[i].code.c_str());
            res = sqlite3_exec(pDB,sqlValue2,0,0,&errMsg);
            if(res != SQLITE_OK){
                LOG(ERROR)<<"fmMemberPayTypes 插入数据失败:"<<errMsg;
                isSuccess=false;
            }
                
        }
        if(isSuccess){
            record.fmId=fm_id.GetString();
            record.vecPayWays.assign(vecPayWays.begin(),vecPayWays.end());
        }            
    }
    return record;
}

PayBackData SQLite::writeDataToSQLite(const char* json)
{
    PayBackData record;
    std::string fmId;
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        LOG(ERROR)<<"json parse error:"<<document.GetParseError()<<":"<<document.GetErrorOffset();
    }
    else
    {
        if (!document.HasMember("statusCode"))
        {
            LOG(ERROR)<<"支付返回 json statusCode为空";
            return record;
        }
        int lengthJson = strlen(json);
        char* lpSql = new char[BUFFER_SIZE];
            
        rapidjson::Value& statusCode = document["statusCode"];
        rapidjson::Value& trans_id = document["trans_id"];
        //先检查表中是否有trans_id这个记录
        //  如果有，进行更新；
        int nResult = CheckExist("fmPayResult",trans_id.GetString());
        if( nResult == -1)
        {
            LOG(ERROR)<<"查询fmPayResult表记录失败："<<errMsg;
        }
        else
        {
            if(statusCode.GetInt() != 100)
            {
                rapidjson::Value& msg = document["msg"];                 
                if(nResult == 0)   //没有查询到记录
                {
                    sprintf_s(lpSql,BUFFER_SIZE, "insert into fmPayResult(trans_id,statusCode,msg) values('%s',%d,'%s')",
                        trans_id.GetString(),statusCode.GetInt(),msg.GetString());
                }
                else
                {
                    sprintf_s(lpSql,BUFFER_SIZE, "update fmPayResult set statusCode = %d, msg = '%s' where trans_id = '%s'",
                        statusCode.GetInt(),msg.GetString(),trans_id.GetString());
                }            
                int res = sqlite3_exec(pDB,lpSql,0,0,&errMsg);
                if(res != SQLITE_OK){
                    LOG(ERROR)<<"fmPayResult操作失败:"<<errMsg;
                }
                record.orderId=trans_id.GetString();
                record.status=statusCode.GetInt();

                LOG(INFO)<<"fm支付失败："<<trans_id.GetString()<<" statusCode:"<<record.status;
            }
            else
            {        
                rapidjson::Value& fm_id = document["fm_id"];
                rapidjson::Value& fm_transId = document["fm_transId"];
                rapidjson::Value& pay_ids = document["pay_ids"];
                rapidjson::Value& objValue = pay_ids[0];
                rapidjson::Value& pay_id = objValue["pay_id"];
                rapidjson::Value& pay_str = objValue["pay_str"];
                rapidjson::Value& pay_amount = objValue["pay_amount"];
                rapidjson::Value& platform_discount = objValue["platform_discount"];
                rapidjson::Value& merchant_discount = objValue["merchant_discount"];
                rapidjson::Value& msg = document["msg"];
                if(nResult == 0)   //没有查询到记录
                {
                    sprintf_s(lpSql,BUFFER_SIZE, 
                        "insert into fmPayResult\
                        (fm_id, trans_id,statusCode,fm_transId,pay_id,pay_str,pay_amount,platform_discount,merchant_discount,msg)\
                        values('%s','%s',100,'%s','%s','%s',%d,%d,%d,'%s')",\
                        fm_id.GetString(),trans_id.GetString(),fm_transId.GetString(),pay_id.GetString(),
                        pay_str.GetString(),pay_amount.GetInt(),platform_discount.GetInt(),
                        merchant_discount.GetInt(),msg.GetString());
                }
                else
                {
                    sprintf_s(lpSql,BUFFER_SIZE,
                        "update fmPayResult set fm_id = '%s',statusCode = 100,fm_transId = '%s',\
                        pay_id = '%s',pay_str = '%s',\
                        pay_amount = %d,platform_discount = %d,merchant_discount = %d,\
                        msg = '%s' where trans_id = '%s'",
                        fm_id.GetString(),fm_transId.GetString(),
                        pay_id.GetString(), pay_str.GetString(),
                        pay_amount.GetInt(),platform_discount.GetInt(),merchant_discount.GetInt(),
                        msg.GetString(),trans_id.GetString());
                }            

                int res = sqlite3_exec(pDB,lpSql,0,0,&errMsg);
                if(res != SQLITE_OK)
                {
                    LOG(ERROR)<<"fmPayResult 插入数据失败："<<errMsg;
                }
                record.pay_ebcode=pay_id.GetString();
                record.orderId=trans_id.GetString();
                record.status=100;                        
            }
        }
        delete[] lpSql;
    }
    return record;
}

int SQLite::CheckExist(std::string strTable,std::string strKey)
{
    char* lpSql = new char[BUFFER_SIZE];
    sprintf_s(lpSql,BUFFER_SIZE, 
        "select * from %s where trans_id = '%s'",
                                 strTable.c_str(),
                                 strKey.c_str());    
    char** pResult;  
    int nRow = 0;   
    int nCol = 0;
    int nResult = sqlite3_get_table(pDB,lpSql,&pResult,&nRow,&nCol,&errMsg);  
    delete[] lpSql;
    if (nResult != SQLITE_OK)  
    {
        LOG(ERROR)<<"sqlite3_get_table error:"<<errMsg;
        OutputDebugString(errMsg);
        return -1;
    }
    return nRow;
}

//GB2312到UTF-8的转换
std::string U2G(const char* utf8)
{
    std::string strUtf8;
    //int len = MultiByteToWideChar(CP_UTF8, 0, utf8, -1, NULL, 0);
    //wchar_t* wstr = new wchar_t[len+1];
    //memset(wstr, 0, len+1);
    //MultiByteToWideChar(CP_UTF8, 0, utf8, -1, wstr, len);
    //len = WideCharToMultiByte(CP_ACP, 0, wstr, -1, NULL, 0, NULL, NULL);
    //char* str = new char[len+1];
    //memset(str, 0, len+1);
    //WideCharToMultiByte(CP_ACP, 0, wstr, -1, str, len, NULL, NULL);
    //if(wstr) delete[] wstr;
    //strUtf8=str;
    //if(str) delete[] str;
    strUtf8 = utf8;
    return strUtf8;
}

int callbackPay(void* data,int n_columns,char** column_values,char** column_names)
{   
    try
    {
        fmPOSType payType;
        payType.strName=U2G(column_values[0]);
        payType.fmTypeId=column_values[1];
        payType.merchantTypeId=column_values[2];
        payType.ext1=column_values[3];
        payType.ext2=column_values[4];
        payType.ext3=column_values[5];
        vecPayTypes.push_back(payType);
    }
    catch(exception &ex)
    {
        LOG(ERROR)<<"读取支付数据失败:"<<ex.what();
        return -1;
    }

    return 0;
}

void SQLite::GetPayTypeFromDB()
{
    vecPayTypes.clear();
    char value[]="select * from PayType";
    int rc = sqlite3_exec(pDB,value,callbackPay, 0, &errMsg);
    if(rc== SQLITE_OK)
        vecPay.assign(vecPayTypes.begin(), vecPayTypes.end());
    else
    {
        LOG(ERROR)<<"PayType 读取数据执行失败："<<errMsg;
    }
}

int callbackTakeway(void* data,int n_columns,char** column_values,char** column_names)
{
    try
    {
        fmPOSType payType;
        payType.strName=U2G(column_values[0]);
        payType.fmTypeId=column_values[1];
        payType.merchantTypeId=column_values[2];
        payType.ext1=column_values[3];
        payType.ext2=column_values[4];
        payType.ext3=column_values[5];
        vecTakewayTypes.push_back(payType);
    }
    catch(exception &ex)
    {
        LOG(ERROR)<<"读取外卖数据失败:"<<ex.what();
        return -1;
    }

    return 0;
}

void SQLite::GetTakewayTypeFromDB()
{
    vecTakewayTypes.clear();
    char value[]="select * from TakewayType";
    int rc = sqlite3_exec(pDB,value,callbackTakeway, 0, &errMsg);
    if(rc == SQLITE_OK)
        vecTakeway.assign(vecTakewayTypes.begin(), vecTakewayTypes.end());
    else
    { 
        LOG(ERROR)<<"TakewayType 读取数据执行失败："<<errMsg;
    }
}
