// json.cpp : 定义控制台应用程序的入口点。
//

#include "json.h"
#include <iostream>
#include "../3rdParty/easylogging/easylogging++.h"

//将支付订单信息结构组合为json字串
std::string GetPayJson(FM_ORDER_INFO &OrderInfo)
{
	rapidjson::StringBuffer buffer;
	rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
	writer.StartObject();

	writer.Key("pos_ver");
	writer.Int(2);

	writer.Key("operator_id");
	writer.String(OrderInfo.operater.c_str());

    writer.Key("fm_cmd");
    writer.Int(10031);

    writer.Key("pos_id");
    writer.String(OrderInfo.pos.c_str());

	writer.Key("store_id");
	writer.String("");

    writer.Key("business_date");
    writer.String(OrderInfo.date.c_str());

	writer.Key("trans_id");
	writer.String(OrderInfo.transId.c_str());

    writer.Key("fm_id");
    writer.String("");

    writer.Key("fm_open_id");
    writer.String("");


	//---------------start transactions----------------
	writer.Key("transactions");
	
	writer.StartObject();

    writer.Key("order_amount");
    writer.Int(stoi(OrderInfo.payTotal));

    writer.Key("paid_amount");
    writer.Int(0);

    writer.Key("undis_amount");
    writer.Int(0);

	writer.Key("barcode");
	writer.String("");

	//-----------------start products------------------
	writer.Key("products");
	writer.StartArray();

	//-----------------start 单个商品------------------
	for(unsigned int i=0;i<OrderInfo.vecGoods.size();i++) 
	{
		writer.StartObject();
		writer.Key("consume_num");
		writer.Double(atof(OrderInfo.vecGoods[i].strNum.c_str()));

		writer.Key("price");
		writer.Int(int(atof(OrderInfo.vecGoods[i].strPrice.data())*100));

		writer.Key("pid");
		writer.String(OrderInfo.vecGoods[i].strId.c_str());

		writer.EndObject();
	}
	//-----------------end 单个商品------------------
	writer.EndArray();
	//-----------------end products--------------------
	writer.EndObject();
	//-----------------end transactions----------------

	writer.EndObject();

	return buffer.GetString();
}

//通过json字串获取外卖订单信息
bool GetTakeawayOrder(const char* lpJson, TakeawayOrder &order)
{
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(lpJson); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        // 可通过GetParseError()取得出错代码，
        // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
        // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
        // 函数GetErrorOffset()返回出错发生的位置
        //LOG_ERROR("TakeawayOrder JSON parse error: (%d:%d)", document.GetParseError(), document.GetErrorOffset())
    }
    else
    {
        rapidjson::Value& fm_cmd = document["fm_cmd"];
        rapidjson::Value& fm_ver = document["fm_ver"];
        order.fm_cmd=fm_cmd.GetString();
        order.fm_ver=fm_ver.GetString();
        if(order.fm_cmd  == "refund_order")
        {
            rapidjson::Value& fm_id = document["fm_id"];
            order.fm_id=fm_id.GetString();
        }
        else if(order.fm_cmd  == "get_menu"){

        }
        else
        {
            rapidjson::Value& pay_id_obj = document["pay_id"];
            if(pay_id_obj.IsObject()){
                rapidjson::Value& pay_id = pay_id_obj["pay_id"];
                rapidjson::Value& pay_str = pay_id_obj["pay_str"];
                rapidjson::Value& pay_ebcode = pay_id_obj["pay_ebcode"];
                rapidjson::Value& pay_ebcode_str = pay_id_obj["pay_ebcode_str"];
                rapidjson::Value& shop_fee = pay_id_obj["shop_fee"];
                rapidjson::Value& service_fee = pay_id_obj["service_fee"];
                rapidjson::Value& products_fee = pay_id_obj["products_fee"];
                rapidjson::Value& discount_fee = pay_id_obj["discount_fee"];
                rapidjson::Value& dis_shop_fee = pay_id_obj["dis_shop_fee"];
                rapidjson::Value& dis_platform_fee = pay_id_obj["dis_platform_fee"];
                rapidjson::Value& send_fee = pay_id_obj["send_fee"];
                rapidjson::Value& package_fee = pay_id_obj["package_fee"];
                rapidjson::Value& invoice_amount = pay_id_obj["invoice_amount"];
                rapidjson::Value& paid_trans_id = pay_id_obj["paid_trans_id"];
                rapidjson::Value& fm_id = pay_id_obj["fm_id"];
                rapidjson::Value& customer_address = pay_id_obj["customer_address"];
                rapidjson::Value& customer_name = pay_id_obj["customer_name"];
                rapidjson::Value& customer_phone = pay_id_obj["customer_phone"];
                rapidjson::Value& delivery_time = pay_id_obj["delivery_time"];
                rapidjson::Value& order_index = pay_id_obj["order_index"];
                rapidjson::Value& remark = pay_id_obj["remark"];

                order.pay_id=pay_id.GetString();
                order.pay_str=pay_str.GetString();
                order.pay_ebcode=pay_ebcode.GetString();
                order.pay_ebcode_str=pay_ebcode_str.GetString();
                order.shop_fee=shop_fee.GetInt();
                order.service_fee=service_fee.GetInt();
                order.products_fee=products_fee.GetInt();
                order.discount_fee=discount_fee.GetInt();
                order.dis_shop_fee=dis_shop_fee.GetInt();
                order.dis_platform_fee=dis_platform_fee.GetInt();
                order.send_fee=send_fee.GetInt();
                order.package_fee=package_fee.GetInt();
                order.invoice_amount=invoice_amount.GetInt();
                order.paid_trans_id=paid_trans_id.GetString();
                order.fm_id=fm_id.GetString();
                order.customer_address=customer_address.GetString();
                order.customer_name=customer_name.GetString();
                order.customer_phone=customer_phone.GetString();
                order.delivery_time=delivery_time.GetInt();
                order.order_index=order_index.GetInt();
                order.remark=remark.GetString();
            }
            rapidjson::Value& pay_ids = document["products"];
            if(pay_ids.IsArray()){
                for(unsigned int i=0;i<pay_ids.Size();i++){
                    TakeawayProduct pro;
                    rapidjson::Value& objValue = pay_ids[i];

                    rapidjson::Value& consume_num = objValue["consume_num"];
                    rapidjson::Value& pid = objValue["pid"];
                    rapidjson::Value& original_price = objValue["original_price"];
                    pro.consume_num=consume_num.GetInt();
                    pro.pid =pid.GetString();
                    pro.original_price=original_price.GetInt();
                    order.vecProducts.push_back(pro);
                }
            }
        }
    }
    return true;
}

//获取外卖订单返回结果的json字串
//      statuscode  状态码
//      msg         状态信息
std::string GetTakeawayResultJson(const int statuscode,const char* msg)
{
    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    writer.StartObject();

    writer.Key("statusCode");
    writer.Int(statuscode);

    writer.Key("msg");
    writer.String(msg);

    writer.EndObject();

    return buffer.GetString();
}

std::string GetPOSMenuJson(std::vector<PrinterMenu> &vecMenu,std::map<std::string, std::vector<SetMenuItem>> &mapSetMenu)
{
    rapidjson::Document document;
    document.SetObject();
    rapidjson::Document::AllocatorType& allocator = document.GetAllocator();

    rapidjson::Value arrayJson(rapidjson::kArrayType);

    for(int i=0;i<vecMenu.size();i++){
        rapidjson::Value obj(rapidjson::kObjectType);
        obj.AddMember("iPrinterId", vecMenu[i].iPrinterId, allocator);
        obj.AddMember("strMenuId", rapidjson::Value(vecMenu[i].strMenuId.c_str(), document.GetAllocator()), allocator);
        obj.AddMember("strMenuName", rapidjson::Value(vecMenu[i].strMenuName.c_str(), document.GetAllocator()), allocator);
        obj.AddMember("strDevice", rapidjson::Value(vecMenu[i].strDevice.c_str(), document.GetAllocator()), allocator);
        obj.AddMember("iBaud", vecMenu[i].iBaud, allocator);
        obj.AddMember("strTitle", rapidjson::Value(vecMenu[i].strTitle.c_str(), document.GetAllocator()), allocator);
        obj.AddMember("iOrderPrinterId", vecMenu[i].iOrderPrinterId, allocator);
        obj.AddMember("strOrderDevice", rapidjson::Value(vecMenu[i].strOrderDevice.c_str(), document.GetAllocator()), allocator);
        obj.AddMember("iOrderBaud", vecMenu[i].iOrderBaud, allocator);
        obj.AddMember("strOrderTitle", rapidjson::Value(vecMenu[i].strOrderTitle.c_str(), document.GetAllocator()), allocator);
        arrayJson.PushBack(obj, allocator);
    }

    document.AddMember("MenuList", arrayJson, allocator);


    //套餐转换为JSON
    //{"SetMenuMap":[{"strSetMenuId":"123456","arrayItems":[{"strMenuId":"2356","iNum":1},{}},{}]}
    rapidjson::Value arraySetMenu(rapidjson::kArrayType);
    std::map<std::string, std::vector<SetMenuItem>>::iterator iter;

    LOG(INFO) << "set menu start";
    for(iter=mapSetMenu.begin();iter!=mapSetMenu.end();iter++){  
        rapidjson::Value obj(rapidjson::kObjectType);
        obj.AddMember("strSetMenuId", rapidjson::Value(iter->first.c_str(), document.GetAllocator()), allocator);

        rapidjson::Value arrayMenu(rapidjson::kArrayType);
        for(auto menu:iter->second){
            rapidjson::Value objMenu(rapidjson::kObjectType);
            objMenu.AddMember("strMenuId", rapidjson::Value(menu.strMenuId.c_str(), document.GetAllocator()), allocator);
            objMenu.AddMember("iNum", menu.num, allocator);
            arrayMenu.PushBack(objMenu, allocator);
        }
        obj.AddMember("arrayItems", arrayMenu, allocator);

        arraySetMenu.PushBack(obj, allocator);
        //cout<<"| "<<iter->first<<" | "<<iter->second<<" |"<<endl;  
    }
    document.AddMember("SetMenuMap", arraySetMenu, allocator);

    rapidjson::StringBuffer buffer;
    rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
    document.Accept(writer);
    return buffer.GetString();
}

bool GetTakeawayPrintInfo(const char* json, LableObj &print)
{
    rapidjson::Document document; // 定义一个Document对象
    document.Parse(json); // 解析，Parse()无返回值，也不会抛异常
    if (document.HasParseError()) // 通过HasParseError()来判断解析是否成功
    {
        // 可通过GetParseError()取得出错代码，
        // 注意GetParseError()返回的是一个rapidjson::ParseErrorCode类型的枚举值
        // 使用函数rapidjson::GetParseError_En()得到错误码的字符串说明，这里的En为English简写
        // 函数GetErrorOffset()返回出错发生的位置
        //LOG_ERROR("GetTakeawayPrintInfo JSON parse error: (%d:%d)", document.GetParseError(), document.GetErrorOffset())
        return false;
    }
    else
    {
        rapidjson::Value& strDevice = document["device"];
        rapidjson::Value& iBaud = document["baud"];
        print.strDevice=strDevice.GetString();
        print.iBaud=iBaud.GetInt();

        rapidjson::Value& printObjs= document["print"];
        if(printObjs.IsArray()){
            for(unsigned int i=0;i<printObjs.Size();i++){
                LableItem obj;
                rapidjson::Value& printValue = printObjs[i];

                rapidjson::Value& vText = printValue["text"];
                rapidjson::Value& vType = printValue["type"];
                obj.strText =vText.GetString();
                obj.type=vType.GetInt();
                
                print.vecItem.push_back(obj);
            }
        }
    }
    return true;
}