// OrderInfo.cpp : 定义 DLL 应用程序的导出函数。
//怡佳仁

#include "OrderInfo.h"
#include <time.h>
#include <stdio.h>
#include "../3rdParty/easylogging/easylogging++.h"
#include "../base/FM_ErrorCode.h"

#define SQL_BUFFER_SIZE 1024


COrderInfo::COrderInfo()
:mysql(NULL)
{
	if(mysql==NULL){
		db.server="localhost";
		db.db="pos";
		db.user="root";
		db.passwd="123";
		db.timeout=0;
		db.timeout=5;
		db.interactive_timeout=5;
		mysql=new MySQLService(&db);
	}
	pthread_mutex_init(&mutex, NULL); //初始化互斥锁
}

COrderInfo::~COrderInfo()
{
	pthread_mutex_destroy(&mutex); //销毁互斥锁
}

int COrderInfo::DBConnect()
{
	if(mysql->get_db()==0){
		LOG(INFO)<<"connect to mysql success"; 
		return EC_OK;
	}
	return EC_CONNECT_FAILED;
}

//初始化操作
int COrderInfo::Init()
{   
	pthread_mutex_lock(&mutex); //上锁 
	int nErrCode = EC_OK;
	//插入外卖类型
    //////////////////////////////////////////////////////////////////////////
    for (int i=0;i<vecTakewayTypes.size();i++)
    {
    	int payType=atoi(vecTakewayTypes[i].merchantTypeId.c_str());
        snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"SELECT * FROM tbl_PayMethod where PayNo=%d",payType);
        
        nErrCode = mysql->query();
        if(nErrCode != EC_OK){
        	pthread_mutex_unlock(&mutex); //解锁
        	return EC_EX_SQL_FAILED;   
        }
        LOG(INFO)<<"strName:"<<vecTakewayTypes[i].strName.c_str();
        printf("%s\n", vecTakewayTypes[i].strName.c_str());
        if (NULL == (mysql->_row = mysql_fetch_row(mysql->_result))){
            snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"INSERT INTO tbl_PayMethod\
                                 (PayNo, SeqNo, Name3, EmpPayLevel, PayClass, PmsAskAccount)\
                                 VALUES (%d, %d,'%s', 5, 3, 0)",
                                 payType, payType, vecTakewayTypes[i].strName.c_str());
            nErrCode = mysql->insert();
            if(nErrCode != EC_OK)
            {
            	pthread_mutex_unlock(&mutex); //解锁
                return EC_EX_SQL_FAILED;
            }
        }
        else{
        	LOG(INFO)<<"PayNo:"<<mysql->_row[0]<<" name:"<<mysql->_row[4];
        }
        mysql_free_result(mysql->_result);
    }
    nErrCode = AddFMTable();
    pthread_mutex_unlock(&mutex); //解锁
	return nErrCode;
}

//所有的清除操作
void COrderInfo::UnInit()
{

}

//释放为订单数据结构申请的内存
//在GetOrderInfo()函数中申请
void COrderInfo::FreeOrderBuf(FM_ORDER_INFO * pbuf)
{
    delete pbuf;
}

//根据订单id从数据库中查找订单信息
int COrderInfo::GetOrderInfo(IN std::string& strOrderId,OUT FM_ORDER_INFO **pFMOrderInfo)
{
	return 0;
}

//监测是否有新订单产生
int COrderInfo::MonitorNewOrder(OUT std::string & strNewOrderId)
{
	LOG(INFO)<<"start monitor order";
	while(true){
		sleep(1000);
	}
	LOG(INFO)<<"out monitor order";
	return 0;
}


//向数据库中写入支付结果信息
int COrderInfo::SetPayResult(IN std::string& strOrderId,                //订单id
    IN std::string& strStatusCode,       //错误码
    IN std::string& strPayType)         //支付类型
{
	return 0;
}

//////////////////////////////////////////////////////////////////////////
//外卖订单相关操作

//设置外卖订单信息数据表
int COrderInfo::SetTakeawayOrder(TakeawayOrder &order)
{
	int nErrCode = EC_OK;
	pthread_mutex_lock(&mutex); //上锁 
	//判断记录是否存在，如果存在直接返回    
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"SELECT orderid FROM fmTakeaway where fm_id='%s';",order.fm_id.data());
    nErrCode = mysql->query();
    if(nErrCode != EC_OK){
    	pthread_mutex_unlock(&mutex); //解锁
    	return EC_EX_SQL_FAILED;   
    }
    if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
        pthread_mutex_unlock(&mutex); //解锁
        LOG(INFO)<<"订单已存在";
        return EC_EXIST_ORDER;        //订单已存在
    }
    mysql_free_result(mysql->_result);

    int orderId=0;
    //查询订单表中订单id,获取到的最大订单id加1即为新的订单id
    sprintf(mysql->sqlStr,"%s","SELECT MAX(`Check`) AS id FROM tbl_Check;");
    nErrCode = mysql->query();
    if(nErrCode != EC_OK){
    	pthread_mutex_unlock(&mutex); //解锁
    	return EC_EX_SQL_FAILED;   
    }
    if (NULL == (mysql->_row = mysql_fetch_row(mysql->_result))){
		orderId=99000000;     //初始订单id
		LOG(INFO)<<"初始订单，id:99000000";
    }
    else{
		orderId=atoi(mysql->_row[0]);
    }
    mysql_free_result(mysql->_result);
    orderId+=1;        //orderid加1
    char orderIdStr[10]={0};
	sprintf(orderIdStr,"%d",orderId);

    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE*2,
    	"insert into fmTakeaway(orderid, fm_cmd,fm_ver,customer_address,customer_name,customer_phone,delivery_time,dis_platform_fee,dis_shop_fee,discount_fee,\
    	fm_id,invoice_amount,order_index,package_fee,paid_trans_id,pay_ebcode,pay_ebcode_str,pay_id,pay_str,products_fee,remark,send_fee,service_fee,shop_fee)\
    	values('%s','%s','%s','%s','%s','%s',%d,%d,%d,%d, '%s',%d,%d,%d,'%s','%s','%s','%s','%s',%d,'%s',%d,%d,%d)", \
    	orderIdStr,order.fm_cmd.data(),order.fm_ver.data(),order.customer_address.data(),order.customer_name.data(),order.customer_phone.data(),\
    	order.delivery_time,order.dis_platform_fee,order.dis_shop_fee,order.discount_fee,order.fm_id.data(),order.invoice_amount,order.order_index,order.package_fee,\
    	order.paid_trans_id.data(),order.pay_ebcode.data(),order.pay_ebcode_str.data(),order.pay_id.data(),order.pay_str.data(),order.products_fee,order.remark.data(),\
    	order.send_fee,order.service_fee,order.shop_fee);
    nErrCode = mysql->insert();
    if(nErrCode != EC_OK)
    {
    	pthread_mutex_unlock(&mutex); //解锁
        return EC_EX_SQL_FAILED;
    }

    for(std::vector<TakeawayProduct>::size_type i=0;i<order.vecProducts.size();i++)
    {
        snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "insert into fmTakeaway_products(orderid, consume_num,original_price,pid) \
                                          values('%s',%d,%d,'%s')", \
                                          orderIdStr,order.vecProducts[i].consume_num,order.vecProducts[i].original_price,order.vecProducts[i].pid.data());
        nErrCode = mysql->insert();
    }

 	//获取系统时间，添加记录时使用
    time_t tt = time(NULL);//这句返回的只是一个时间cuo
	tm* t= localtime(&tt);
	char chTime[64] = {0};
	sprintf(chTime, "%d-%02d-%02d %02d:%02d:%02d", t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec);

	//获取门店编号
	int iOutlet=0;
	sprintf(mysql->sqlStr,"%s","SELECT Outlet FROM tbl_Outlet;");
    nErrCode = mysql->query();
    if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
		iOutlet=atoi(mysql->_row[0]);
    }
    mysql_free_result(mysql->_result);

    //获取营业日
    std::string strDate; 
	sprintf(mysql->sqlStr,"%s","SELECT `Date` FROM tbl_DayInfo WHERE Active='1';");
    nErrCode = mysql->query();
    if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
		strDate=mysql->_row[0];
    }
    mysql_free_result(mysql->_result);

    //订单写入“订单表”
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "INSERT INTO tbl_Check(`Date`,`Check`,BarCode,Outlet,`Floor`,TableNo,Cover,OpenTime,OpenPeriod,OpenStation,\
    				OpenStationRef,OpenEmp,CloseTime,ClosePeriod,CloseStation,CloseEmp,PrintCount,LastPrintTime,CheckTot,ItemTot,PayTot,IsPaid,SCRate1,\
    				IsModified,LastModifiedTime)\
					VALUES('%s',%d,'%s',%d,1,'1',4,'%s',3,99,99,4,'%s',4,99,4,1,'%s',%.2f,%.2f,%.2f,'1',0.1,1,'%s')", \
                    strDate.data(),orderId,orderIdStr,iOutlet,chTime,chTime,chTime,order.shop_fee/100.00,order.shop_fee/100.00,order.shop_fee/100.00,chTime);
    nErrCode = mysql->insert();

    //订单商品写入“订单详情表”
    for(std::vector<TakeawayProduct>::size_type i=0;i<order.vecProducts.size();i++){
	    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "INSERT INTO tbl_Item(`Date`,`Check`,Outlet,ItemIdx,Item,Name3,NameS3,`Type`,OrderTime,OrderStation,OrderEmp,\
	    				PrintQ1,PrintQ2,PrintQ3,PrintQ4,PrintQ5,IsPrintOnCheck,PrintStatus,PrintCheckStatus,PrintedOnCheck,OgnPrice,Price,PriceLevel,ModiMethod,\
	    				UnitQty,Qty,ItemTot,RvItemTot,Dept,Category,IsItemModified,LastModifiedTime)\
						VALUES('%s',%d,%d,%d,'%s','rolls','rolls',1,'%s',99,4,1,1,1,1,1,'1',4,'1',1,10.00,10,1,-1,1,1,10,10,3,104,1,'%s')", \
	                    strDate.data(),orderId,iOutlet,i+1,order.vecProducts[i].pid.data(),chTime,chTime);
	    nErrCode = mysql->insert();
	}
    
    //支付信息吸入“支付详情表”
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "INSERT INTO tbl_Payment(`Date`,`Check`,Outlet,PayIdx,PayNo,Name3,PayEmp,PayTime,PayStation,PayTot,PayClass,Member,\
    					IsModified,LastModifiedTime)\
						VALUES('%s',%d,%d,1,1,'alipay',4,'%s',99,10.00,1,'',1,'%s')", \
                    	strDate.data(),orderId,iOutlet,chTime,chTime);
    nErrCode = mysql->insert();
	return 0;
}

//外卖退单数据库操作
int COrderInfo::CancleTakeaway(TakeawayOrder &order)
{
	return 0;
}

//向数据库总添加：fmTakeaway表 | fmTakeaway_products表 
int COrderInfo::AddFMTable()
{
	int nErrCode = EC_OK;

    //添加fmTakeaway表
    snprintf(mysql->sqlStr, SQL_BUFFER_SIZE,"CREATE TABLE IF NOT EXISTS fmTakeaway (\
					orderid VARCHAR(15) NOT NULL PRIMARY KEY,\
					fm_cmd VARCHAR(30),\
					fm_ver VARCHAR(20),\
					customer_address VARCHAR(200),\
					customer_name VARCHAR(60),\
					customer_phone VARCHAR(20),\
					delivery_time INT,\
					dis_platform_fee INT,\
					dis_shop_fee INT,\
					discount_fee INT,\
					fm_id VARCHAR(50),\
					invoice_amount INT,\
					order_index INT,\
					package_fee INT,\
					paid_trans_id VARCHAR (50),\
					pay_ebcode VARCHAR (50),\
					pay_ebcode_str VARCHAR (50),\
					pay_id VARCHAR (50),\
					pay_str VARCHAR (50),\
					products_fee INT,\
					remark VARCHAR (300),\
					send_fee INT,\
					service_fee INT,\
					shop_fee INT,\
					insert_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\
					order_status INT DEFAULT 0)");
    nErrCode = mysql->exec_proc();
    //添加fmTakeaway_products表
    snprintf(mysql->sqlStr, SQL_BUFFER_SIZE,"CREATE TABLE IF NOT EXISTS fmTakeaway_products (\
					orderid VARCHAR(15) NOT NULL ,\
					consume_num INT,\
					original_price INT,\
					pid VARCHAR(20))");                                                                   
    nErrCode = mysql->exec_proc();       
    return nErrCode;
}

void COrderInfo::GetPosPayType(IN std::string fmPayType,OUT fmPOSType &payType)
{
    for (int i=0;i<vecPayTypes.size();i++)
    {
        if (vecPayTypes[i].fmTypeId==fmPayType)
        {
            payType= vecPayTypes[i];
            break;
        }
    }
}
void COrderInfo::GetTakewayType(IN std::string strType,OUT fmPOSType &takewayType)
{
    for (int i=0;i<vecTakewayTypes.size();i++)
    {
        if (vecTakewayTypes[i].fmTypeId==strType)
        {
            takewayType= vecTakewayTypes[i];
            break;
        }
    }
}

//设置 非码-商户 支付类型对照表
void COrderInfo::SetPayTypes(std::vector<fmPOSType> &vecPay)
{
	vecPayTypes.assign(vecPay.begin(), vecPay.end());
}

//设置 非码-商户 外卖类型对照表
void COrderInfo::SetTakewayTypes(std::vector<fmPOSType> &vecTakeway)
{
	vecTakewayTypes.assign(vecTakeway.begin(), vecTakeway.end());
}

//需要导出的函数，即用户在外部可以调用的接口  
bool GetOperationObject(void** _RtObject)  
{  
    IOperation* pOper = NULL;  
    pOper = new COrderInfo();  
    *_RtObject = (void*)pOper;  
    return true;  
}  
