// OrderInfo.cpp : 定义 DLL 应用程序的导出函数。
//怡佳仁

#include "OrderInfo.h"
#include <time.h>
#include <stdio.h>
#include <iconv.h>
#include "../3rdParty/easylogging/easylogging++.h"
#include "../base/FM_ErrorCode.h"
#include "../utility/utility.h"
#include "../utility/zini.h"

#define SQL_BUFFER_SIZE 1024


COrderInfo::COrderInfo()
:mysql(NULL)
,_tempLatin1(NULL)
{
	if(mysql==NULL){
        std::string strIniPath = GetProcDir();  
        strIniPath.append("monitor.ini");
        db.server = ZIni::readString("DB","ip", "",strIniPath.c_str());
        db.db = ZIni::readString("DB","dbName", "",strIniPath.c_str());
        db.user = ZIni::readString("DB","user", "",strIniPath.c_str());
        db.passwd = ZIni::readString("DB","password", "",strIniPath.c_str());
		db.timeout=5;
		db.interactive_timeout=5;
		mysql=new MySQLService(&db);

        strMonitorDeamon = ZIni::readString("SH","monitor", "",strIniPath.c_str());
        strTakeoutDeamon = ZIni::readString("SH","takeout", "",strIniPath.c_str());
        _percent = ZIni::readInt("SYS","percent", 0,strIniPath.c_str());
        if(_percent<=0){
            LOG(ERROR)<<"get percent failed,percent:"<<_percent; 
        }
        LOG(INFO)<<"percent is:"<<_percent; 
	}
	pthread_mutex_init(&mutex, NULL); //初始化互斥锁
}

COrderInfo::~COrderInfo()
{
	pthread_mutex_destroy(&mutex); //销毁互斥锁
    if(_tempLatin1!=NULL){
        delete[] _tempLatin1;
        _tempLatin1=NULL;
    }
}

int COrderInfo::DBConnect()
{
	if(mysql->get_db()==0){
		LOG(INFO)<<"connect to mysql success"; 
		return EC_OK;
	}
	return EC_CONNECT_FAILED;
}

//初始化操作
int COrderInfo::Init()
{   
	pthread_mutex_lock(&mutex); //上锁 
	int nErrCode = EC_OK;
	//插入外卖类型
    //////////////////////////////////////////////////////////////////////////
    for (int i=0;i<vecTakewayTypes.size();i++)
    {
    	int payType=atoi(vecTakewayTypes[i].merchantTypeId.c_str());
        snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"SELECT * FROM tbl_PayMethod where PayNo=%d",payType);
        
        nErrCode = mysql->query();
        if(nErrCode != EC_OK){
        	pthread_mutex_unlock(&mutex); //解锁
        	return EC_EX_SQL_FAILED;   
        }
        LOG(INFO)<<"strName:"<<vecTakewayTypes[i].strName.c_str();
        if (NULL == (mysql->_row = mysql_fetch_row(mysql->_result))){
            snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"INSERT INTO tbl_PayMethod\
                                 (PayNo, SeqNo, Name3, EmpPayLevel, PayClass, PmsAskAccount)\
                                 VALUES (%d, %d,'%s', 5, 3, 0)",
                                 payType, payType, vecTakewayTypes[i].strName.c_str());
            nErrCode = mysql->insert();
            if(nErrCode != EC_OK)
            {
            	pthread_mutex_unlock(&mutex); //解锁
                return EC_EX_SQL_FAILED;
            }
        }
        else{
        	LOG(INFO)<<"PayNo:"<<mysql->_row[0]<<" name:"<<mysql->_row[4];
        }
        mysql_free_result(mysql->_result);
    }
    nErrCode = AddFMTable();
    CleanOldData();
    pthread_mutex_unlock(&mutex); //解锁
	return nErrCode;
}

//所有的清除操作
void COrderInfo::UnInit()
{

}

//释放为订单数据结构申请的内存
//在GetOrderInfo()函数中申请
void COrderInfo::FreeOrderBuf(FM_ORDER_INFO * pbuf)
{
    delete pbuf;
}

//根据订单id从数据库中查找订单信息
int COrderInfo::GetOrderInfo(IN std::string& strOrderId,OUT FM_ORDER_INFO **pFMOrderInfo)
{
	return 0;
}

//监测是否有新订单产生
int COrderInfo::MonitorNewOrder(OUT std::string & strNewOrderId)
{
	LOG(INFO)<<"start monitor order";
	while(true){
		sleep(1000);
	}
	LOG(INFO)<<"out monitor order";
	return 0;
}


//向数据库中写入支付结果信息
int COrderInfo::SetPayResult(IN std::string& strOrderId,                //订单id
    IN std::string& strStatusCode,       //错误码
    IN std::string& strPayType)         //支付类型
{
	return 0;
}

//////////////////////////////////////////////////////////////////////////
//外卖订单相关操作

//设置外卖订单信息数据表
int COrderInfo::SetTakeawayOrder(TakeawayOrder &order)
{
	int nErrCode = EC_OK;
    fmPOSType posTakeway;
    GetTakewayType(order.pay_ebcode,posTakeway);   //获取外卖类型id
	pthread_mutex_lock(&mutex); //上锁 
	//判断记录是否存在，如果存在直接返回    
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"SELECT orderid FROM fmTakeaway where fm_id='%s';",order.fm_id.data());
    nErrCode = mysql->query();
    if(nErrCode != EC_OK){
    	pthread_mutex_unlock(&mutex); //解锁
    	return EC_EX_SQL_FAILED;   
    }
    if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){     
        LOG(INFO)<<"订单已存在";
        mysql_free_result(mysql->_result);
        pthread_mutex_unlock(&mutex); //解锁
        return EC_EXIST_ORDER;        //订单已存在
    }
    mysql_free_result(mysql->_result);
    

    int orderId=0;
    //查询订单表中订单id,获取到的最大订单id加1即为新的订单id
    sprintf(mysql->sqlStr,"%s","SELECT `Check` FROM tbl_Check WHERE `Check` BETWEEN 660000000 AND 669999999;");
    mysql->query();
    if (NULL == (mysql->_row = mysql_fetch_row(mysql->_result))){
        orderId=660000000;     //初始订单id
        LOG(INFO)<<"初始订单，id:660000000";
        mysql_free_result(mysql->_result);
    }
    else{
        mysql_free_result(mysql->_result);
        sprintf(mysql->sqlStr,"%s","SELECT  MAX(`Check`) AS id FROM tbl_Check WHERE `Check` BETWEEN 660000000 AND 669999999;");
        mysql->query();
        if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
            orderId=atoi(mysql->_row[0]);           
        }
        mysql_free_result(mysql->_result);
    }  
    
    orderId+=1;        //orderid加1
    char orderIdStr[10]={0};
	sprintf(orderIdStr,"%d",orderId);

    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE*2,
    	"insert into fmTakeaway(orderid, fm_cmd,fm_ver,customer_address,customer_name,customer_phone,delivery_time,dis_platform_fee,dis_shop_fee,discount_fee,\
    	fm_id,invoice_amount,order_index,package_fee,paid_trans_id,pay_ebcode,pay_ebcode_str,pay_id,pay_str,products_fee,remark,send_fee,service_fee,shop_fee)\
    	values('%s','%s','%s','%s','%s','%s',%d,%d,%d,%d, '%s',%d,%d,%d,'%s','%s','%s','%s','%s',%d,'%s',%d,%d,%d)", \
    	orderIdStr,order.fm_cmd.data(),order.fm_ver.data(),order.customer_address.data(),order.customer_name.data(),order.customer_phone.data(),\
    	order.delivery_time,order.dis_platform_fee,order.dis_shop_fee,order.discount_fee,order.fm_id.data(),order.invoice_amount,order.order_index,order.package_fee,\
    	order.paid_trans_id.data(),order.pay_ebcode.data(),order.pay_ebcode_str.data(),order.pay_id.data(),order.pay_str.data(),order.products_fee,order.remark.data(),\
    	order.send_fee,order.service_fee,order.shop_fee);
    nErrCode = mysql->insert();
    if(nErrCode != EC_OK)
    {
    	pthread_mutex_unlock(&mutex); //解锁
        return EC_EX_SQL_FAILED;
    }

    for(std::vector<TakeawayProduct>::size_type i=0;i<order.vecProducts.size();i++)
    {
        snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "insert into fmTakeaway_products(orderid, consume_num,original_price,pid) \
                                          values('%s',%d,%d,'%s')", \
                                          orderIdStr,order.vecProducts[i].consume_num,order.vecProducts[i].original_price,order.vecProducts[i].pid.data());
        nErrCode = mysql->insert();
    }

 	//获取系统时间，添加记录时使用
    time_t tt = time(NULL);//这句返回的只是一个时间cuo
	tm* t= localtime(&tt);
	char chTime[64] = {0};
	sprintf(chTime, "%d-%02d-%02d %02d:%02d:%02d", t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec);

	//获取门店编号
	int iOutlet=0;
	sprintf(mysql->sqlStr,"%s","SELECT Outlet FROM tbl_Outlet;");
    nErrCode = mysql->query();
    if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
		iOutlet=atoi(mysql->_row[0]);   
    }
    mysql_free_result(mysql->_result);

    //获取营业日
    std::string strDate; 
	sprintf(mysql->sqlStr,"%s","SELECT `Date` FROM tbl_DayInfo WHERE Active='1';");
    nErrCode = mysql->query();
    if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
		strDate=mysql->_row[0];     
    }
    mysql_free_result(mysql->_result);

    //订单写入“订单表”
    float discount=0.00;    //折扣金额
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "INSERT INTO tbl_Check(`Date`,`Check`,BarCode,Outlet,`Floor`,TableNo,Cover,OpenTime,OpenPeriod,OpenStation,\
    				OpenStationRef,OpenEmp,CloseTime,ClosePeriod,CloseStation,CloseEmp,PrintCount,LastPrintTime,CheckTot,ItemTot,DiscBefore,PayTot,IsPaid,SCRate1,\
    				IsModified,LastModifiedTime)\
					VALUES('%s',%d,'%s',%d,1,'1',4,'%s',3,99,99,4,'%s',4,99,4,1,'%s',%.2f,%.2f,%.2f,%.2f,'1',0.1,1,'%s')", \
                    strDate.data(),orderId,orderIdStr,iOutlet,chTime,chTime,chTime,order.shop_fee/100.00,order.shop_fee/100.00,discount,order.shop_fee/100.00,chTime);
    nErrCode = mysql->insert();

    //订单商品写入“订单详情表”
    for(std::vector<TakeawayProduct>::size_type i=0;i<order.vecProducts.size();i++){
        float discount_product=0.00;    //折扣金额
        float price_product=order.vecProducts[i].original_price/100.00;   //商品单价
        float tot_product=order.vecProducts[i].original_price*order.vecProducts[i].consume_num/100.00;     //商品总额
        std::string dish_name="";
        int print1=0,print2=0,print3=0,print4=0,print5=0,cat=0;

        //查询商品详细信息
        snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"SELECT Name3,PrintQ1,PrintQ2,PrintQ3,PrintQ4,PrintQ5,Category FROM tbl_Menu WHERE Item='%s';",order.vecProducts[i].pid.data());
        nErrCode = mysql->query();
        if (NULL != (mysql->_row = mysql_fetch_row(mysql->_result))){
            dish_name=mysql->_row[0];
            print1=atoi(mysql->_row[1]);
            print2=atoi(mysql->_row[2]);
            print3=atoi(mysql->_row[3]);
            print4=atoi(mysql->_row[4]);
            print5=atoi(mysql->_row[5]);
            cat=atoi(mysql->_row[6]); 
        }
        mysql_free_result(mysql->_result);

	    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "INSERT INTO tbl_Item(`Date`,`Check`,Outlet,ItemIdx,Item,Name3,NameS3,`Type`,OrderTime,OrderStation,OrderEmp,\
	    				PrintQ1,PrintQ2,PrintQ3,PrintQ4,PrintQ5,IsPrintOnCheck,PrintStatus,PrintCheckStatus,PrintedOnCheck,OgnPrice,Price,PriceLevel,ModiMethod,\
                        DiscBefore,UnitQty,Qty,ItemTot,RvDiscBefore,RvItemTot,Dept,Category,IsItemModified,LastModifiedTime)\
						VALUES('%s',%d,%d,%d,'%s','%s','%s',1,'%s',99,4,%d,%d,%d,%d,%d,'1',4,'1',1,%.2f,%.2f,1,-1,%.2f,1,%d,%.2f,%.2f,%.2f,3,%d,1,'%s')", \
	                    strDate.data(),orderId,iOutlet,i+1,order.vecProducts[i].pid.data(),dish_name.data(),dish_name.data(),chTime,print1,print2,print3,print4,\
                        print5,price_product,price_product,discount_product,\
                        order.vecProducts[i].consume_num,tot_product,discount_product,tot_product,cat,chTime);
	    nErrCode = mysql->insert();
	}
    
    //支付信息吸入“支付详情表”
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE, "INSERT INTO tbl_Payment(`Date`,`Check`,Outlet,PayIdx,PayNo,Name3,PayEmp,PayTime,PayStation,PayTot,PayClass,Member,\
    					IsModified,LastModifiedTime)\
						VALUES('%s',%d,%d,1,%d,'%s',4,'%s',99,%.2f,1,'',1,'%s')", \
                    	strDate.data(),orderId,iOutlet,atoi(posTakeway.merchantTypeId.data()),posTakeway.strName.data(),chTime,order.shop_fee/100.00,chTime);
    nErrCode = mysql->insert();
    pthread_mutex_unlock(&mutex); //解锁
	return 0;
}

//外卖退单数据库操作
int COrderInfo::CancleTakeaway(TakeawayOrder &order)
{
    //order_status:订单状态 0：正常  1：已退单
    int nErrCode = EC_OK;
    std::string strOrderId;
    pthread_mutex_lock(&mutex); //上锁 
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"SELECT orderid FROM fmTakeaway where order_status=0 AND fm_id='%s';",order.fm_id.data());
    nErrCode = mysql->query();
    if(nErrCode != EC_OK){
        pthread_mutex_unlock(&mutex); //解锁
        return EC_EX_SQL_FAILED;   
    }
    if (NULL == (mysql->_row = mysql_fetch_row(mysql->_result))){     
        LOG(INFO)<<"订单不存在或者已退单，fm_id:"<<order.fm_id.data();
        mysql_free_result(mysql->_result);
        pthread_mutex_unlock(&mutex); //解锁
        return EC_NOTEXIST_ORDER;    
    }
    else{
        strOrderId=mysql->_row[0];
    }
    mysql_free_result(mysql->_result);

    int iOrderId=atoi(strOrderId.data());
    //删除该销售单记录
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"DELETE FROM tbl_Check WHERE `Check`=%d;",iOrderId);
    nErrCode = mysql->remove();
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"DELETE FROM tbl_Item WHERE `Check`=%d;",iOrderId);
    nErrCode = mysql->remove();
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"DELETE FROM tbl_Payment WHERE `Check`=%d;",iOrderId);
    nErrCode = mysql->remove();
    
    //更新外卖订单记录为已退单，同时修改订单orderid ,规则，orderid后加‘_1’
    std::string newOrderId = strOrderId+"_1";
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"UPDATE fmTakeaway SET orderid='%s', order_status=1 WHERE fm_id='%s';",newOrderId.data(),order.fm_id.data());
    nErrCode = mysql->update();
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"UPDATE fmTakeaway_products SET orderid='%s' WHERE orderid='%s';",newOrderId.data(),strOrderId.data());
    nErrCode = mysql->update();
    pthread_mutex_unlock(&mutex); //解锁
	return nErrCode;
}

//向数据库总添加：fmTakeaway表 | fmTakeaway_products表 
int COrderInfo::AddFMTable()
{
	int nErrCode = EC_OK;

    //添加fmTakeaway表
    snprintf(mysql->sqlStr, SQL_BUFFER_SIZE,"CREATE TABLE IF NOT EXISTS fmTakeaway (\
					orderid VARCHAR(15) NOT NULL PRIMARY KEY,\
					fm_cmd VARCHAR(30),\
					fm_ver VARCHAR(20),\
					customer_address VARCHAR(200),\
					customer_name VARCHAR(60),\
					customer_phone VARCHAR(20),\
					delivery_time INT,\
					dis_platform_fee INT,\
					dis_shop_fee INT,\
					discount_fee INT,\
					fm_id VARCHAR(50),\
					invoice_amount INT,\
					order_index INT,\
					package_fee INT,\
					paid_trans_id VARCHAR (50),\
					pay_ebcode VARCHAR (50),\
					pay_ebcode_str VARCHAR (50),\
					pay_id VARCHAR (50),\
					pay_str VARCHAR (50),\
					products_fee INT,\
					remark VARCHAR (300),\
					send_fee INT,\
					service_fee INT,\
					shop_fee INT,\
					insert_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\
					order_status INT DEFAULT 0)");
    nErrCode = mysql->exec_proc();
    //添加fmTakeaway_products表
    snprintf(mysql->sqlStr, SQL_BUFFER_SIZE,"CREATE TABLE IF NOT EXISTS fmTakeaway_products (\
					orderid VARCHAR(15) NOT NULL ,\
					consume_num INT,\
					original_price INT,\
					pid VARCHAR(20),\
                    insert_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP)");                                                                   
    nErrCode = mysql->exec_proc();       

    //设置“非码外卖按钮”
    snprintf(mysql->sqlStr,SQL_BUFFER_SIZE,"UPDATE tbl_FuncType SET Name1='fmTakeout',Name2='·ÇÂëÍâÂô',Name3='·ÇÂëÍâÂô',Param1='%s' WHERE FuncNo=28;",strTakeoutDeamon.data());
    nErrCode = mysql->update();
 
    return nErrCode;
}

void COrderInfo::GetPosPayType(IN std::string fmPayType,OUT fmPOSType &payType)
{
    for (int i=0;i<vecPayTypes.size();i++)
    {
        if (vecPayTypes[i].fmTypeId==fmPayType)
        {
            payType= vecPayTypes[i];
            break;
        }
    }
}
void COrderInfo::GetTakewayType(IN std::string strType,OUT fmPOSType &takewayType)
{
    for (int i=0;i<vecTakewayTypes.size();i++)
    {
        if (vecTakewayTypes[i].fmTypeId==strType)
        {
            takewayType= vecTakewayTypes[i];
            break;
        }
    }
}

//设置 非码-商户 支付类型对照表
void COrderInfo::SetPayTypes(std::vector<fmPOSType> &vecPay)
{
	vecPayTypes.assign(vecPay.begin(), vecPay.end());
}

//设置 非码-商户 外卖类型对照表
void COrderInfo::SetTakewayTypes(std::vector<fmPOSType> &vecTakeway)
{
	vecTakewayTypes.assign(vecTakeway.begin(), vecTakeway.end());
}

char* COrderInfo::UTF8ToLatin1(const char *str)
{
    if(_tempLatin1!=NULL){
        delete[] _tempLatin1;
        _tempLatin1=NULL;
    }
    iconv_t cd;
    size_t inLen, outLen;
    char *_str = (char*)str;

    if (!str)
        return NULL;
    inLen = strlen(str)+1;

    _tempLatin1=new char[inLen];
    outLen = inLen;

    cd = iconv_open("ISO-8859-1", "UTF-8");
    size_t convertedLen = iconv(cd, &_str, &inLen, &_tempLatin1, &outLen);
    LOG(INFO)<<"Converted Length:"<< convertedLen << "Error: " << errno;
    iconv_close(cd);

    LOG(INFO)<<"_tempLatin1:"<<_tempLatin1;
    return _tempLatin1;
}

bool COrderInfo::GetMenuPrinter()
{
    LOG(INFO)<<"---------------------get printer service--------------------";
    vecPrinterMenus.clear();
    std::vector<PrintDevice> vecDevices;
    int nErrCode=0;

    //打印机数据库
    DB dbDevice;
    std::string strIniPath = GetProcDir();  
    strIniPath.append("monitor.ini");
    dbDevice.server = ZIni::readString("PRINTER_DB","ip", "",strIniPath.c_str());
    dbDevice.db = ZIni::readString("PRINTER_DB","dbName", "",strIniPath.c_str());
    dbDevice.user = ZIni::readString("PRINTER_DB","user", "",strIniPath.c_str());
    dbDevice.passwd = ZIni::readString("PRINTER_DB","password", "",strIniPath.c_str());
    dbDevice.timeout=5;
    dbDevice.interactive_timeout=5;
    MySQLService *mysqlDevice=new MySQLService(&dbDevice);

    sprintf(mysqlDevice->sqlStr,"%s","SELECT PrintQ,Name3,Printer FROM tbl_PrintQueue;");
    nErrCode = mysqlDevice->query();
    while ((mysqlDevice->_row = mysql_fetch_row(mysqlDevice->_result)) != NULL){
        PrintDevice device;
        device.iPrintQ=atoi(mysqlDevice->_row[0]);
        device.strTitle=mysqlDevice->_row[1];
        device.id=atoi(mysqlDevice->_row[2]);
        vecDevices.push_back(device);
    }
    mysql_free_result(mysqlDevice->_result);

    LOG(INFO)<<"-------------------------------------------------";
    std::vector<PrintDevice> vecPrinterInfo;
    sprintf(mysqlDevice->sqlStr,"%s","SELECT Printer,Device,BaudRate FROM tbl_PrintDevice;");
    nErrCode = mysqlDevice->query();
    while ((mysqlDevice->_row = mysql_fetch_row(mysqlDevice->_result)) != NULL){
        PrintDevice device;
        device.id=atoi(mysqlDevice->_row[0]);
        device.strDevice=mysqlDevice->_row[1];
        device.iBaud=atoi(mysqlDevice->_row[2]);
        vecPrinterInfo.push_back(device);
    }   
    for(auto &dev:vecDevices){
        for(auto printer:vecPrinterInfo){
            if(dev.id==printer.id){
                dev.strDevice=printer.strDevice;
                dev.iBaud=printer.iBaud;
            }
        }
    }

    mysql_free_result(mysqlDevice->_result);

    delete mysqlDevice;
    if(nErrCode==-1)
        return false;

    //查询菜单数据
    //PrintQ1:厨房打印机 PrintQ5:上菜单打印机
    sprintf(mysql->sqlStr,"%s","SELECT Item,PrintQ1,PrintQ5 FROM tbl_Menu;");
    nErrCode = mysql->query();
    while ((mysql->_row = mysql_fetch_row(mysql->_result)) != NULL){
        PrinterMenu menu;       
        menu.strMenuId=mysql->_row[0];
        menu.iPrinterId=atoi(mysql->_row[1]);
        for(auto dev:vecDevices){
            if(menu.iPrinterId==dev.iPrintQ){
                menu.strDevice=dev.strDevice;
                menu.iBaud=dev.iBaud;
                menu.strTitle=dev.strTitle;
                break;
            }
        }
        menu.iOrderPrinterId=atoi(mysql->_row[2]);

        for(auto dev:vecDevices){
            if(menu.iOrderPrinterId==dev.iPrintQ){
                menu.strOrderDevice=dev.strDevice;
                menu.iOrderBaud=dev.iBaud;
                menu.strOrderTitle=dev.strTitle;
                break;
            }
        }
        vecPrinterMenus.push_back(menu);
    }
    mysql_free_result(mysql->_result);
    if(nErrCode==-1)
        return false;
    // for(auto menu:vecPrinterMenus){
    //     LOG(INFO)<<"idMenu"<<menu.idMenu<<" idPrinter:"<<menu.idPrinter<<" device:"<<menu.device;
    // }
    return true;
}

std::vector<PrinterMenu>& COrderInfo::GetPOSMenu()
{
    if(!GetMenuPrinter())
        LOG(ERROR)<<"Get menu info failed!";
    return vecPrinterMenus;
}

void COrderInfo::CleanOldData()
{
    sprintf(mysql->sqlStr,"%s","DELETE FROM fmTakeaway WHERE insert_time < DATE_SUB(CURDATE(),INTERVAL 6 MONTH);");
    mysql->remove();
    sprintf(mysql->sqlStr,"%s","DELETE FROM fmTakeaway_products WHERE insert_time < DATE_SUB(CURDATE(),INTERVAL 6 MONTH);");
    mysql->remove();
    LOG(INFO)<<"Clean up more than six months of data";
}

//需要导出的函数，即用户在外部可以调用的接口  
bool GetOperationObject(void** _RtObject)  
{  
    IOperation* pOper = NULL;  
    pOper = new COrderInfo();  
    *_RtObject = (void*)pOper;  
    return true;  
}  
