/*
 * ServicePool.cpp
 *
 */
#include <exception>
#include "../3rdParty/easylogging/easylogging++.h"
#include "MySQLService.h"


MySQLService::MySQLService(DB * db) : _result(0), _row(0),sqlStr(NULL)
{
	_connect.thread_id = 0;
	_db = *db;
	sqlStr=new char[10240];
}

int MySQLService::db_free_all_res()
{
	do {
		MYSQL_RES * res = mysql_store_result(&_connect);
		if (res) mysql_free_result(res);
	} while (!mysql_next_result(&_connect));
	return 0;
}

int MySQLService::get_db()
{
	int ret = 0;
	if (_connect.thread_id != 0) { ///如果是已有连接
		if (mysql_errno(&_connect))
			db_close();else {
			timeval t_now;
			gettimeofday(&t_now, 0);
			if (t_now.tv_sec - _time_lastdb.tv_sec >= 30)  ///距最近操作时间大于30秒,则检查心跳
				ret = db_heartbeat(&_connect);
			if (ret == 0) {
				_time_lastdb = t_now;
				return 0;
			} else
				db_close();
		}
	}

	if (0 == db_connect(&_connect, _db.server.c_str(), _db.user.c_str(), _db.passwd.c_str(), _db.db.c_str(), (unsigned int)_db.port)) {
		gettimeofday(&_time_lastdb, 0);
		return 0;
	} else {
		LOG(ERROR) << "connect to mysql failed: "
				<< mysql_error(&_connect);
		db_close();
	}

	return -1;
}

int MySQLService::db_close(MYSQL * connect)
{
	db_free_all_res();
	mysql_close(connect);
	mysql_thread_end();
	connect->thread_id = 0;
	return 0;
}

int MySQLService::db_close()
{
	db_close(&_connect);
	return 0;
}

int MySQLService::db_heartbeat(MYSQL * connect)
{
	int ret = (mysql_ping(connect) == 0) ? 0 : -1;
	if (ret != 0)
		LOG(ERROR) << mysql_error(connect);
	return ret;
}

int MySQLService::stop()
{
	///关闭 mysql
	if (_connect.thread_id != 0) {
		LOG(INFO) << "stop mysql: " << _connect.thread_id;
		db_close();
	}
	if(sqlStr!=NULL){
		delete []sqlStr;	
		sqlStr=NULL;
	}
	
	return 0;
}

int MySQLService::db_connect(MYSQL * connect, const char * server, const char * user,
						  const char * passwd, const char * db, unsigned int port)
{
	int ret = -1;

	mysql_init(connect); // init

	char tmpset[255] = "";
	int timeout = _db.timeout;
	sprintf(tmpset, "set wait_timeout=%d", timeout);
	mysql_options(connect, MYSQL_INIT_COMMAND, tmpset);
	sprintf(tmpset, "set interactive_timeout=%d", _db.interactive_timeout);
	mysql_options(connect, MYSQL_INIT_COMMAND, tmpset);
	bool auto_cnt = true;
	mysql_options(connect, MYSQL_OPT_RECONNECT, (char *)&auto_cnt);
	mysql_options(connect, MYSQL_OPT_READ_TIMEOUT, (char *)&timeout);
	mysql_options(connect, MYSQL_OPT_WRITE_TIMEOUT, (char *)&timeout);

	if (0 == mysql_real_connect(connect, server, //连接数据库 mysql_real_connect
								user, passwd, db, port, NULL, CLIENT_FOUND_ROWS))

	{
		LOG(ERROR) << "connect to mysql failed: " << mysql_error(connect);
		return ret = -1;
	}
	LOG(INFO) << "mysql id: " << connect->thread_id ;

	if (mysql_set_character_set(connect, "utf8"))
		LOG(ERROR) << "client character set: " << mysql_character_set_name(connect);
	//打开自动提交
	if (0 != mysql_autocommit(connect, 1)) {
		LOG(ERROR) << "turn off auto commit failed: "
				<< mysql_error(connect);
		db_close();
		return ret = -1;
	}
	return ret = 0;
}

int MySQLService::query()
{
	///获取数据库连接
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}
	LOG(INFO) << "SQL : " << sqlStr;
	///执行sql查询
	try  
    {  
    	if (0 != mysql_query(&_connect, sqlStr)) {
			LOG(ERROR) << sqlStr;
			LOG(ERROR) << "query sql exception: " << mysql_error(&_connect);
			return -1;
		}
    }  
    catch (exception& e)  
    {  
    	LOG(ERROR) << "catch sql exception:" << e.what();
    	return -1;
    } 

	///保存查询结果
	if (NULL == (_result = mysql_store_result(&_connect))) {
		LOG(ERROR) << sqlStr;
		LOG(ERROR) << "query result exception: " << mysql_error(&_connect);
		mysql_free_result(_result);
		return -1;
	}

	return 0;
}

int MySQLService::insert()
{
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}

	if (0 != mysql_query(&_connect, sqlStr)) {
		LOG(ERROR) << sqlStr;
		LOG(ERROR) << "execute sql exception: " << mysql_error(&_connect);
		return -1;
	}

	return 0;
}

int MySQLService::update()
{
	return insert();
}

int MySQLService::remove()
{
	return insert();
}

int MySQLService::exec_proc()
{
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}

	if (0 != mysql_query(&_connect, sqlStr)) {
		LOG(ERROR) << sqlStr;
		LOG(ERROR) << "procedure exec exception: " << mysql_error(&_connect);
		return -1;
	}

	return 0;
}

int MySQLService::query_proc_result()
{
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}

	if (0 != mysql_query(&_connect, sqlStr)) {
		LOG(ERROR) << sqlStr;
		LOG(ERROR) << "query proc result failed: " << mysql_error(&_connect);
		return -1;
	}

	if (NULL == (_result = mysql_store_result(&_connect))) {
		LOG(ERROR) << "query result exception: " << mysql_error(&_connect);
		mysql_free_result(_result);
		return -1;
	}

	return 0;
}

int MySQLService::start_transaction()
{
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}

	if (0 != mysql_query(&_connect, "START TRANSACTION")) {
		LOG(ERROR) << "failed to start transaction: " << mysql_error(&_connect);
		return -1;
	}

	return 0;
}

int MySQLService::rollback()
{
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}

	if (0 != mysql_query(&_connect, "ROLLBACK")) {
		LOG(ERROR) << "failed to rollback: " << mysql_error(&_connect);
		return -1;
	}

	return 0;
}

int MySQLService::commit()
{
	if (0 != get_db()) {
		LOG(ERROR) << "get db connection falied!";
		return -1;
	}

	if (0 != mysql_query(&_connect, "COMMIT")) {
		LOG(ERROR) << "failed to commit: " << mysql_error(&_connect);
		rollback();
		return -1;
	}

	return 0;
}
