#!/bin/bash
CMDClient="/home/fm/monitor"
PIDClient="./pidClient.txt"
# ---------------------------------------------------
# 启动函数
function startClient {
    $CMDClient  2>&1 &
    mypgmpid=$!
    echo $mypgmpid > $PIDClient
    echo "startClient [ok]"
}
# 停止函数
function stopClient {
    kill `cat $PIDClient`
    rm $PIDClient
    echo "stopClient [ok]"
}
# --------------------------------------------------
echo "$CMDClient $1"
case "$1" in
start)
    startClient
;;
restart)
    if [ -f $PIDClient ] ; then
        stopClient
        sleep 4
    fi
    startClient
;;
stop)
    stopClient
    exit 0
;;
esac
for (( c=0 ; ; c++ ))
do
    if [ -f $PIDClient ] ; then
        mypgmpid=`cat $PIDClient`
        cmdex="ps uh -p$mypgmpid"
        psrtn=`$cmdex`
        if [ -z "$psrtn" ]; then
            # 进程挂掉自动重启
            echo "`date '+%Y/%m/%d %H:%M:%S'` FATALERROR RESTART SERVICE"
            startClient
        elif (( $c%20 == 0 )); then
            # 记录进程运行状态
            echo "`date '+%Y/%m/%d %H:%M:%S'` PSINFO $psrtn" 
            c=0
        fi
        sleep 3 
    else
        break
    fi
done
