/*    定义订单信息结构
    
*/

#ifndef COMMON_STRUCT_H
#define COMMON_STRUCT_H

#include <string>
#include <vector>

//商品信息
struct GOODS_INFO
{
    std::string strId;                        //商品id
    std::string strPrice;                    //商品价格
    std::string strNum;                        //商品数量
};


//订单信息
struct FM_ORDER_INFO
{
    std::string store;                        //门店号
    std::string pos;                        //pos机号
    std::string operater;                    //操作员
    std::string date;                        //营业日
    std::string payTotal;                    //订单总额
    std::string transId;                    //交易号
    std::vector<GOODS_INFO> vecGoods;        //商品信息
};

//外卖商品
struct TakeawayProduct
{
    int consume_num;               //数量
    int original_price;            //商品编码
    std::string pid;               //外卖平台上的单价
};

//外卖销售单
struct TakeawayOrder
{
    std::string fm_cmd;             //外卖订单写入确认
    std::string fm_ver;             //接口版本
    std::string pay_id;             //支付方式
    std::string pay_str;            //支付方式说明
    std::string pay_ebcode;         //支付方式中的类型&渠道
    std::string pay_ebcode_str;     //支付方式中的类型&渠道说明
    int shop_fee;                   //门店能够从平台拿到的钱(已除去费务服)
    int service_fee;                //平台收取的佣金
    int products_fee;               //商品金额
    int discount_fee;               //优惠总额
    int dis_shop_fee;               //商家承担的优惠总额
    int dis_platform_fee;           //平台承担的优惠总额
    int send_fee;                   //配送费
    int package_fee;                //打包费
    int invoice_amount;             //发票金额
    std::string paid_trans_id;      //外卖平台的交易号 订单号
    std::string fm_id;              //非码交易号
    std::string customer_address;   //顾客地址
    std::string customer_name;      //顾客名称
    std::string customer_phone;     //顾客手机号
    int delivery_time;              //送达时间
    int order_index;                //平台序号
    std::string remark;             //备注

    std::vector<TakeawayProduct> vecProducts;    //商品信息
};

struct PrinterMenu
{
    std::string strMenuId;
    int         iPrinterId;
    std::string strDevice;
};

struct PrintDevice
{
    int id;
    std::string strDevice;  
};

#endif