/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.table;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import twaver.base.A.E.H;
import twaver.web.WebUtil;
import twaver.web.table.TWebTableColumn;
import twaver.web.table.TWebTableRowFilter;

public class TWebTable {
    private boolean \u01cd = false;
    protected boolean dirty = true;
    protected String JSONData = null;
    private TWebTableColumn[] \u01cb;
    protected List rowFilters = new ArrayList();
    protected List publishedData = new ArrayList();
    protected List rawData = null;
    private boolean \u01cc = true;

    public TWebTable() {
        this(new ArrayList(), null);
    }

    public TWebTable(List rawData, TWebTableColumn[] columns) {
        this.rawData = rawData;
        this.\u01cb = columns;
    }

    public void addRowFilter(TWebTableRowFilter rowFilter) {
        if (rowFilter == null) {
            throw new NullPointerException("rowFilter can not be null.");
        }
        if (!this.rowFilters.contains(rowFilter)) {
            this.rowFilters.add(rowFilter);
            this.dirty = true;
        }
    }

    public String toJSON() {
        return this.toJSON(0, -1);
    }

    public String toJSON(int start, int limit) {
        if (this.isDirty()) {
            this.resetData();
            this.setDirty(false);
        }
        if (limit <= 0) {
            limit = this.rawData.size();
        }
        this.publishData(start, limit);
        if (this.JSONData == null) {
            return "[]";
        }
        return this.JSONData;
    }

    protected void resetData() {
    }

    protected String exportJSON() {
        List publishedData = this.getPublishedData();
        if (publishedData.isEmpty()) {
            return null;
        }
        ArrayList<TWebTableColumn> visibleColumnList = new ArrayList<TWebTableColumn>(this.\u01cb.length);
        for (int i2 = 0; i2 < this.\u01cb.length; ++i2) {
            TWebTableColumn column = this.\u01cb[i2];
            if (!column.isVisible()) continue;
            visibleColumnList.add(column);
        }
        if (visibleColumnList.isEmpty()) {
            return null;
        }
        StringBuffer json = new StringBuffer();
        json.append("[");
        int size = publishedData.size();
        for (int i3 = 0; i3 < size; ++i3) {
            if (i3 > 0) {
                json.append(",");
            }
            TWebTableColumn[] visibleColumns = new TWebTableColumn[visibleColumnList.size()];
            visibleColumnList.toArray(visibleColumns);
            json.append(this.exportRowJSON(visibleColumns, publishedData.get(i3)));
        }
        json.append("]");
        return json.toString();
    }

    protected String exportRowJSON(TWebTableColumn[] visibleColumns, Object row) {
        Object[] datas = this.getRowData(visibleColumns, row);
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i2 = 0; i2 < datas.length; ++i2) {
            if (i2 > 0) {
                result.append(",");
            }
            TWebTableColumn column = visibleColumns[i2];
            Object data = datas[i2];
            result.append("'" + column.getName() + "':'" + this.getCellValue(data) + "'");
        }
        result.append("}");
        return result.toString();
    }

    public String getCellValue(Object data) {
        if (this.\u01cc) {
            return WebUtil.htmlEscape(WebUtil.javaToJSON(data));
        }
        return WebUtil.javaToJSON(data);
    }

    protected Object[] getRowData(TWebTableColumn[] visibleColumns, Object row) {
        Object[] rowData = new Object[visibleColumns.length];
        for (int i2 = 0; i2 < visibleColumns.length; ++i2) {
            TWebTableColumn column = visibleColumns[i2];
            String name = column.getName();
            Class<?> clazz = row.getClass();
            if (column.getReadMethod() == null) {
                Method readMethod = H.B(clazz, name);
                column.setReadMethod(readMethod);
            }
            if (column.getWriteMethod() == null && column.getReadMethod() != null) {
                Method writeMethod = H.B(clazz, name, column.getReadMethod().getReturnType());
                column.setWriteMethod(writeMethod);
            }
            Object value = null;
            if (column.getReadMethod() != null) {
                value = H.A(row, column.getReadMethod(), column.getName());
            }
            rowData[i2] = value;
        }
        return rowData;
    }

    public TWebTableColumn[] getColumns() {
        return this.\u01cb;
    }

    public void setColumns(TWebTableColumn[] columns) {
        this.\u01cb = columns;
    }

    public List getPublishedData() {
        return this.publishedData;
    }

    public List getPublishedData(int pageIndex) {
        return this.publishedData;
    }

    public int getDataSize() {
        return this.rawData.size();
    }

    public void publishData(int start, int limit) {
        if (this.isDirty()) {
            this.resetData();
            this.setDirty(false);
        }
        this.publishedData.clear();
        int end = start + limit;
        int size = this.rawData.size();
        if (end > size) {
            end = size;
        }
        for (int i2 = start; i2 < end; ++i2) {
            Object rowData;
            Object e2 = rowData = this.isConverseIncreaseOrder() ? this.rawData.get(size - i2 - 1) : this.rawData.get(i2);
            if (!this.isVisible(rowData)) continue;
            this.publishedData.add(rowData);
        }
        this.JSONData = this.exportJSON();
    }

    protected boolean isVisible(Object rowData) {
        int count = this.rowFilters.size();
        for (int i2 = 0; i2 < count; ++i2) {
            TWebTableRowFilter filter = (TWebTableRowFilter)this.rowFilters.get(i2);
            if (filter.isVisible(this, rowData)) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isEscapeValue() {
        return this.\u01cc;
    }

    public void setEscapeValue(boolean escapeValue) {
        this.\u01cc = escapeValue;
    }

    public boolean isConverseIncreaseOrder() {
        return this.\u01cd;
    }

    public void setConverseIncreaseOrder(boolean converseIncreaseOrder) {
        this.\u01cd = converseIncreaseOrder;
    }
}

