/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.gis.google.loc;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.gis.google.loc.JCellPanel;
import com.nepxion.swing.searcher.gis.google.loc.JCoordinatePanel;
import com.nepxion.swing.searcher.gis.google.loc.JLocTable;
import com.nepxion.swing.searcher.gis.google.loc.LocTableModel;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.gis.google.loc.LocEntity;
import com.nepxion.util.searcher.gis.google.loc.LocSearcher;
import java.awt.event.ActionEvent;

public class LocController {
    public static JSecurityAction getSearchAction(final JCoordinatePanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("geo_to_address")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("geo_to_address"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        LocEntity entity = (LocEntity)data;
                        if (entity == null) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        LocTableModel tableModel = (LocTableModel)panel.getLocTable().getModel();
                        tableModel.addRow(entity);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        double latitude = 0.0;
                        double longitude = 0.0;
                        try {
                            latitude = panel.getLatitude();
                            longitude = panel.getLongitude();
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(SwingLocale.getString("number_not_null_or_non_number"), e);
                        }
                        String language = panel.getLanguage();
                        LocSearcher searcher = new LocSearcher(language);
                        LocEntity entity = searcher.search(latitude, longitude);
                        return entity;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getSearchAction(final JCellPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("mobile_to_address")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("mobile_to_address"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        LocEntity entity = (LocEntity)data;
                        if (entity == null) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        LocTableModel tableModel = (LocTableModel)panel.getLocTable().getModel();
                        tableModel.addRow(entity);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        int cellID = 0;
                        int lac = 0;
                        int mcc = 0;
                        int mnc = 0;
                        try {
                            cellID = panel.getCellID();
                            lac = panel.getLac();
                            mcc = panel.getMcc();
                            mnc = panel.getMnc();
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(SwingLocale.getString("number_not_null_or_non_number"), e);
                        }
                        String language = panel.getLanguage();
                        LocSearcher searcher = new LocSearcher(language);
                        LocEntity entity = searcher.search(cellID, lac, mcc, mnc);
                        return entity;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JLocTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                LocTableModel tableModel = (LocTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

