/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.outlookbar;

import com.l2fprod.common.swing.JOutlookBar;
import com.l2fprod.common.swing.plaf.OutlookBarUI;
import com.nepxion.swing.outlookbar.FlatOutlookBarManager;
import com.nepxion.swing.style.outlookbar.JFlatOutlookBarUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class JFlatOutlookBar
extends JOutlookBar
implements SwingConstants {
    public JFlatOutlookBar() {
        this.initComponents();
    }

    public JFlatOutlookBar(int tabPlacement) {
        super(tabPlacement);
        this.initComponents();
    }

    private void initComponents() {
        JFlatOutlookBarUI outlookBarUI = new JFlatOutlookBarUI();
        this.setUI((OutlookBarUI)outlookBarUI);
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setAnimated(false);
    }

    public JScrollPane makeScrollPane(Component component) {
        JScrollPane scrollPane = super.makeScrollPane(component);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        FlatOutlookBarManager.setPreferenceStyle(scrollPane);
        return scrollPane;
    }

    public void setAllTabsAlignment(int alignment) {
        this.setAllTabsAlignment(alignment, 10);
    }

    public void setAllTabsAlignment(int alignment, int indent) {
        JFlatOutlookBarUI outlookBarUI = (JFlatOutlookBarUI)((Object)this.getUI());
        switch (alignment) {
            case 2: {
                break;
            }
            case 0: {
                indent = 0;
                break;
            }
            case 4: {
                indent = -indent;
            }
        }
        outlookBarUI.getButtonUI().setIndent(indent);
        super.setAllTabsAlignment(alignment);
    }

    public String getSelectedTitle() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getTitleAt(index);
    }

    public Component getTabAt(String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            return this.getComponentAt(i);
        }
        return null;
    }

    public void removeTabAt(String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            this.removeTabAt(i);
            break;
        }
    }

    public void removeTabs(List closedComponents) {
        for (int i = 0; i < closedComponents.size(); ++i) {
            Component closedComponent = (Component)closedComponents.get(i);
            super.removeTabAt(this.indexOfComponent(closedComponent));
        }
    }

    public void removeReverseTabsAt(int index) {
        ArrayList<Component> closedComponents = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (i == index) continue;
            Component component = this.getComponentAt(i);
            closedComponents.add(component);
        }
        this.removeTabs(closedComponents);
    }

    public void removeAllTabs() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getComponentAt(i);
            components.add(component);
        }
        this.removeTabs(components);
    }
}

