/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.font;

import com.nepxion.swing.font.FontContext;
import com.nepxion.util.io.FileUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontManager {
    public static void setFont(String fontName, int fontStyle, int fontSize) {
        Font font = new Font(fontName, fontStyle, fontSize);
        FontManager.setFont(font);
    }

    public static void setFont(Font font) {
        FontUIResource fontUIResource = new FontUIResource(font);
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.getDefaults().remove(key);
            UIManager.getDefaults().put(key, fontUIResource);
        }
    }

    public static void setInputStreamFont(String fontPath, int fontStyle, int fontSize) {
        FontManager.setInputStreamFont(fontPath, fontStyle, fontSize, false);
    }

    public static void setInputStreamFont(String fontPath, int fontStyle, int fontSize, boolean classLoader) {
        Font font = null;
        try {
            InputStream inputStream = FileUtil.getInputStream((String)fontPath, (boolean)classLoader);
            font = Font.createFont(0, inputStream);
            font = font.deriveFont(fontStyle, fontSize);
            inputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            font = FontContext.getFont();
        }
        FontManager.setFont(font);
    }

    public static Font[] getAllFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }

    public static String[] getAvailableFontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static String[] getAvailableFontFamilyNames(Locale locale) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(locale);
    }

    public static void drawCenterString(Graphics2D g2d, String text, int componentWidth, int componentHeight, int horizontalGap, int verticalGap) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        FontManager.drawCenterString(g2d, fontMetrics, text, componentWidth, componentHeight, horizontalGap, verticalGap);
    }

    public static void drawCenterString(Graphics2D g2d, Font font, String text, int componentWidth, int componentHeight, int horizontalGap, int verticalGap) {
        FontMetrics fontMetrics = g2d.getFontMetrics(font);
        FontManager.drawCenterString(g2d, fontMetrics, text, componentWidth, componentHeight, horizontalGap, verticalGap);
    }

    public static void drawCenterString(Graphics2D g2d, FontMetrics fontMetrics, String text, int componentWidth, int componentHeight, int horizontalGap, int verticalGap) {
        Rectangle2D r = fontMetrics.getStringBounds(text, g2d);
        int textWidth = (int)r.getWidth();
        int textHeight = (int)r.getHeight();
        int x = (componentWidth - textWidth) / 2 > 0 ? (componentWidth - textWidth) / 2 : 0;
        int y = (componentHeight - textHeight) / 2 > 0 ? (componentHeight - textHeight) / 2 : 0;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawString(text, x += horizontalGap, y += fontMetrics.getAscent() + verticalGap);
    }
}

