/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.color;

import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;
import java.awt.Color;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class ColorUtil {
    public static String transformTo16Bit(int red, int green, int blue) {
        return Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }

    public static Color getColor(String decode) {
        return Color.decode(decode);
    }

    public static Color getUIManagerColor(String key) {
        Color background = UIManager.getColor(key);
        return new Color(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha());
    }

    public static Color getRandomColor() {
        return new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
    }

    public static float[] getHSBOffsets(Color color1, Color color2) {
        float[] colorHSB1 = Color.RGBtoHSB(color1.getRed(), color1.getGreen(), color1.getBlue(), null);
        float[] colorHSB2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        return new float[]{colorHSB1[0] - colorHSB2[0], colorHSB1[1] - colorHSB2[1], colorHSB1[2] - colorHSB2[2]};
    }

    public static Color getDerivedColor(Color color) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (!(lookAndFeel instanceof NimbusLookAndFeel)) {
            throw new IllegalArgumentException("The derived color only supports Nimbus LookAndFeel");
        }
        NimbusLookAndFeel nimbusLookAndFeel = (NimbusLookAndFeel)lookAndFeel;
        Color baseColor = UIManager.getColor("nimbusBase");
        float[] hsbOffsets = ColorUtil.getHSBOffsets(color, baseColor);
        Color derivedColor = nimbusLookAndFeel.getDerivedColor("nimbusBase", hsbOffsets[0], hsbOffsets[1], hsbOffsets[2], 0, true);
        return derivedColor;
    }
}

