/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.D.O;
import twaver.base.A.E.a;
import twaver.base.A.E.d;
import twaver.chart.AbstractXYScaleChart;
import twaver.chart.Bubble;
import twaver.chart.C;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGBubbleChart;
import twaver.web.svg.network.SVGContext;

public class BubbleChart
extends AbstractXYScaleChart {
    private int \u04f8 = TUIManager.getInt("tchart.line.type");
    private int \u0531 = TUIManager.getInt("tchart.inflexion.style");
    private boolean \u04f1 = TUIManager.getBoolean("tchart.inflexion.visible");
    private boolean \u0533 = TUIManager.getBoolean("tchart.bubble.area.selectable");
    private boolean \u04f4 = TUIManager.getBoolean("tchart.bubble.shape.line.visible");
    private boolean \u04f0 = TUIManager.getBoolean("tchart.bubble.shape.bubble.visible");
    private boolean \u04f3 = TUIManager.getBoolean("tchart.bubble.gradient");
    private int \u04f5 = TUIManager.getInt("tchart.bubble.gradient.factory");
    private float \u0534 = TUIManager.getFloat("tchart.bubble.alpha");
    private int \u04f9 = TUIManager.getInt("tchart.bubble.style");
    private Color \u04f2 = TUIManager.getColor("tchart.bubble.gradient.color");
    private int \u0532 = 1;

    public BubbleChart() {
    }

    public BubbleChart(TDataBox box) {
        super(box);
    }

    public BubbleChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor);
    }

    public BubbleChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public BubbleChart(List items) {
        super(items);
    }

    public BubbleChart(List items, String title) {
        super(items, title);
    }

    public BubbleChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
    }

    public BubbleChart(List elements, String title, Color backgroundColor, Color foregroundColor) {
        super(elements, title, backgroundColor, foregroundColor);
    }

    protected void calculateYAxisRange() {
        int count = this.publishedElements.size();
        double yscaleMax = this.getYScaleMaxValue();
        double yscaleMmin = this.getYScaleMinValue();
        this.max = this.getYScaleMaxValue();
        this.min = this.getYScaleMinValue();
        if (yscaleMax == -1.7976931348623157E308 || yscaleMmin == Double.MAX_VALUE) {
            for (int i2 = 0; i2 < count; ++i2) {
                Element element = (Element)this.publishedElements.get(i2);
                List list = this.getValues(element);
                int count2 = list.size();
                for (int j2 = 0; j2 < count2; ++j2) {
                    Object obj = list.get(j2);
                    Bubble bubble = (Bubble)obj;
                    if (bubble.getX() < this.getXScaleMinValue() || bubble.getX() > this.getXScaleMaxValue()) continue;
                    double value = bubble.getY();
                    if (yscaleMax == -1.7976931348623157E308 && value > this.max) {
                        this.max = value;
                    }
                    if (yscaleMmin != Double.MAX_VALUE || !(value < this.min)) continue;
                    this.min = value;
                }
            }
        }
        if (this.min == Double.MAX_VALUE) {
            if (this.max != -1.7976931348623157E308) {
                this.min = this.max * 0.9;
            } else {
                this.max = 100.0;
                this.min = 0.0;
            }
        } else if (this.max == -1.7976931348623157E308) {
            this.max = this.min * 1.1;
        }
        if (this.max == -1.7976931348623157E308) {
            if (this.min == Double.MAX_VALUE) {
                this.max = 100.0;
                this.min = 0.0;
            } else {
                this.max = this.min * 1.1;
            }
        } else if (this.min == Double.MAX_VALUE) {
            this.min = this.max * 0.9;
        }
        if (this.max == this.min) {
            if (this.max == 0.0) {
                this.max = 10.0;
                this.min = -10.0;
            } else {
                double temp = this.max * 0.1;
                this.max += temp;
                this.min -= temp;
            }
        }
        this.range = Math.abs(Math.max(this.max - this.min, 1.0));
    }

    protected void paintContent(Graphics2D g2, int width, int height) {
        List bubbleList;
        List list;
        Element element;
        int i2;
        this.shapeStructs.clear();
        int size = this.publishedElements.size();
        for (i2 = 0; i2 < size; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (element.isSelected()) continue;
            list = element.getChartValues();
            bubbleList = this.getBubbleList(element, list);
            this.A(g2, width, height, bubbleList, element);
        }
        for (i2 = 0; i2 < size; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (!element.isSelected()) continue;
            list = element.getChartValues();
            bubbleList = this.getBubbleList(element, list);
            this.A(g2, width, height, bubbleList, element);
        }
    }

    protected List getBubbleList(Element element, List list) {
        return list;
    }

    private void A(Graphics2D g2, int width, int height, List list, Element element) {
        Rectangle2D.Double drawBound = this.getDrawBound();
        double minValue = this.getXScaleMinValue();
        double maxValue = this.getXScaleMaxValue();
        double xRange = maxValue - minValue;
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        int orListSize = list.size();
        double drawBoundLeftDownPoint = drawBound.y + drawBound.height;
        double zeroLine = drawBound.y + drawBound.height - drawBound.height * (0.0 - this.min) / this.range;
        if (this.min > 0.0) {
            zeroLine = drawBound.y + drawBound.height;
        }
        if (this.max < 0.0) {
            zeroLine = drawBound.y;
        }
        for (int i2 = 0; i2 < orListSize; ++i2) {
            Bubble bubble = (Bubble)list.get(i2);
            double xValue = bubble.getX();
            double yValue = bubble.getY();
            double x = drawBound.x + drawBound.width * (xValue - minValue) / xRange;
            double y = drawBoundLeftDownPoint - drawBound.height * ((yValue - this.min) / this.range);
            points.add(new Point2D.Double(x, y));
        }
        this.A(g2, list, element, points, zeroLine);
    }

    private void A(Graphics2D g2, List list, Element element, List points, double zeroLine) {
        boolean useXScaleList;
        int size = list.size();
        Rectangle2D.Double drawBound = this.getDrawBound();
        List xScaleList = this.getXScaleTextList();
        boolean bl = useXScaleList = xScaleList != null && xScaleList.size() > 0;
        if (useXScaleList && xScaleList.size() < size) {
            size = xScaleList.size();
        }
        double xPixelGap = 0.0;
        if (useXScaleList) {
            xPixelGap = Math.max(drawBound.getWidth() / (double)xScaleList.size(), 1.0);
        }
        if (size == 1) {
            Bubble bubble = (Bubble)list.get(0);
            Shape segment = null;
            Point2D.Double point = (Point2D.Double)points.get(0);
            if (useXScaleList) {
                point.x = drawBound.getX() + xPixelGap / 2.0;
            }
            if (this.\u04f8 == 3) {
                Line2D.Double line = new Line2D.Double(point.x, point.y, point.x, zeroLine);
                Stroke stroke = this.getStroke(element);
                if (stroke != null) {
                    segment = this.paintLine(g2, line, element, stroke, bubble, null);
                }
                this.A(g2, point, element, zeroLine, bubble, segment, 0);
            } else {
                this.A(g2, point, element, zeroLine, bubble, segment, 0);
            }
            this.A(g2, element, bubble, point, 0);
        } else {
            Bubble bubble = null;
            Shape segment = null;
            Bubble nextbubble = null;
            Point2D.Double point = null;
            Point2D.Double nextPoint = null;
            int useValueSpanCount = this.\u0532 > 0 ? this.\u0532 : 1;
            for (int i2 = 0; i2 < size; ++i2) {
                Stroke stroke;
                Line2D.Double line;
                bubble = (Bubble)list.get(i2);
                point = (Point2D.Double)points.get(i2);
                segment = null;
                nextbubble = null;
                nextPoint = null;
                if (i2 % useValueSpanCount != 0) continue;
                if (i2 + useValueSpanCount >= size) {
                    if (this.\u04f8 != 3) {
                        continue;
                    }
                } else {
                    nextbubble = (Bubble)list.get(i2 + useValueSpanCount);
                    nextPoint = (Point2D.Double)points.get(i2 + useValueSpanCount);
                }
                if (!useXScaleList && (bubble.getX() < this.getXScaleMinValue() || bubble.getX() > this.getXScaleMaxValue() || this.\u04f8 != 3 && (nextbubble.getX() < this.getXScaleMinValue() || nextbubble.getX() > this.getXScaleMaxValue()))) continue;
                if (useXScaleList) {
                    point.x = drawBound.getX() + (double)i2 * xPixelGap + xPixelGap / 2.0;
                    if (i2 + useValueSpanCount < size) {
                        nextPoint.x = drawBound.getX() + xPixelGap / 2.0 + (double)(i2 + useValueSpanCount) * xPixelGap;
                    }
                }
                if (this.\u04f8 == 3) {
                    line = new Line2D.Double(point.x, point.y, point.x, zeroLine);
                    stroke = this.getStroke(element);
                    if (stroke != null) {
                        segment = this.paintLine(g2, line, element, stroke, bubble, nextbubble);
                    }
                    this.A(g2, point, element, zeroLine, bubble, segment, i2);
                    this.A(g2, element, bubble, point, i2);
                    continue;
                }
                line = new Line2D.Double(point.x, point.y, nextPoint.x, nextPoint.y);
                stroke = this.getStroke(element);
                if (stroke != null) {
                    segment = this.paintLine(g2, line, element, stroke, bubble, nextbubble);
                }
                this.A(g2, point, element, zeroLine, bubble, segment, i2);
                if (this.\u04f8 == 2) {
                    Color areaColor = this.getAreaColor(element);
                    if (areaColor != null) {
                        GeneralPath path = new GeneralPath();
                        path.moveTo((float)point.x, (float)zeroLine);
                        path.lineTo((float)point.x, (float)point.y);
                        path.lineTo((float)nextPoint.x, (float)nextPoint.y);
                        path.lineTo((float)nextPoint.x, (float)zeroLine);
                        path.closePath();
                        segment = path;
                        g2.setColor(areaColor);
                        g2.fill(path);
                    }
                    if (this.\u0533) {
                        this.A(g2, point, element, zeroLine, bubble, segment, i2);
                    }
                }
                this.A(g2, element, bubble, point, i2);
                if (i2 + useValueSpanCount * 2 < size) continue;
                segment = null;
                this.A(g2, nextPoint, element, zeroLine, nextbubble, segment, i2 + useValueSpanCount);
                this.A(g2, element, nextbubble, nextPoint, i2 + useValueSpanCount);
            }
        }
    }

    protected boolean getShapeLineVisible(Element element) {
        Object value = element.getClientProperty("chart.bubble.shape.line.visible");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.\u04f4;
    }

    protected boolean getShapeBubbleVisible(Element element, Bubble bubble, int index) {
        Object value = element.getClientProperty("chart.bubble.shape.bubble.visible");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.\u04f0;
    }

    protected Shape paintLine(Graphics2D g2, Line2D.Double line, Element element, Stroke stroke, Bubble startBubble, Bubble endBubble) {
        if (!this.getShapeLineVisible(element)) {
            return null;
        }
        Shape segment = stroke.createStrokedShape(line);
        if (element.isSelected()) {
            g2.setStroke(this.getSelectedStroke(element));
            g2.setColor(this.getSelectedLineColor(element, startBubble, endBubble));
            g2.draw(segment);
        }
        Color color = this.getLineColor(element, startBubble, endBubble);
        g2.setColor(color);
        g2.fill(segment);
        return segment;
    }

    protected Color getLineColor(Element element, Bubble startBubble, Bubble endBubble) {
        return this.getColor(element);
    }

    protected Color getSelectedLineColor(Element element, Bubble startBubble, Bubble endBubble) {
        return this.getSelectedColor(element);
    }

    protected void paintShape(Graphics2D g2d, Element element, Point2D.Double point, Bubble bubble, int index) {
        Shape shape = this.A(g2d, element, point, bubble, index);
        Rectangle2D.Double bounds = this.getShapeBounds(element, point, bubble, index);
        if (shape != null) {
            if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
                Composite old = g2d.getComposite();
                AlphaComposite alph = AlphaComposite.getInstance(3, this.\u0534);
                g2d.setComposite(alph);
                double shapesize = bounds.getWidth() / 2.0;
                Rectangle2D.Double rect = new Rectangle2D.Double(point.getX() - shapesize, point.getY() - shapesize, shapesize * 2.0, shapesize * 2.0);
                Paint paint = this.A(element, rect, this.getShapeColor(element, bubble, index));
                g2d.setPaint(paint);
                g2d.fill(shape);
                if (element.isSelected()) {
                    shape = this.getStroke(element).createStrokedShape(shape);
                    g2d.setStroke(this.getSelectedStroke(element));
                    g2d.setColor(this.getSelectedColor(element));
                    g2d.draw(shape);
                    g2d.setColor(this.getShapeColor(element, bubble, index));
                    g2d.fill(shape);
                }
                g2d.setComposite(old);
            } else {
                Color color = this.getShapeColor(element, bubble, index);
                g2d.setColor(color);
                g2d.fill(shape);
            }
        }
    }

    private void A(Graphics2D g2, Element element, Bubble bubble, Point2D.Double point, int index) {
        if (bubble.getValue() > 0.0) {
            if (this.getShapeBubbleVisible(element, bubble, index)) {
                this.paintShape(g2, element, point, bubble, index);
            } else if (this.\u04f1) {
                this.paintShape(g2, element, point, bubble, index);
            }
        } else if (this.\u04f1) {
            this.paintShape(g2, element, point, bubble, index);
        }
        if (this.valueTextVisible) {
            String text = this.getValueText(element, bubble, index);
            this.A(g2, text, this.getValueTextColor(element, bubble, index), this.valueTextFont, (int)point.x, (int)point.y, this.getValueTextPosition(element, bubble, index));
        }
    }

    private void A(Graphics2D g2, Point2D.Double point, Element element, double zeroLine, Bubble bubble, Shape segment, int index) {
        String toolTipText = this.getToolTipText(element, bubble, index);
        Shape inflexionShape = this.A(g2, element, point, bubble, index);
        Shape shape = null;
        if (this.\u04f8 == 3) {
            Area area = new Area();
            if (segment != null) {
                area.add(new Area(segment));
            }
            area.add(new Area(inflexionShape));
            shape = area;
        } else {
            shape = inflexionShape;
            if (this.\u04f8 == 2) {
                Area area = new Area();
                if (segment != null) {
                    area.add(new Area(segment));
                }
                area.add(new Area(inflexionShape));
                segment = area;
            }
        }
        this.shapeStructs.add(0, new C(shape, element, toolTipText, segment, index));
    }

    private Shape A(Graphics2D g2d, Element element, Point2D.Double point, Bubble bubble, int index) {
        int inflexionStyle = this.getShapeStyle(element, bubble, index);
        Rectangle2D.Double bounds = this.getShapeBounds(element, point, bubble, index);
        Shape shape = null;
        if (inflexionStyle == 1) {
            float x = (float)bounds.x;
            float y = (float)bounds.y;
            float width = (float)bounds.width;
            float height = (float)bounds.height;
            shape = new Ellipse2D.Float(x, y, width, height);
        } else if (inflexionStyle == 2) {
            bounds.x -= 1.0;
            bounds.y -= 1.0;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(bounds.x + bounds.width / 2.0), (float)bounds.y);
            path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height / 2.0));
            path.lineTo((float)(bounds.x + bounds.width / 2.0), (float)(bounds.y + bounds.height));
            path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height / 2.0));
            path.closePath();
            shape = path;
        } else if (inflexionStyle == 3) {
            shape = bounds;
        } else if (inflexionStyle == 4) {
            bounds.x -= 1.0;
            bounds.y -= 1.0;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(bounds.x + bounds.width / 2.0), (float)bounds.y);
            path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
            path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height));
            path.closePath();
            shape = path;
        }
        return shape;
    }

    protected Color getAreaColor(Element element) {
        Color color = this.getColor(element);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    protected int getValueTextPosition(Element element, Bubble bubble, int index) {
        Object value = element.getClientProperty("chart.value.text.position");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (this.isValueTextCenter()) {
            return 1;
        }
        return this.valueTextPosition;
    }

    protected Color getValueTextColor(Element element, Bubble bubble, int index) {
        return this.valueTextColor;
    }

    protected String getValueText(Element element, Bubble bubble, int index) {
        String text = "";
        if (bubble.getText() != null) {
            text = bubble.getText();
        } else {
            double value = bubble.getY();
            if (this.format != null) {
                text = this.format.format(value);
            }
        }
        return text;
    }

    protected String getToolTipText(Element element, Bubble bubble, int index) {
        String xScaleText;
        if (!this.isEnableToolTipText()) {
            return null;
        }
        String text = this.getToolTipText(element);
        if (bubble.getText() != null) {
            text = text == null ? bubble.getText() : text + "<br>" + bubble.getText();
        }
        if ((xScaleText = this.getXScaleTextFromScaleList(index)) != null) {
            text = text == null ? xScaleText : text + "<br>" + xScaleText;
        } else {
            xScaleText = this.getFormatedXScaleText(bubble.getX());
            text = text == null ? xScaleText : text + "<br>" + xScaleText;
        }
        String valueText = this.getFormatedYScaleText(bubble.getY());
        text = text + "<br>" + valueText;
        if (bubble.getValue() > 0.0) {
            text = text + "<br>" + this.format.format(bubble.getValue());
        }
        if (text != null) {
            if (text.indexOf("<html>") >= 0) {
                text = text.replaceAll("<html>", "");
                text = text.replaceAll("</html>", "");
            }
            text = "<html>" + text + "</html>";
        }
        return text;
    }

    private Paint A(Element element, Rectangle2D.Double rectangle, Color color) {
        if (this.\u04f3) {
            O factory = d.E(this.\u04f5);
            Paint paint = factory.A(new Rectangle((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.width, (int)rectangle.height), this.\u04f2, color);
            return paint;
        }
        return color;
    }

    protected Color getShapeColor(Element element, Bubble bubble, int index) {
        return this.getColor(element);
    }

    protected int getShapeStyle(Element element, Bubble bubble, int index) {
        Object value;
        String key = "chart.inflexion.style";
        if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
            key = "chart.bubble.style";
        }
        if ((value = element.getClientProperty(key)) instanceof Integer) {
            return (Integer)value;
        }
        if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
            return this.\u04f9;
        }
        return this.\u0531;
    }

    protected Rectangle2D.Double getShapeBounds(Element element, Point2D.Double point, Bubble bubble, int index) {
        int w = (int)this.getShapeSize(element, bubble, index);
        Rectangle2D.Double bounds = new Rectangle2D.Double(point.x - (double)w, point.y - (double)w, w * 2 + 1, w * 2 + 1);
        if (this.getShapeStyle(element, bubble, index) == 2) {
            if (bounds.width % 2.0 == 1.0) {
                bounds.width += 1.0;
            }
            if (bounds.height % 2.0 == 1.0) {
                bounds.height += 1.0;
            }
        }
        return bounds;
    }

    protected double getShapeSize(Element element, Bubble bubble, int index) {
        if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
            return bubble.getValue();
        }
        Stroke stroke = this.getStroke(element);
        int w = 2;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 1;
        }
        return w;
    }

    public void removeHead(int count) {
        for (int i2 = 0; i2 < this.publishedElements.size(); ++i2) {
            Element element = (Element)this.publishedElements.get(i2);
            List valueList = this.getValues(element);
            for (int remain = count; remain > 0 && valueList.size() > 0; --remain) {
                valueList.remove(0);
                List xScaleTextList = this.getXScaleTextList();
                if (i2 != 0 || xScaleTextList == null || xScaleTextList.size() <= 0) continue;
                xScaleTextList.remove(0);
            }
        }
        this.publishData(false);
    }

    public boolean isInflexionVisible() {
        return this.\u04f1;
    }

    public void setInflexionVisible(boolean inflexionVisible) {
        this.\u04f1 = inflexionVisible;
        this.chartPane.repaint();
    }

    public int getInflexionStyle() {
        return this.\u0531;
    }

    public void setInflexionStyle(int inflexionStyle) {
        this.\u0531 = inflexionStyle;
        this.chartPane.repaint();
    }

    public int getLineType() {
        return this.\u04f8;
    }

    public void setLineType(int lineType) {
        this.\u04f8 = lineType;
        this.chartPane.repaint();
    }

    public boolean isAreaSelectable() {
        return this.\u0533;
    }

    public void setAreaSelectable(boolean areaSelectable) {
        this.\u0533 = areaSelectable;
        this.chartPane.repaint();
    }

    public boolean isShapeLineVisible() {
        return this.\u04f4;
    }

    public void setShapeLineVisible(boolean lineVisible) {
        this.\u04f4 = lineVisible;
        this.chartPane.repaint();
    }

    public boolean isShapeBubbleVisible() {
        return this.\u04f0;
    }

    public void setShapeBubbleVisible(boolean bubbleVisible) {
        this.\u04f0 = bubbleVisible;
        this.chartPane.repaint();
    }

    public float getBubbleAlpha() {
        return this.\u0534;
    }

    public void setBubbleAlpha(float bubbleAlpha) {
        this.\u0534 = bubbleAlpha;
        if (bubbleAlpha > 1.0f) {
            this.\u0534 = 1.0f;
        }
        if (bubbleAlpha < 0.0f) {
            this.\u0534 = 0.0f;
        }
        this.chartPane.repaint();
    }

    public int getBubbleGradientFactory() {
        return this.\u04f5;
    }

    public void setBubbleGradientFactory(int bubbleGradientFactory) {
        this.\u04f5 = bubbleGradientFactory;
        this.chartPane.repaint();
    }

    public boolean isBubbleGradient() {
        return this.\u04f3;
    }

    public void setBubbleGradient(boolean bubbleGradient) {
        this.\u04f3 = bubbleGradient;
        this.chartPane.repaint();
    }

    public int getBubbleStyle() {
        return this.\u04f9;
    }

    public void setBubbleStyle(int bubbleStyle) {
        this.\u04f9 = bubbleStyle;
        this.chartPane.repaint();
    }

    public Color getBubbleGradientColor() {
        return this.\u04f2;
    }

    public void setBubbleGradientColor(Color bubbleGradientColor) {
        this.\u04f2 = bubbleGradientColor;
        this.chartPane.repaint();
    }

    public int getValueSpanCount() {
        return this.\u0532;
    }

    public void setValueSpanCount(int valueSpanCount) {
        this.\u0532 = valueSpanCount;
        this.chartPane.repaint();
    }

    protected void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        SVGBubbleChart chart = (SVGBubbleChart)abschart;
        chart.setInflexionVisible(this.isInflexionVisible());
        chart.setInflexionStyle(this.getInflexionStyle());
        chart.setLineType(this.getLineType());
        chart.setAreaSelectable(this.isAreaSelectable());
        chart.setShapeLineVisible(this.isShapeLineVisible());
        chart.setShapeBubbleVisible(this.isShapeBubbleVisible());
        chart.setBubbleAlpha(this.getBubbleAlpha());
        chart.setBubbleGradientFactory(this.getBubbleGradientFactory());
        chart.setBubbleGradient(this.isBubbleGradient());
        chart.setBubbleStyle(this.getBubbleStyle());
        chart.setBubbleGradientColor(this.getBubbleGradientColor());
        chart.setValueSpanCount(this.getValueSpanCount());
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGBubbleChart chart = new SVGBubbleChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }
}

