/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import twaver.Node;
import twaver.TWaverUtil;
import twaver.base.A.E.E;
import twaver.base.A.E.W;
import twaver.base.A.E.b;
import twaver.base.A.E.j;

public class Group
extends Node {
    protected int groupType = 1;
    protected boolean expand = false;
    private boolean O = true;
    private transient Rectangle N = null;
    private boolean M = false;

    public Group() {
    }

    public Group(Object id) {
        super(id);
    }

    public String getUIClassID() {
        return "GroupUI";
    }

    public String getSVGUIClassID() {
        return "GroupSVGUI";
    }

    public boolean isExpand() {
        return this.expand;
    }

    public boolean isAdjustToBottom() {
        return W.C(this) && E.A(this);
    }

    public void setExpand(boolean expand) {
        if (this.expand == expand) {
            return;
        }
        boolean oldValue = this.expand;
        this.expand = expand;
        this.firePropertyChange("expand", oldValue, expand);
    }

    public Rectangle getBounds() {
        return (Rectangle)this.getShape().clone();
    }

    public final Point getLocation() {
        return this.getShape().getLocation();
    }

    public final int getWidth() {
        return this.getShape().width;
    }

    public final int getHeight() {
        return this.getShape().height;
    }

    public final Rectangle getShape() {
        if (this.O || this.N == null) {
            this.O = false;
            Rectangle oldShape = this.N;
            Rectangle rect = j.A(this);
            if (rect == null) {
                this.N = W.E(this);
            } else if (this.isExpand()) {
                this.N = rect;
            } else {
                int w = W.H(this);
                int h2 = W.A(this);
                this.N = new Rectangle((int)(rect.getCenterX() - (double)w / 2.0), (int)(rect.getCenterY() - (double)h2 / 2.0), w, h2);
            }
            this.A(this.N.getX(), this.N.getY());
            if (oldShape != null) {
                this.firePropertyChange("width", oldShape.width, this.N.width);
                this.firePropertyChange("height", oldShape.height, this.N.height);
            } else {
                this.firePropertyChange("width", -1, this.N.width);
                this.firePropertyChange("height", -1, this.N.height);
            }
            this.firePropertyChange("groupModelShape", -1, this.N.height);
        }
        return this.N;
    }

    public void setLocation(Point2D.Double location) {
        if (this.M || location == null) {
            return;
        }
        this.invalidateGroupShape();
        double xOffset = location.getX() - this.xLocation;
        double yOffset = location.getY() - this.yLocation;
        if (xOffset == 0.0 && yOffset == 0.0) {
            return;
        }
        if (this.F()) {
            this.M = true;
            TWaverUtil.moveElements(this.getChildren().iterator(), null, xOffset, yOffset);
            this.M = false;
        } else {
            this.A(location.getX(), location.getY());
        }
        this.invalidateGroupShape();
    }

    private boolean F() {
        if (!W.D(this)) {
            return false;
        }
        return !TWaverUtil.isXMLParsing();
    }

    private void A(double x, double y) {
        Point2D.Double oldValue = new Point2D.Double(this.xLocation, this.yLocation);
        this.xLocation = x;
        this.yLocation = y;
        this.firePropertyChange("location", oldValue, new Point2D.Double(x, y));
    }

    public boolean isAdjusting() {
        return this.M;
    }

    public void invalidateGroupShape() {
        if (this.M) {
            return;
        }
        this.O = true;
        this.getShape();
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        if (this.groupType != groupType && (groupType == 1 || groupType == 2 || groupType == 3 || groupType == 4 || groupType == 5 || groupType == 6)) {
            int oldValue = this.groupType;
            this.groupType = groupType;
            this.firePropertyChange("groupType", oldValue, this.groupType);
        }
    }

    public void putClientProperty(Object key, Object value) {
        super.putClientProperty(key, value);
        if (key.equals("group.outline.dash") && Boolean.TRUE.equals(value)) {
            this.putClientProperty((Object)"group.outline.stroke", "square.thinnest");
        }
    }

    public void putGroupOutline(boolean groupOutline) {
        this.putClientProperty((Object)"group.outline", groupOutline);
    }

    public void putGroupOutlineStroke(String groupOutlineStroke) {
        this.putClientProperty((Object)"group.outline.stroke", groupOutlineStroke);
    }

    public void putGroupFill(boolean groupFill) {
        this.putClientProperty((Object)"group.fill", groupFill);
    }

    public void putGroupOpaque(boolean groupOpaque) {
        this.putClientProperty((Object)"group.opaque", groupOpaque);
    }

    public void putGroupOutlineColor(Color groupOutlineColor) {
        this.putClientProperty((Object)"group.outline.color", groupOutlineColor);
    }

    public void putGroupFillColor(Color groupFillColor) {
        this.putClientProperty((Object)"group.fill.color", groupFillColor);
    }

    public void putGroupChildrenOutcrop(int groupChildrenOutcrop) {
        this.putClientProperty((Object)"group.children.outcrop", groupChildrenOutcrop);
    }

    public void putGroupInsets(Insets groupInsets) {
        this.putClientProperty((Object)"group.insets", groupInsets);
    }

    public void putGroupHandlerExpandIcon(String groupHandlerExpandIcon) {
        this.putClientProperty((Object)"group.handler.expand.icon", groupHandlerExpandIcon);
    }

    public void putGroupHandlerCloseIcon(String groupHandlerCloseIcon) {
        this.putClientProperty((Object)"group.handler.close.icon", groupHandlerCloseIcon);
    }

    public void putGroupHandlerEmptyIcon(String groupHandlerEmptyIcon) {
        this.putClientProperty((Object)"group.handler.empty.icon", groupHandlerEmptyIcon);
    }

    public void putGroupDoubleClickEnabled(boolean groupDoubleClickEnabled) {
        this.putClientProperty((Object)"group.double.click.enable", groupDoubleClickEnabled);
    }

    public void putGroupAngle(int groupAngle) {
        this.putClientProperty((Object)"group.angle", groupAngle);
    }

    public void putGroup3D(boolean group3D) {
        this.putClientProperty((Object)"group.3d", group3D);
    }

    public void putGroupAntialias(boolean groupAntialias) {
        this.putClientProperty((Object)"group.antialias", groupAntialias);
    }

    public void putGroupDeep(int groupDeep) {
        this.putClientProperty((Object)"group.deep", groupDeep);
    }

    public void putGroupHandlerVisible(boolean groupHandlerVisible) {
        this.putClientProperty((Object)"group.handler.visible", groupHandlerVisible);
    }

    public void putGroupHandlerPosition(int groupHandlerPosition) {
        this.putClientProperty((Object)"group.handler.position", groupHandlerPosition);
    }

    public void putGroupHandlerXoffset(int groupHandlerXoffset) {
        this.putClientProperty((Object)"group.handler.xoffset", groupHandlerXoffset);
    }

    public void putGroupHandlerYoffset(int groupHandlerYoffset) {
        this.putClientProperty((Object)"group.handler.yoffset", groupHandlerYoffset);
    }

    public void putGroupGradient(boolean groupGradient) {
        this.putClientProperty((Object)"group.gradient", groupGradient);
    }

    public void putGroupGradientColor(Color groupGradientColor) {
        this.putClientProperty((Object)"group.gradient.color", groupGradientColor);
    }

    public void putGroupGradientFactory(int groupGradientFactory) {
        this.putClientProperty((Object)"group.gradient.factory", groupGradientFactory);
    }

    public int getGroupAngle() {
        return b.J(this, "group.angle");
    }

    public boolean isGroup3D() {
        return b.K(this, "group.3d");
    }

    public int getGroupDeep() {
        return b.J(this, "group.deep");
    }

    public boolean isGroupOutline() {
        return b.K(this, "group.outline");
    }

    public String getGroupOutlineStroke() {
        return b.Q(this, "group.outline.stroke");
    }

    public boolean isGroupFill() {
        return b.K(this, "group.fill");
    }

    public boolean isGroupOpaque() {
        return b.K(this, "group.opaque");
    }

    public Color getGroupOutlineColor() {
        return b.P(this, "group.outline.color");
    }

    public Color getGroupFillColor() {
        return b.P(this, "group.fill.color");
    }

    public boolean isGroupAntialias() {
        return b.K(this, "group.antialias");
    }

    public Insets getGroupInsets() {
        return b.B(this, "group.insets");
    }

    public int getGroupChildrenOutcrop() {
        return b.J(this, "group.children.outcrop");
    }

    public boolean isGroupDoubleClickEnable() {
        return b.K(this, "group.double.click.enable");
    }

    public String getGroupHandlerExpandIcon() {
        return b.Q(this, "group.handler.expand.icon");
    }

    public String getGroupHandlerCloseIcon() {
        return b.Q(this, "group.handler.close.icon");
    }

    public String getGroupHandlerEmptyIcon() {
        return b.Q(this, "group.handler.empty.icon");
    }

    public boolean isGroupHandlerVisible() {
        return b.K(this, "group.handler.visible");
    }

    public int getGroupHandlerPosition() {
        return b.J(this, "group.handler.position");
    }

    public int getGroupHandlerXOffset() {
        return b.J(this, "group.handler.xoffset");
    }

    public int getGroupHandlerYOffset() {
        return b.J(this, "group.handler.yoffset");
    }

    public boolean isGroupGradient() {
        return b.K(this, "group.gradient");
    }

    public Color getGroupGradientColor() {
        return b.P(this, "group.gradient.color");
    }

    public int getGroupGradientFactory() {
        return b.J(this, "group.gradient.factory");
    }

    public void putGroupChamferEdge(int chamferLength) {
        this.putClientProperty((Object)"group.chamfer.edge", chamferLength);
    }

    public int getGroupChamferEdge() {
        return b.J(this, "group.chamfer.edge");
    }
}

