/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import twaver.Element;
import twaver.TDataBox;
import twaver.TSubNetwork;
import twaver.TWaverUtil;
import twaver.base.A.E.M;
import twaver.base.A.E.O;
import twaver.network.background.Background;
import twaver.network.background.ImageBackground;
import twaver.network.background.TextureBackground;

public class DataBoxJarWriter {
    private OutputStream A = null;

    public DataBoxJarWriter(OutputStream output) {
        this.A = output;
    }

    public void write(TDataBox box) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(this.A);
        Map map = this.A(box, jarOutputStream);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        box.getSelectionModel().clearSelection();
        box.output(byteOutputStream, false);
        String xmlString = byteOutputStream.toString("UTF-8");
        byteOutputStream.close();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            String imageURL = (String)key;
            String entryName = (String)value;
            String imageTag = "<string>" + imageURL + "</string>";
            String newImageTag = "<string>" + entryName + "</string>";
            xmlString = M.A(xmlString, imageTag, newImageTag);
        }
        ByteArrayInputStream bytesInputStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        this.A(jarOutputStream, bytesInputStream, "data.xml");
        bytesInputStream.close();
        jarOutputStream.close();
    }

    private String A(Background background) {
        String imageURL = null;
        if (background != null) {
            if (background instanceof ImageBackground) {
                imageURL = ((ImageBackground)background).getImageURL();
            } else if (background instanceof TextureBackground) {
                imageURL = ((TextureBackground)background).getImageURL();
            }
        }
        if ("-".equals(imageURL)) {
            return null;
        }
        return imageURL;
    }

    private Map A(TDataBox box, JarOutputStream jar) throws IOException {
        TreeSet<String> set = new TreeSet<String>();
        Iterator it = box.iterator();
        while (it.hasNext()) {
            Background background;
            String imageURL;
            Element element = (Element)it.next();
            String iconURL = element.getIconURL();
            if (iconURL != null && !iconURL.equals("-")) {
                set.add(iconURL);
            }
            if ((imageURL = element.getImageURL()) != null && !imageURL.equals("-")) {
                set.add(imageURL);
            }
            if (!(element instanceof TSubNetwork) || (imageURL = this.A(background = ((TSubNetwork)element).getBackground())) == null) continue;
            set.add(imageURL);
        }
        Background background = box.getBackground();
        String backGroundImageURL = this.A(background);
        if (backGroundImageURL != null) {
            set.add(backGroundImageURL);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        it = set.iterator();
        int index = 1;
        while (it.hasNext()) {
            Image img;
            Object o2 = it.next();
            String imageURL = (String)o2;
            InputStream inputStream = TWaverUtil.getInputStream(imageURL, false);
            if (inputStream == null && (img = TWaverUtil.getImage(imageURL)) != null) {
                inputStream = new ByteArrayInputStream(O.A(img, "png"));
            }
            if (inputStream == null) continue;
            int endIndex = imageURL.lastIndexOf(".");
            String extName = imageURL;
            if (endIndex >= 0) {
                extName = imageURL.substring(imageURL.lastIndexOf("."));
            }
            String jarEntryName = "JarImage_" + index + extName;
            this.A(jar, inputStream, jarEntryName);
            inputStream.close();
            ++index;
            map.put(imageURL, jarEntryName);
        }
        return map;
    }

    private void A(JarOutputStream jarOutput, InputStream inputStream, String name) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        JarEntry jarEntry = new JarEntry(name);
        jarOutput.putNextEntry(jarEntry);
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            jarOutput.write(buffer, 0, bytesRead);
        }
    }
}

