/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.frame;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.window.WindowManager;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class JBasicFrame
extends JFrame {
    private boolean hint = true;
    private boolean destroy = true;

    public JBasicFrame() {
        this("");
    }

    public JBasicFrame(String title) {
        this(title, true);
    }

    public JBasicFrame(String title, ImageIcon imageIcon) {
        this(title, imageIcon, true);
    }

    public JBasicFrame(String title, Dimension dimension) {
        this(title, null, dimension);
    }

    public JBasicFrame(String title, boolean destroy) {
        this(title, (Dimension)null, destroy);
    }

    public JBasicFrame(String title, ImageIcon imageIcon, Dimension dimension) {
        this(title, imageIcon, dimension, true);
    }

    public JBasicFrame(String title, ImageIcon imageIcon, boolean destroy) {
        this(title, imageIcon, true, destroy);
    }

    public JBasicFrame(String title, Dimension dimension, boolean destroy) {
        this(title, dimension, true, destroy);
    }

    public JBasicFrame(String title, boolean hint, boolean destroy) {
        this(title, (Dimension)null, hint, destroy);
    }

    public JBasicFrame(String title, ImageIcon imageIcon, Dimension dimension, boolean destroy) {
        this(title, imageIcon, dimension, true, destroy);
    }

    public JBasicFrame(String title, ImageIcon imageIcon, boolean hint, boolean destroy) {
        this(title, imageIcon, null, hint, destroy);
    }

    public JBasicFrame(String title, Dimension dimension, boolean hint, boolean destroy) {
        this(title, null, dimension, hint, destroy);
    }

    public JBasicFrame(String title, ImageIcon imageIcon, Dimension dimension, boolean hint, boolean destroy) {
        super(title);
        this.hint = hint;
        this.destroy = destroy;
        WindowManager.setCenter(this, dimension);
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
    }

    public boolean isHint() {
        return this.hint;
    }

    public void setHint(boolean hint) {
        this.hint = hint;
    }

    public boolean isDestroy() {
        return this.destroy;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        int selectedValue;
        if (this.hint && e.getID() == 201 && (selectedValue = JBasicOptionPane.showConfirmDialog(this, SwingLocale.getString("confirm_to_exit"), SwingLocale.getString("confirm"), 0)) != 0) {
            return;
        }
        super.processWindowEvent(e);
        if (this.destroy && e.getID() == 201) {
            System.exit(0);
        }
    }

    @Override
    public void setExtendedState(int state) {
        if ((state & 6) == 6) {
            Rectangle bounds = this.getGraphicsConfiguration().getBounds();
            Rectangle maxBounds = null;
            if (bounds.x == 0 && bounds.y == 0) {
                Insets screenInsets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
                maxBounds = new Rectangle(screenInsets.left, screenInsets.top, bounds.width - screenInsets.right - screenInsets.left, bounds.height - screenInsets.bottom - screenInsets.top);
            } else {
                maxBounds = null;
            }
            super.setMaximizedBounds(maxBounds);
        }
        super.setExtendedState(state);
    }
}

