/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.scheduler.quartz;

import com.nepxion.util.scheduler.quartz.QuartzConstants;
import com.nepxion.util.scheduler.quartz.QuartzSchedulerFactory;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class QuartzContext
implements QuartzConstants {
    private static Log log = LogFactory.getLog(QuartzContext.class);
    private static QuartzSchedulerFactory factory;
    private static Scheduler scheduler;

    public static void register() throws SchedulerException {
        QuartzContext.register("conf/quartz.properties");
    }

    public static void register(String filePath) throws SchedulerException {
        log.info((Object)"--- Quartz Scheduler Initialization Start ---");
        try {
            factory = new QuartzSchedulerFactory(filePath);
            scheduler = factory.getScheduler();
        }
        catch (SchedulerException e) {
            log.fatal((Object)e);
            throw e;
        }
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
        log.info((Object)"---- Quartz Scheduler Initialization End ----");
    }

    public static void register(Properties properties) throws SchedulerException {
        log.info((Object)"--- Quartz Scheduler Initialization Start ---");
        try {
            factory = new QuartzSchedulerFactory(properties);
            scheduler = factory.getScheduler();
        }
        catch (SchedulerException e) {
            log.fatal((Object)e);
            throw e;
        }
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
        log.info((Object)"---- Quartz Scheduler Initialization End ----");
    }

    public static void register(URL codeBase) throws Exception {
        Properties properties = new Properties();
        try {
            URL url = new URL(codeBase + "conf/quartz.properties");
            properties.load(url.openStream());
            QuartzContext.register(properties);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
    }

    public static QuartzSchedulerFactory getFactory() {
        return factory;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }
}

