/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.Arrays;
import java.util.Comparator;
import y.algo.GraphConnectivity;
import y.algo.ShortestPaths;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YList;
import y.base.if;
import y.layout.planar.DualPlanarInformation;
import y.layout.planar.EdgeInserter;
import y.layout.planar.PlanarInformation;
import y.util.D;

public class SimpleEdgeRouter {
    public static final short DUAL = 0;
    public static final short REAL = 1;
    private PlanarInformation g;
    private EdgeInserter f;
    _a b;
    _if[] e;
    private double[] h;
    private double[] i;
    private int[] c;
    private int[] d;
    private Edge[] a;

    public SimpleEdgeRouter(PlanarInformation planarInformation) {
        this.g = planarInformation;
        int n = 2 * this.g.getGraph().N();
        this.f = new EdgeInserter(planarInformation);
        this.c = new int[2 * this.g.getGraph().E()];
        this.d = new int[n];
        this.a = new Edge[n];
        this.i = new double[n];
        this.h = new double[2 * this.g.getGraph().E()];
        this.b = new _a(n);
        this.e = new _if[n];
    }

    public void insertEdges(EdgeList edgeList) {
        DualPlanarInformation dualPlanarInformation = new DualPlanarInformation(this.g, edgeList);
        dualPlanarInformation.subscribe();
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            EdgeList edgeList2 = this.routeEdge(edge, (short)1, dualPlanarInformation, null);
            this.f.insertEdge(edgeList2, edge);
            if (D.watchSource(this) && !this.g.isPlanar()) {
                throw new RuntimeException("Combinatorial Embedder failed !");
            }
            edgeCursor.next();
        }
        dualPlanarInformation.unsubscribe();
        dualPlanarInformation.dispose();
    }

    public void insertEdge(Edge edge) {
        DualPlanarInformation dualPlanarInformation = new DualPlanarInformation(this.g);
        EdgeList edgeList = this.routeEdge(edge, (short)1, dualPlanarInformation, null);
        this.f.insertEdge(edgeList, edge);
        dualPlanarInformation.dispose();
    }

    protected EdgeList routeEdge(Edge edge, short s, DualPlanarInformation dualPlanarInformation, Edge[] edgeArray) {
        Object object;
        Object object2;
        if if_;
        Object object3;
        Graph graph = dualPlanarInformation.getGraph();
        Node node = graph.createNode();
        Node node2 = graph.createNode();
        EdgeCursor edgeCursor = edge.source().outEdges();
        while (edgeCursor.ok()) {
            object3 = edgeCursor.edge();
            if_ = dualPlanarInformation.getDualNode(this.g.faceOf((Edge)object3));
            object2 = graph.createEdge(node, (Node)if_);
            edgeCursor.next();
        }
        object3 = edge.target().outEdges();
        while (object3.ok()) {
            if_ = object3.edge();
            object2 = dualPlanarInformation.getDualNode(this.g.faceOf((Edge)if_));
            object = graph.createEdge((Node)object2, node2);
            object3.next();
        }
        while (this.a.length < graph.N()) {
            this.a = new Edge[2 * this.a.length];
        }
        while (this.c.length < graph.E()) {
            this.c = new int[2 * this.c.length];
        }
        while (this.d.length < graph.N()) {
            this.d = new int[2 * this.d.length];
        }
        Arrays.fill(this.c, 1);
        if (edgeArray != null) {
            int n = 0;
            while (n < edgeArray.length) {
                this.c[edgeArray[n].index()] = 0;
                ++n;
            }
        }
        this.dijkstra(graph, node, node2, true, this.c, this.d, this.a);
        object2 = ShortestPaths.constructEdgePath(node, node2, this.a);
        if (this.d[node2.index()] == Integer.MAX_VALUE) {
            object2 = null;
        }
        if (object2 == null && D.watchSource(this)) {
            object = graph.createNodeMap();
            GraphConnectivity.connectedComponents(graph, (NodeMap)object);
            boolean bl = object.getInt(node) == object.getInt(node2);
            graph.disposeNodeMap((NodeMap)object);
            if (bl) {
                throw new RuntimeException("Error computing shortest dual path");
            }
        }
        if (object2 != null) {
            ((EdgeList)object2).popEdge();
            ((YList)object2).remove(((YList)object2).last());
        }
        graph.removeNode(node);
        graph.removeNode(node2);
        switch (s) {
            case 0: {
                return object2;
            }
            case 1: {
                return this.a(dualPlanarInformation, (EdgeList)object2);
            }
        }
        throw new RuntimeException("Unknown return type style in EdgeRouter.routeEdge()");
    }

    private EdgeList a(DualPlanarInformation dualPlanarInformation, EdgeList edgeList) {
        EdgeList edgeList2 = new EdgeList();
        if (edgeList == null) {
            return null;
        }
        if (edgeList.isEmpty()) {
            return edgeList2;
        }
        Edge edge = null;
        Edge edge2 = null;
        EdgeCursor edgeCursor = edgeList.edges();
        edgeCursor.toLast();
        while (edgeCursor.ok()) {
            edge = edgeCursor.edge();
            edge2 = dualPlanarInformation.getRealEdge(edge);
            edgeList2.addFirst(edge2);
            edgeCursor.prev();
        }
        return edgeList2;
    }

    public void rerouteEdges(int n, EdgeList edgeList) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        DualPlanarInformation dualPlanarInformation = new DualPlanarInformation(this.g);
        dualPlanarInformation.subscribe();
        block0: while (!bl) {
            Object object;
            Object object2;
            EdgeList edgeList2 = new EdgeList(edgeList.edges());
            EdgeCursor edgeCursor = edgeList2.edges();
            while (edgeCursor.ok()) {
                object2 = edgeCursor.edge();
                object = this.g.getCurrentPath((Edge)object2);
                if (object.size() == 1) {
                    edgeList2.remove(object2);
                }
                edgeCursor.next();
            }
            if (edgeList2.size() == 0 || n != -1 && n2 >= n) break;
            ++n2;
            edgeList2.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    int n;
                    Edge edge = (Edge)object;
                    Edge edge2 = (Edge)object2;
                    int n2 = SimpleEdgeRouter.this.g.getCurrentPath(edge).size();
                    if (n2 == (n = SimpleEdgeRouter.this.g.getCurrentPath(edge2).size())) {
                        return 0;
                    }
                    if (n2 > n) {
                        return -1;
                    }
                    return 1;
                }
            });
            object2 = edgeList2.edges();
            while (object2.ok()) {
                int n4;
                boolean bl2;
                Object object3;
                object = object2.edge();
                Edge[] edgeArray = new Edge[2 * this.g.getCurrentPath((Edge)object).size()];
                int n5 = 0;
                EdgeCursor edgeCursor2 = this.g.getCurrentPath((Edge)object);
                while (edgeCursor2.ok()) {
                    object3 = dualPlanarInformation.getDualEdge(edgeCursor2.edge());
                    edgeArray[n5++] = object3;
                    edgeArray[n5++] = dualPlanarInformation.getReverse((Edge)object3);
                    edgeCursor2.next();
                }
                EdgeList edgeList3 = this.routeEdge((Edge)object, (short)0, dualPlanarInformation, edgeArray);
                int n6 = 0;
                if (edgeList3.size() != 0) {
                    object3 = edgeList3.edges();
                    while (object3.ok()) {
                        if (this.c[object3.edge().index()] > 0) {
                            ++n6;
                        }
                        object3.next();
                    }
                }
                boolean bl3 = bl2 = (n4 = this.g.getCurrentPath((Edge)object).size() - 1) > n6;
                if (bl2) {
                    n3 += n4 - n6;
                    this.a((Edge)object);
                    edgeList3 = this.routeEdge((Edge)object, (short)1, dualPlanarInformation, null);
                    this.f.insertEdge(edgeList3, (Edge)object);
                    continue block0;
                }
                object2.next();
            }
            bl = true;
            dualPlanarInformation.unsubscribe();
            dualPlanarInformation.dispose();
        }
        if (n3 == 0) {
            D.bug(this, 0, "  no improvement gained by rerouting edges");
        } else {
            D.bug(this, 0, "  improvement: " + n3 + " crossing(s) less");
        }
    }

    public void rerouteEdges(EdgeList edgeList) {
        this.rerouteEdges(-1, edgeList);
    }

    private void a(Edge edge) {
        Object object;
        NodeList nodeList = new NodeList();
        EdgeCursor edgeCursor = this.g.getCurrentPath(edge);
        while (edgeCursor.ok()) {
            object = edgeCursor.edge();
            if (((Edge)object).target() != edge.target()) {
                nodeList.add(((Edge)object).target());
            }
            this.g.unsplitFace((Edge)object);
            edgeCursor.next();
        }
        object = nodeList.nodes();
        while (object.ok()) {
            this.g.unsubdivideEdge(object.node());
            object.next();
        }
    }

    public void dijkstra(Graph graph, Node node, Node node2, boolean bl, int[] nArray, int[] nArray2, Edge[] edgeArray) {
        int n = graph.N();
        while (this.e.length < n) {
            this.e = new _if[2 * this.e.length];
        }
        int n2 = 0;
        while (n2 < n) {
            edgeArray[n2] = null;
            nArray2[n2] = Integer.MAX_VALUE;
            ++n2;
        }
        int n3 = node.index();
        nArray2[n3] = 0;
        this.b.a();
        this.e[n3] = this.b.a(0, node, this.e[n3], n3);
        while (!this.b.d()) {
            _if _if2 = this.b.b();
            this.b.a(_if2);
            Node node3 = _if2.c;
            if (node3 == node2) break;
            int n4 = _if2.d;
            int n5 = nArray2[n4];
            Edge edge = node3.firstOutEdge();
            while (edge != null) {
                block8: {
                    block7: {
                        int n6;
                        int n7;
                        block6: {
                            Node node4 = edge.target();
                            n7 = node4.index();
                            n6 = n5 + nArray[edge.index()];
                            if (edgeArray[n7] != null || node4 == node) break block6;
                            nArray2[n7] = n6;
                            this.e[n7] = this.b.a(n6, node4, this.e[n7], n7);
                            break block7;
                        }
                        if (n6 >= nArray2[n7]) break block8;
                        nArray2[n7] = n6;
                        this.b.a(this.e[n7], n6);
                    }
                    edgeArray[n7] = edge;
                }
                edge = edge.nextOutEdge();
            }
        }
    }

    class _a {
        private _if[] b;
        private int a;
        private int c;

        public _a(int n) {
            this.b = new _if[n + 2];
            this.a = 0;
            this.c = n;
        }

        public _if a(int n, Node node, _if _ifArray, int n2) {
            Object object;
            if (this.a == this.c) {
                this.c += 1024;
                object = new _if[this.c + 2];
                System.arraycopy(this.b, 0, object, 0, this.b.length);
                this.b = object;
            }
            ++this.a;
            if (_ifArray == null) {
                object = new _if(n, node, this.a, n2);
            } else {
                object = _ifArray;
                _ifArray.b = n;
                _ifArray.c = node;
                _ifArray.a = this.a;
                _ifArray.d = n2;
            }
            this.a(this.a, (_if)object);
            return object;
        }

        public void a() {
            int n = 1;
            while (n <= this.a) {
                this.b[n] = null;
                ++n;
            }
            this.a = 0;
        }

        public void a(int n, _if _if2) {
            this.b[0] = _if2;
            int n2 = n / 2;
            _if _if3 = this.b[n2];
            while (_if3.b > _if2.b) {
                this.b[n] = _if3;
                _if3.a = n;
                n = n2;
                _if3 = this.b[n2 >>= 1];
            }
            this.b[n] = _if2;
            _if2.a = n;
        }

        public void b(int n, _if _if2) {
            int n2 = n << 1;
            this.b[this.a + 1] = this.b[this.a];
            while (n2 <= this.a) {
                _if _if3 = this.b[n2];
                if (n2 < this.a && this.b[n2 + 1].b < _if3.b) {
                    _if3 = this.b[++n2];
                }
                if (_if2.b <= _if3.b) break;
                this.b[n] = _if3;
                _if3.a = n;
                n = n2;
                n2 <<= 1;
            }
            this.b[n] = _if2;
            _if2.a = n;
        }

        public void a(_if _if2) {
            _if _if3 = this.b[this.a];
            this.b[this.a] = null;
            --this.a;
            if (_if2 != _if3) {
                if (_if3.b > _if2.b) {
                    this.b(_if2.a, _if3);
                } else {
                    this.a(_if2.a, _if3);
                }
            }
        }

        public void a(_if _if2, int n) {
            _if2.b = n;
            this.a(_if2.a, _if2);
        }

        public _if b() {
            return this.b[1];
        }

        public boolean d() {
            return this.a == 0;
        }

        public int c() {
            return this.a;
        }
    }

    static class _if {
        int b;
        Node c;
        int d;
        int a;

        _if(int n, Node node, int n2, int n3) {
            this.b = n;
            this.c = node;
            this.a = n2;
            this.d = n3;
        }
    }
}

