/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.layout.CanonicMultiStageLayouter;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.PortConstraintKeys;
import y.layout.hierarchic.ClassicLayerSequencer;
import y.layout.hierarchic.Drawer;
import y.layout.hierarchic.LayerSequencer;
import y.layout.hierarchic.Layerer;
import y.layout.hierarchic.MedianLinearSegmentDrawer;
import y.layout.hierarchic.PendularDrawer;
import y.layout.hierarchic.PolylineDrawer;
import y.layout.hierarchic.SimplexDrawer;
import y.layout.hierarchic.TopologicalLayerer;
import y.layout.hierarchic.TreeDrawer;
import y.layout.hierarchic.a;
import y.layout.hierarchic.int;
import y.util.D;

public class HierarchicLayouter
extends CanonicMultiStageLayouter
implements PortConstraintKeys {
    public static final byte PENDULUM = 0;
    public static final byte LINEAR_SEGMENTS = 1;
    public static final byte POLYLINE = 2;
    public static final byte TREE = 3;
    public static final byte SIMPLEX = 4;
    public static final byte ROUTE_POLYLINE = 0;
    public static final byte ROUTE_ORTHOGONAL = 1;
    private byte jb = 0;
    private long i6;
    private long i3 = Integer.MAX_VALUE;
    private boolean i9 = true;
    private int i5 = 1;
    private double i0 = 60.0;
    private double iz = 20.0;
    private double i2 = 20.0;
    private double i4 = 20.0;
    private boolean ja = true;
    private Layerer i7;
    private LayerSequencer i1;
    private Drawer i8;

    public HierarchicLayouter() {
        this.setLayoutStyle((byte)0);
        this.setParallelEdgeLayouterEnabled(false);
        this.setSelfLoopLayouterEnabled(false);
        this.i7 = new TopologicalLayerer();
        this.i1 = new ClassicLayerSequencer();
        this.i8 = new MedianLinearSegmentDrawer();
    }

    public void setRoutingStyle(byte by) {
        this.jb = by;
    }

    public byte getRoutingStyle() {
        return this.jb;
    }

    public void setLayoutStyle(byte by) {
        D.bug(this, (Object)("Set Layout style: " + by));
        switch (by) {
            case 2: {
                this.i8 = new PolylineDrawer();
                break;
            }
            case 1: {
                this.i8 = new MedianLinearSegmentDrawer();
                break;
            }
            case 0: {
                this.i8 = new PendularDrawer();
                break;
            }
            case 3: {
                this.i8 = new TreeDrawer();
                break;
            }
            case 4: {
                this.i8 = new SimplexDrawer();
                break;
            }
            default: {
                this.i8 = new MedianLinearSegmentDrawer();
            }
        }
    }

    public byte getLayoutStyle() {
        if (this.i8 instanceof PolylineDrawer) {
            return 2;
        }
        if (this.i8 instanceof MedianLinearSegmentDrawer) {
            return 1;
        }
        if (this.i8 instanceof TreeDrawer) {
            return 3;
        }
        if (this.i8 instanceof PendularDrawer) {
            return 0;
        }
        if (this.i8 instanceof SimplexDrawer) {
            return 4;
        }
        return -1;
    }

    public void setLayerer(Layerer layerer) {
        this.i7 = layerer;
    }

    public Layerer getLayerer() {
        return this.i7;
    }

    public void setLayerSequencer(LayerSequencer layerSequencer) {
        this.i1 = layerSequencer;
    }

    public LayerSequencer getLayerSequencer() {
        return this.i1;
    }

    public void setDrawer(Drawer drawer) {
        this.i8 = drawer;
        this.i8.setMinimalNodeDistance(this.iz);
        this.i8.setMinimalLayerDistance(this.i0);
    }

    public boolean getUsePorts() {
        return this.ja;
    }

    public void setMinimalNodeDistance(double d2) {
        this.iz = d2;
        this.i8.setMinimalNodeDistance(d2);
    }

    public double getMinimalNodeDistance() {
        return this.iz;
    }

    public void setMinimalEdgeDistance(double d2) {
        this.i2 = d2;
        this.i8.setMinimalEdgeDistance(d2);
    }

    public double getMinimalEdgeDistance() {
        return this.i2;
    }

    public void setMinimalLayerDistance(double d2) {
        this.i0 = d2;
        this.i8.setMinimalLayerDistance(d2);
    }

    public double getMinimalLayerDistance() {
        return this.i0;
    }

    public void setRemoveFalseCrossings(boolean bl) {
        this.i9 = bl;
    }

    public boolean getRemoveFalseCrossings() {
        return this.i9;
    }

    public void setMaximalDuration(long l) {
        this.i3 = l;
    }

    public long getMaximalDuration() {
        return this.i3;
    }

    public void setBendReductionThreshold(int n) {
        this.i5 = n;
    }

    public int getBendReductionThreshold() {
        return this.i5;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        NodeList[] nodeListArray;
        this.i6 = System.currentTimeMillis();
        LayoutTool.resetPaths(layoutGraph, false);
        NodeMap nodeMap = layoutGraph.createNodeMap();
        NodeMap nodeMap2 = layoutGraph.createNodeMap();
        EdgeMap edgeMap = layoutGraph.createEdgeMap();
        EdgeList edgeList = new EdgeList();
        int intVal = new int(layoutGraph, nodeMap, nodeMap2, edgeMap);
        intVal.a(true);
        a a2 = new a(layoutGraph, nodeMap, nodeMap2, edgeMap);
        a2.a(this.getRoutingStyle() == 1);
        a2.a(this.getMinimalEdgeDistance());
        this.i8.setMinimalNodeDistance(this.iz);
        this.i8.setMinimalLayerDistance(this.i0);
        this.i8.setMinimalEdgeDistance(this.i2);
        this.i8.setMinimalMultiEdgeDistance(this.i4);
        this.i8.setDummyMap(nodeMap2);
        a2.h();
        int n = this.i7.assignNodeLayer(layoutGraph, nodeMap, edgeList);
        a2.b();
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            nodeListArray = edgeCursor.edge();
            edgeMap.setBool(nodeListArray, true);
            YPoint yPoint = layoutGraph.getSourcePointRel((Edge)nodeListArray);
            layoutGraph.setSourcePointRel((Edge)nodeListArray, layoutGraph.getTargetPointRel((Edge)nodeListArray));
            layoutGraph.setTargetPointRel((Edge)nodeListArray, yPoint);
            edgeCursor.next();
        }
        this.a(layoutGraph, nodeMap, nodeMap2);
        n = a2.a(n);
        nodeListArray = this.getLayerSequence(layoutGraph, nodeMap, n);
        nodeListArray = a2.a(nodeListArray);
        nodeListArray = intVal.a(nodeListArray);
        nodeListArray = a2.b(nodeListArray);
        this.i8.assignCoordinates(layoutGraph, nodeListArray, nodeMap);
        nodeListArray = a2.g(nodeListArray);
        a2.e(nodeListArray);
        intVal.b(a2.d());
        this.b(layoutGraph, nodeMap2);
        this.w(layoutGraph);
        this.a(layoutGraph, edgeList);
        a2.e();
        layoutGraph.disposeEdgeMap(edgeMap);
        layoutGraph.disposeNodeMap(nodeMap2);
        layoutGraph.disposeNodeMap(nodeMap);
    }

    protected NodeList[] getLayerSequence(LayoutGraph layoutGraph, NodeMap nodeMap, int n) {
        NodeList[] nodeListArray;
        if (this.i1 instanceof ClassicLayerSequencer) {
            nodeListArray = (NodeList[])this.i1;
            nodeListArray.setRemoveFalseCrossings(this.i9);
            long l = System.currentTimeMillis() - this.i6;
            nodeListArray.setMaximalDuration(this.i3 - l);
        }
        nodeListArray = this.i1.getLayers(layoutGraph, nodeMap, n);
        return nodeListArray;
    }

    private void a(LayoutGraph layoutGraph, EdgeList edgeList) {
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            YPoint yPoint = layoutGraph.getSourcePointAbs(edge);
            YPoint yPoint2 = layoutGraph.getTargetPointAbs(edge);
            layoutGraph.reverseEdge(edge);
            YPointPath yPointPath = layoutGraph.getPoints(edge);
            layoutGraph.setPoints(edge, yPointPath.createReverse());
            layoutGraph.setTargetPointAbs(edge, yPoint);
            layoutGraph.setSourcePointAbs(edge, yPoint2);
            edgeCursor.next();
        }
    }

    private void b(LayoutGraph layoutGraph, NodeMap nodeMap) {
        Object object;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            object = nodeCursor.node();
            Edge edge = (Edge)nodeMap.get(object);
            if (edge != null && !layoutGraph.contains(edge)) {
                YPoint yPoint;
                YPoint yPoint2;
                Node node = ((Node)object).inEdges().edge().source();
                while (nodeMap.get(node) != null) {
                    object = node;
                    node = ((Node)object).inEdges().edge().source();
                }
                layoutGraph.unhide(edge);
                Edge edge2 = ((Node)object).firstInEdge();
                YList yList = new YList();
                while (nodeMap.get(edge2.target()) != null) {
                    yPoint2 = layoutGraph.getSourcePointAbs(edge2);
                    yList.add(yPoint2);
                    yList.splice(layoutGraph.getPointList(edge2));
                    yPoint = layoutGraph.getTargetPointAbs(edge2);
                    if (!yPoint.equals(yPoint2)) {
                        yList.add(yPoint);
                    }
                    edge2 = edge2.target().firstOutEdge();
                }
                yPoint2 = layoutGraph.getSourcePointAbs(edge2);
                yList.add(yPoint2);
                yList.splice(layoutGraph.getPointList(edge2));
                yPoint = layoutGraph.getTargetPointAbs(edge2);
                if (!yPoint.equals(yPoint2)) {
                    yList.add(yPoint);
                }
                layoutGraph.setPath(edge, yList);
            }
            nodeCursor.next();
        }
        object = layoutGraph.nodes();
        while (object.ok()) {
            if (nodeMap.get(object.node()) != null) {
                layoutGraph.removeNode(object.node());
            }
            object.next();
        }
    }

    private void w(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
            if (edgeLayout.pointCount() > 0) {
                Vector<YPoint> vector = new Vector<YPoint>(edgeLayout.pointCount());
                YPointPath yPointPath = layoutGraph.getPath(edge);
                YCursor yCursor = yPointPath.cursor();
                YPoint yPoint = (YPoint)yCursor.current();
                yCursor.next();
                double d2 = yPoint.getX();
                double d3 = yPoint.getY();
                if (yCursor.ok()) {
                    yPoint = (YPoint)yCursor.current();
                    double d4 = yPoint.getX();
                    double d5 = yPoint.getY();
                    yCursor.next();
                    while (yCursor.ok()) {
                        double d6;
                        YPoint yPoint2 = (YPoint)yCursor.current();
                        double d7 = yPoint2.getX();
                        double d8 = (d2 - d7) * (d5 - (d6 = yPoint2.getY())) / (d3 - d6) + d7;
                        if (!(Math.abs(d8 - d4) < (double)this.i5)) {
                            vector.add(yPoint);
                            d2 = d4;
                            d3 = d5;
                        }
                        yPoint = yPoint2;
                        d4 = d7;
                        d5 = d6;
                        yCursor.next();
                    }
                }
                if (vector.size() < edgeLayout.pointCount()) {
                    layoutGraph.setPoints(edge, new YPointPath(vector));
                }
            }
            edgeCursor.next();
        }
    }

    private void a(LayoutGraph layoutGraph, NodeMap nodeMap, NodeMap nodeMap2) {
        EdgeCursor edgeCursor = layoutGraph.getEdgeList().edges();
        edgeCursor.toLast();
        while (edgeCursor.ok()) {
            Node node = edgeCursor.edge().source();
            Node node2 = edgeCursor.edge().target();
            int n = nodeMap.getInt(node2) - nodeMap.getInt(node);
            if (n > 1) {
                Node node3 = null;
                Edge edge = null;
                Node node4 = node;
                while (n > 1) {
                    node3 = layoutGraph.createNode();
                    layoutGraph.setSize(node3, 1.0, 1.0);
                    layoutGraph.setLocation(node3, YPoint.ORIGIN);
                    edge = layoutGraph.createEdge(node4, node3);
                    if (node4 == node) {
                        layoutGraph.setSourcePointRel(edge, layoutGraph.getSourcePointRel(edgeCursor.edge()));
                    }
                    nodeMap.setInt(node3, nodeMap.getInt(node4) + 1);
                    nodeMap2.set(node3, edgeCursor.edge());
                    node4 = node3;
                    --n;
                }
                edge = layoutGraph.createEdge(node3, node2);
                layoutGraph.setTargetPointRel(edge, layoutGraph.getTargetPointRel(edgeCursor.edge()));
                layoutGraph.hide(edgeCursor.edge());
            }
            edgeCursor.prev();
        }
    }
}

