/*
 * Decompiled with CFR 0.152.
 */
package twaver.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class TDropDownSelector
extends JComponent {
    private static Color F = new Color(51, 51, 51);
    private static Color E = new Color(184, 207, 229);
    private JComponent D = null;
    private JComponent B = null;
    private JButton A = null;
    private JPopupMenu C = null;

    public TDropDownSelector(JComponent renderer, JComponent selector) {
        this.D = renderer;
        this.B = selector;
        this.A = new JButton(new Icon(){

            public void paintIcon(Component c2, Graphics g2, int x, int y) {
                JComponent component = (JComponent)c2;
                int iconWidth = this.getIconWidth();
                g2.translate(x, y);
                g2.setColor(component.isEnabled() ? F : E);
                g2.drawLine(0, 0, iconWidth - 1, 0);
                g2.drawLine(1, 1, 1 + (iconWidth - 3), 1);
                g2.drawLine(2, 2, 2 + (iconWidth - 5), 2);
                g2.drawLine(3, 3, 3 + (iconWidth - 7), 3);
                g2.drawLine(4, 4, 4 + (iconWidth - 9), 4);
                g2.translate(-x, -y);
            }

            public int getIconWidth() {
                return 10;
            }

            public int getIconHeight() {
                return 5;
            }
        });
        Insets insets = this.A.getMargin();
        this.A.setMargin(new Insets(insets.top, 1, insets.bottom, 1));
        this.A.setFocusable(false);
        this.A.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TDropDownSelector.this.showSelector();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.D, "Center");
        this.add((Component)this.A, "East");
        this.C = new JPopupMenu();
        this.C.setLayout(new BorderLayout());
        this.C.add(selector);
    }

    public JPopupMenu getPopupMenu() {
        return this.C;
    }

    public JComponent getRenderer() {
        return this.D;
    }

    public void hideSelector() {
        if (this.C.isVisible()) {
            this.C.setVisible(false);
        }
    }

    public void showSelector() {
        if (!this.C.isVisible()) {
            this.C.setPreferredSize(this.getSelectorSize());
            this.C.show(this.D, 0, this.D.getSize().height);
        }
    }

    public Dimension getSelectorSize() {
        return new Dimension(this.getSize().width, this.C.getPreferredSize().height);
    }

    public JComponent getSelector() {
        return this.B;
    }

    public void updateUI() {
        super.updateUI();
        if (this.C != null) {
            SwingUtilities.updateComponentTreeUI(this.C);
        } else if (this.B != null) {
            SwingUtilities.updateComponentTreeUI(this.B);
        }
    }
}

