/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.ogc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import sun.misc.BASE64Encoder;
import twaver.gis.GeographyFeature;
import twaver.gis.ogc.WFSUtils;

public class WFSRequest {
    public static GeographyFeature[] requireFeatures(String serverPath, String requireContents) {
        return WFSRequest.requireFeatures(serverPath, requireContents, "UTF-8");
    }

    public static GeographyFeature[] requireFeatures(String serverPath, String requireContents, String resultCharset) {
        GeographyFeature[] resultFeatures = null;
        try {
            URL u = new URL(serverPath);
            HttpURLConnection hc = (HttpURLConnection)u.openConnection();
            hc.setDoOutput(true);
            String username = "wfst";
            String password = "wfst";
            String authHeader = "Basic " + new BASE64Encoder().encode((String.valueOf(username) + ":" + password).getBytes());
            hc.setRequestProperty("Content-Type", "text/xml");
            hc.connect();
            String s = requireContents;
            if (s.length() > 0) {
                OutputStream os = hc.getOutputStream();
                OutputStreamWriter wr = new OutputStreamWriter(os);
                wr.write(s);
                wr.flush();
            }
            InputStream in = hc.getInputStream();
            resultFeatures = WFSUtils.getFeaturesByGeoJSON(in, resultCharset);
        }
        catch (MalformedURLException ex) {
            System.err.println("Invalid URL\n" + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println("Invalid URL\n" + ex.getMessage());
        }
        return resultFeatures;
    }
}

