/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultGraphLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLayout;
import y.layout.NodeLayout;
import y.layout.planar.InitialPlanarSubgraph;
import y.layout.planar.OverlapGraphMIS;
import y.layout.planar.PlanarInformation;
import y.layout.planar.VertexOrder;
import y.util.D;
import y.util.EdgeMapAdapter;

public class GT
implements InitialPlanarSubgraph {
    protected EdgeListComparator edgeListComparator;
    protected MIS1Comparator mis1Comparator = new MIS1Comparator();
    protected MIS2Comparator mis2Comparator = new MIS2Comparator();
    protected PlanarInformation planar;
    protected Graph graph;
    protected boolean isValid = false;
    protected VertexOrder vertexOrder;
    protected EdgeMap weight;
    protected Edge outerFaceDeterminationEdge = null;
    protected Node outerFaceDeterminationNode = null;
    protected EdgeList hiddenEdges;
    protected Node globalSource = null;
    protected Node globalSink = null;
    private int p = 50;
    private boolean q;

    public GT() {
        this.edgeListComparator = new EdgeListComparator();
        this.vertexOrder = new VertexOrder();
        this.weight = new EdgeMapAdapter(){

            public int getInt(Object object) {
                return 1;
            }
        };
    }

    public void setAllowRandomization(boolean bl) {
        this.q = bl;
    }

    public boolean getAllowRandomization() {
        return this.q;
    }

    public void setIterations(int n) {
        this.p = n;
    }

    public int getIterations() {
        return this.p;
    }

    public EdgeList getHiddenEdges() {
        if (this.isValid) {
            return this.hiddenEdges;
        }
        throw new RuntimeException("Invalid Execution Order: call 'createPlanarization' first!");
    }

    public Node getSource() {
        if (this.isValid) {
            return this.globalSource;
        }
        throw new RuntimeException("Invalid Execution Order: call 'assignUpward' first!");
    }

    public Node getSink() {
        if (this.isValid) {
            return this.globalSink;
        }
        throw new RuntimeException("Invalid Execution Order: call 'assignUpward' first!");
    }

    public void createPlanarization(PlanarInformation planarInformation) {
        this.planar = planarInformation;
        this.graph = planarInformation.getGraph();
        if (this.graph.nodeCount() == 0 || this.graph.edgeCount() == 0) {
            this.hiddenEdges = new EdgeList();
            this.isValid = true;
            return;
        }
        this.vertexOrder.setGraph(this.graph);
        this.vertexOrder.setAllowRandomization(this.q);
        int[] nArray = new int[this.graph.N()];
        OverlapGraphMIS overlapGraphMIS = new OverlapGraphMIS(this.graph, this.weight);
        NodeList nodeList = this.calcOrdering(nArray, overlapGraphMIS);
        overlapGraphMIS.computeMaximumIndependentSets(nodeList, nArray);
        this.hiddenEdges = overlapGraphMIS.getHiddenEdges();
        NodeMap nodeMap = this.graph.createNodeMap();
        NodeMap nodeMap2 = this.graph.createNodeMap();
        this.initOrdering(nodeMap, nodeMap2, nodeList);
        EdgeList edgeList = new EdgeList(overlapGraphMIS.getMIS1().iterator());
        EdgeList edgeList2 = new EdgeList(overlapGraphMIS.getMIS2().iterator());
        this.createCircularEdgeOrder(edgeList, edgeList2, nodeMap, nodeMap2, nArray);
        this.graph.disposeNodeMap(nodeMap);
        this.graph.disposeNodeMap(nodeMap2);
        planarInformation.calcFaces();
        planarInformation.setOuterFace(planarInformation.faceOf(this.outerFaceDeterminationEdge));
        this.isValid = true;
        this.dispose();
    }

    protected NodeList calcOrdering(int[] nArray, OverlapGraphMIS overlapGraphMIS) {
        Object object;
        int n;
        NodeList nodeList = new NodeList();
        NodeList nodeList2 = null;
        if (this.q) {
            n = Integer.MAX_VALUE;
            int n2 = 0;
            while (n2 < this.p && n > 0) {
                YCursor yCursor;
                this.vertexOrder.computeVertexOrder(nodeList);
                int n3 = 1;
                object = nodeList.nodes();
                while (object.ok()) {
                    nArray[object.node().index()] = n3++;
                    object.next();
                }
                overlapGraphMIS.computeMaximumIndependentSets(nodeList, nArray);
                this.hiddenEdges = overlapGraphMIS.getHiddenEdges();
                if (n > this.hiddenEdges.size()) {
                    n = this.hiddenEdges.size();
                    nodeList2 = new NodeList();
                    yCursor = nodeList.nodes();
                    while (yCursor.ok()) {
                        nodeList2.addLast(yCursor.node());
                        yCursor.next();
                    }
                }
                yCursor = this.hiddenEdges.edges();
                while (yCursor.ok()) {
                    this.graph.unhide(yCursor.edge());
                    yCursor.next();
                }
                ++n2;
            }
            nodeList = nodeList2;
        } else {
            this.vertexOrder.computeVertexOrder(nodeList);
            nodeList2 = nodeList;
        }
        n = 1;
        NodeCursor nodeCursor = nodeList2.nodes();
        while (nodeCursor.ok()) {
            nArray[nodeCursor.node().index()] = n++;
            nodeCursor.next();
        }
        NodeCursor nodeCursor2 = nodeList.nodes();
        nodeCursor2.toFirst();
        this.globalSource = nodeCursor2.node();
        nodeCursor2.toLast();
        this.globalSink = nodeCursor2.node();
        nodeCursor2 = nodeList.nodes();
        while (nodeCursor2.ok()) {
            object = nodeCursor2.node();
            if (((Node)object).degree() != 0) {
                this.outerFaceDeterminationNode = object;
                break;
            }
            nodeCursor2.next();
        }
        return nodeList;
    }

    protected void initOrdering(NodeMap nodeMap, NodeMap nodeMap2, NodeList nodeList) {
        Object object;
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            object = nodeCursor.node();
            nodeMap.set(object, null);
            nodeMap2.set(object, null);
            nodeCursor.next();
        }
        object = nodeList.nodes();
        while (object.ok()) {
            Node node = object.node();
            ListCell listCell = nodeList.findCell(node);
            EdgeCursor edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                if (node != (Node)nodeList.first() && edge.opposite(node) == (Node)nodeList.predCell(listCell).getInfo()) {
                    nodeMap.set(node, edge);
                } else if (node != (Node)nodeList.last() && edge.opposite(node) == (Node)nodeList.succCell(listCell).getInfo()) {
                    nodeMap2.set(node, edge);
                }
                edgeCursor.next();
            }
            object.next();
        }
    }

    protected void calcMISIncidents(EdgeList edgeList, NodeMap nodeMap) {
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            EdgeList edgeList2;
            Edge edge = edgeCursor.edge();
            Node node = edge.source();
            Node node2 = edge.target();
            if (nodeMap.get(node) == null) {
                edgeList2 = new EdgeList();
                edgeList2.add(edge);
                nodeMap.set(node, edgeList2);
            } else {
                ((EdgeList)nodeMap.get(node)).add(edge);
            }
            if (nodeMap.get(node2) == null) {
                edgeList2 = new EdgeList();
                edgeList2.add(edge);
                nodeMap.set(node2, edgeList2);
            } else {
                ((EdgeList)nodeMap.get(node2)).add(edge);
            }
            edgeCursor.next();
        }
    }

    protected void createCircularEdgeOrder(EdgeList edgeList, EdgeList edgeList2, NodeMap nodeMap, NodeMap nodeMap2, int[] nArray) {
        NodeMap nodeMap3 = this.graph.createNodeMap();
        NodeMap nodeMap4 = this.graph.createNodeMap();
        this.calcMISIncidents(edgeList, nodeMap3);
        this.calcMISIncidents(edgeList2, nodeMap4);
        this.createReverseEdges();
        this.mis1Comparator.setOrderNumbers(nArray);
        this.mis2Comparator.setOrderNumbers(nArray);
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            EdgeCursor edgeCursor;
            Edge edge;
            EdgeList edgeList3;
            Node node = nodeCursor.node();
            EdgeList edgeList4 = new EdgeList();
            EdgeList edgeList5 = (EdgeList)nodeMap3.get(node);
            if (edgeList5 != null) {
                this.mis1Comparator.setCurrentNode(node);
                edgeList5.sort(this.mis1Comparator);
            }
            if ((edgeList3 = (EdgeList)nodeMap4.get(node)) != null) {
                this.mis2Comparator.setCurrentNode(node);
                edgeList3.sort(this.mis2Comparator);
            }
            if ((edge = (Edge)nodeMap.get(node)) != null) {
                if (edge.source() == node) {
                    edgeList4.add(edge);
                } else {
                    edgeList4.add(this.planar.getReverse(edge));
                }
            }
            if (edgeList5 != null) {
                edgeCursor = edgeList5.edges();
                while (edgeCursor.ok()) {
                    edge = edgeCursor.edge();
                    if (edge.source() == node) {
                        edgeList4.add(edge);
                    } else {
                        edgeList4.add(this.planar.getReverse(edge));
                    }
                    if (node == this.outerFaceDeterminationNode && this.outerFaceDeterminationEdge == null) {
                        this.outerFaceDeterminationEdge = (Edge)edgeList4.last();
                    }
                    edgeCursor.next();
                }
            }
            if ((edge = (Edge)nodeMap2.get(node)) != null) {
                if (edge.source() == node) {
                    edgeList4.add(edge);
                } else {
                    edgeList4.add(this.planar.getReverse(edge));
                }
                if (node == this.outerFaceDeterminationNode && this.outerFaceDeterminationEdge == null) {
                    this.outerFaceDeterminationEdge = (Edge)edgeList4.last();
                }
            }
            if (edgeList3 != null) {
                edgeCursor = edgeList3.edges();
                while (edgeCursor.ok()) {
                    edge = edgeCursor.edge();
                    if (edge.source() == node) {
                        edgeList4.add(edge);
                    } else {
                        edgeList4.add(this.planar.getReverse(edge));
                    }
                    if (node == this.outerFaceDeterminationNode && this.outerFaceDeterminationEdge == null) {
                        this.outerFaceDeterminationEdge = (Edge)edgeList4.last();
                    }
                    edgeCursor.next();
                }
            }
            this.edgeListComparator.setEdgeList(edgeList4);
            node.sortOutEdges(this.edgeListComparator);
            nodeCursor.next();
        }
        this.graph.disposeNodeMap(nodeMap3);
        this.graph.disposeNodeMap(nodeMap4);
    }

    protected void createReverseEdges() {
        EdgeList edgeList = new EdgeList(this.graph.edges());
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            this.planar.createReverse(edgeCursor.edge());
            edgeCursor.next();
        }
    }

    public void dispose() {
    }

    protected void showVertexOrder(int[] nArray) {
        D.bug(0, "VERTEX ORDER");
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            D.bug(0, "Node: " + node + " index: " + nArray[node.index()]);
            nodeCursor.next();
        }
    }

    protected void showEdgePartitionResult(ArrayList arrayList, ArrayList arrayList2) {
        D.bug(0, "EDGE PARTITION RESULT");
        D.bug(0, "SET ONE");
        int n = 0;
        while (n < arrayList.size()) {
            D.bug(0, " edge: " + arrayList.get(n));
            ++n;
        }
        D.bug(0, "SET TWO");
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            D.bug(0, " edge: " + arrayList2.get(n2));
            ++n2;
        }
        D.bug(0, "HIDDEN EDGES");
        EdgeCursor edgeCursor = this.hiddenEdges.edges();
        while (edgeCursor.ok()) {
            D.bug(0, " edge: " + edgeCursor.edge());
            edgeCursor.next();
        }
    }

    protected void showGraphicDebug(EdgeList edgeList, EdgeList edgeList2, int[] nArray) {
        Object object;
        Object object2;
        DefaultGraphLayout defaultGraphLayout = new DefaultGraphLayout();
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            object2 = nodeCursor.node();
            object = new DefaultNodeLayout();
            ((DefaultNodeLayout)object).setSize(20.0, 20.0);
            double d2 = nArray[((Node)object2).index()] * 40;
            ((DefaultNodeLayout)object).setLocation(d2, 0.0);
            defaultGraphLayout.setNodeLayout(object2, (NodeLayout)object);
            nodeCursor.next();
        }
        object2 = edgeList.edges();
        while (object2.ok()) {
            object = new DefaultEdgeLayout();
            int n = nArray[object2.edge().target().index()] - nArray[object2.edge().source().index()];
            ((DefaultEdgeLayout)object).addPoint(nArray[object2.edge().index()] * 40 + n * 20 + 10, -n * 20);
            defaultGraphLayout.setEdgeLayout(object2.edge(), (EdgeLayout)object);
            object2.next();
        }
        object2 = edgeList2.edges();
        while (object2.ok()) {
            object = new DefaultEdgeLayout();
            int n = nArray[object2.edge().target().index()] - nArray[object2.edge().source().index()];
            ((DefaultEdgeLayout)object).addPoint(nArray[object2.edge().source().index()] * 40 + n * 20 + 10, n * 20);
            defaultGraphLayout.setEdgeLayout(object2.edge(), (EdgeLayout)object);
            object2.next();
        }
        try {
            object = Class.forName("yed.app.LayoutGraphViewer");
            Class[] classArray = new Class[]{Class.forName("y.base.Graph"), Class.forName("y.layout.GraphLayout")};
            Method method = ((Class)object).getMethod("createFrame", classArray);
            Object[] objectArray = new Object[]{this.graph, defaultGraphLayout};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    protected void showIncidentEdges(NodeMap nodeMap, NodeMap nodeMap2, EdgeMap edgeMap, EdgeMap edgeMap2) {
        D.bug(0, "INCIDENT EDGES");
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            EdgeCursor edgeCursor;
            Node node = nodeCursor.node();
            D.bug(0, " Node: " + node + " ->: " + (Edge)edgeMap2.get(node));
            D.bug(0, " Node: " + node + " <-: " + (Edge)edgeMap.get(node));
            EdgeList edgeList = (EdgeList)nodeMap.get(node);
            if (edgeList != null) {
                edgeCursor = edgeList.edges();
                while (edgeCursor.ok()) {
                    D.bug(0, "  MIS1: Node: " + node + " Edge: " + edgeCursor.edge());
                    edgeCursor.next();
                }
            }
            if ((edgeList = (EdgeList)nodeMap2.get(node)) != null) {
                edgeCursor = edgeList.edges();
                while (edgeCursor.ok()) {
                    D.bug(0, "  MIS2: Node: " + node + " Edge: " + edgeCursor.edge());
                    edgeCursor.next();
                }
            }
            nodeCursor.next();
        }
    }

    public static class EdgeListComparator
    implements Comparator {
        EdgeList a;

        public void setEdgeList(EdgeList edgeList) {
            this.a = edgeList;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            return this.a.indexOf(edge) - this.a.indexOf(edge2);
        }
    }

    public static class MIS2Comparator
    implements Comparator {
        Node b;
        int[] a;

        public void setCurrentNode(Node node) {
            this.b = node;
        }

        public void setOrderNumbers(int[] nArray) {
            this.a = nArray;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            int n = this.a[this.b.index()];
            int n2 = this.a[edge.opposite(this.b).index()];
            int n3 = n2 - n;
            n2 = this.a[edge2.opposite(this.b).index()];
            int n4 = n2 - n;
            if (n3 > 0 && n4 > 0 || n3 < 0 && n4 < 0) {
                if (n3 > n4) {
                    return 1;
                }
                if (n3 < n4) {
                    return -1;
                }
                return 0;
            }
            if (n3 > n4) {
                return -1;
            }
            if (n3 < n4) {
                return 1;
            }
            return 0;
        }
    }

    public static class MIS1Comparator
    implements Comparator {
        Node b;
        int[] a;

        public void setOrderNumbers(int[] nArray) {
            this.a = nArray;
        }

        public void setCurrentNode(Node node) {
            this.b = node;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            int n = this.a[this.b.index()];
            int n2 = this.a[edge.opposite(this.b).index()];
            int n3 = n2 - n;
            n2 = this.a[edge2.opposite(this.b).index()];
            int n4 = n2 - n;
            if (n3 > 0 && n4 > 0 || n3 < 0 && n4 < 0) {
                if (n3 > n4) {
                    return -1;
                }
                if (n3 < n4) {
                    return 1;
                }
                return 0;
            }
            if (n3 > n4) {
                return 1;
            }
            if (n3 < n4) {
                return -1;
            }
            return 0;
        }
    }
}

