/*
 * Decompiled with CFR 0.152.
 */
package twaver.web;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import twaver.AlarmSeverity;
import twaver.Element;
import twaver.Group;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.E;
import twaver.base.A.E.M;
import twaver.base.A.E.O;
import twaver.base.A.E.W;
import twaver.base.A.H.A;
import twaver.base.A.H.C;
import twaver.base.A.H.F;
import twaver.base.A.H.H;
import twaver.base.A.H.I;
import twaver.base.A.I.B;
import twaver.web.svg.network.SVGContext;

public class WebUtil {
    public static final String ID_PREFIX_IMAGE = TUIManager.getString("web.id.prefix.image");
    public static final String ID_PREFIX_DEFINITION = TUIManager.getString("web.id.prefix.definition");
    public static final String ID_PREFIX_GRADIENT = TUIManager.getString("web.id.prefix.gradient");
    public static final String ID_PREFIX_TEXTURE = TUIManager.getString("web.id.prefix.texture");
    public static final String IMAGE_FORMAT = TUIManager.getString("web.image.format");
    private static long D = 0L;
    private static SimpleDateFormat E = new SimpleDateFormat("M,d,yyyy hh:mm:ss");
    private static final Map H = new HashMap();
    private static final Map F = new HashMap();
    private static final Map C = new HashMap();
    private static final Map B = new HashMap();
    private static final Map I = new HashMap();
    private static boolean G = true;
    private static final Map A = new HashMap();

    public static synchronized String getNextCustomDefinitionID() {
        return ID_PREFIX_DEFINITION + D++;
    }

    public static Map getGradientSVGCache() {
        return B;
    }

    public static Map getTexturePatternSVGCache() {
        return F;
    }

    public static boolean isCacheImageBase64() {
        return G;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCacheImageBase64(boolean cache64) {
        Class clazz = SVGContext.class;
        synchronized (clazz) {
            G = cache64;
            if (!G) {
                A.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageBase64(String id, C key) {
        Class clazz = SVGContext.class;
        synchronized (clazz) {
            String data = (String)A.get(id);
            if (data != null) {
                return data;
            }
            ImageIcon image = TWaverUtil.getImageIcon(key.B, key.A);
            byte[] bs = O.A(image.getImage(), IMAGE_FORMAT);
            data = TWaverUtil.encodeBase64Buffer(bs);
            if (G) {
                A.put(id, data);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeImageBase64Cache(String id) {
        Class clazz = SVGContext.class;
        synchronized (clazz) {
            A.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearImageBase64Cache() {
        Class clazz = SVGContext.class;
        synchronized (clazz) {
            A.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageID(C key) {
        String id = (String)I.get(key);
        if (id == null) {
            Class clazz = SVGContext.class;
            synchronized (clazz) {
                id = (String)I.get(key);
                if (id != null) {
                    return id;
                }
                id = ID_PREFIX_IMAGE + (I.size() + 1);
                I.put(key, id);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeImageID(C key) {
        Class clazz = SVGContext.class;
        synchronized (clazz) {
            I.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getImageIDs(String url) {
        ArrayList<String> list = new ArrayList<String>();
        if (url != null) {
            Class clazz = SVGContext.class;
            synchronized (clazz) {
                Iterator it = I.keySet().iterator();
                while (it.hasNext()) {
                    C key = (C)it.next();
                    if (!url.equals(key.B)) continue;
                    list.add(WebUtil.getImageID(key));
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGradientID(int type, Color gradientColor, Color fillColor) {
        twaver.base.A.H.B key = new twaver.base.A.H.B(type, gradientColor, fillColor);
        String id = (String)C.get(key);
        if (id == null) {
            Class clazz = SVGContext.class;
            synchronized (clazz) {
                id = (String)C.get(key);
                if (id != null) {
                    return id;
                }
                id = ID_PREFIX_GRADIENT + (C.size() + 1);
                String svg = twaver.base.A.H.H.A(id, type, gradientColor, fillColor);
                C.put(key, id);
                B.put(id, svg);
            }
        }
        return id;
    }

    public static String getGradientID(SVGContext context, int type, Color gradientColor, Color fillColor) {
        String id = WebUtil.getGradientID(type, gradientColor, fillColor);
        if (id != null) {
            context.registerGradientID(id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextureID(String type, Color color) {
        A key = new A(type, color);
        String id = (String)H.get(key);
        if (id == null) {
            Class clazz = SVGContext.class;
            synchronized (clazz) {
                id = (String)H.get(key);
                if (id != null) {
                    return id;
                }
                id = ID_PREFIX_TEXTURE + (H.size() + 1);
                String svg = twaver.base.A.H.F.A(id, type, color);
                H.put(key, id);
                F.put(id, svg);
            }
        }
        return id;
    }

    public static void sendToTop(B network, Element element) {
        if (element == null) {
            return;
        }
        Element parent = element;
        while (network.isVisible(parent.getParent())) {
            parent = parent.getParent();
        }
        if (parent != element) {
            twaver.base.A.E.E.A(network.getDataBox(), parent);
        }
        twaver.base.A.E.E.A(network.getDataBox(), element);
        WebUtil.A(network, element);
    }

    private static void A(B network, Element element) {
        if (W.C(element)) {
            Iterator it = network.getDataBox().iterator(Group.class);
            while (it.hasNext()) {
                Group group = (Group)it.next();
                if (group == element || !network.isVisible(group) || group.isParentOf(element) || group.isDescendantOf(element) || !W.C(group) || !twaver.base.A.E.E.A((Group)element)) continue;
                twaver.base.A.E.E.A(network.getDataBox(), group);
            }
        }
    }

    public static void appendSVGImage(SVGContext context, StringBuffer sb, String customerStr, String url, Color color, int x, int y) {
        twaver.base.A.H.I.A(context, sb, customerStr, url, color, x, y);
    }

    public static void appendSVGWebImage(StringBuffer sb, int x, int y, int width, int height, String url) {
        sb.append("<image x='" + x + "' y='" + y + "' width='" + width + "' height='" + height + "' xlink:href='" + url + "'/>");
    }

    public static String getAttributesFromMap(Map map) {
        Set keySet = map.keySet();
        if (keySet.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            result.append(key).append("='").append(value).append("'").append(" ");
        }
        return result.toString();
    }

    public static String javaToJSON(Object javaObject) {
        String result;
        if (javaObject == null) {
            return "";
        }
        if (javaObject instanceof Boolean || javaObject instanceof Number) {
            return javaObject.toString();
        }
        if (javaObject instanceof Date) {
            return E.format((Date)javaObject);
        }
        if (javaObject instanceof Color) {
            result = M.A((Color)javaObject, false);
        } else if (javaObject instanceof AlarmSeverity) {
            AlarmSeverity severity = (AlarmSeverity)javaObject;
            result = severity.getDisplayName();
        } else {
            result = javaObject.toString();
        }
        result = result.replaceAll("\\\\", "\\\\").replaceAll("\\'", "\\\\'");
        return result;
    }

    public static String htmlEscape(String text) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\t') {
                WebUtil.A(9, result);
            } else if (character == '!') {
                WebUtil.A(33, result);
            } else if (character == '#') {
                WebUtil.A(35, result);
            } else if (character == '$') {
                WebUtil.A(36, result);
            } else if (character == '%') {
                WebUtil.A(37, result);
            } else if (character == '\'') {
                WebUtil.A(39, result);
            } else if (character == '(') {
                WebUtil.A(40, result);
            } else if (character == ')') {
                WebUtil.A(41, result);
            } else if (character == '*') {
                WebUtil.A(42, result);
            } else if (character == '+') {
                WebUtil.A(43, result);
            } else if (character == ',') {
                WebUtil.A(44, result);
            } else if (character == '-') {
                WebUtil.A(45, result);
            } else if (character == '.') {
                WebUtil.A(46, result);
            } else if (character == '/') {
                WebUtil.A(47, result);
            } else if (character == ':') {
                WebUtil.A(58, result);
            } else if (character == ';') {
                WebUtil.A(59, result);
            } else if (character == '=') {
                WebUtil.A(61, result);
            } else if (character == '?') {
                WebUtil.A(63, result);
            } else if (character == '@') {
                WebUtil.A(64, result);
            } else if (character == '[') {
                WebUtil.A(91, result);
            } else if (character == '\\') {
                WebUtil.A(92, result);
            } else if (character == ']') {
                WebUtil.A(93, result);
            } else if (character == '^') {
                WebUtil.A(94, result);
            } else if (character == '_') {
                WebUtil.A(95, result);
            } else if (character == '`') {
                WebUtil.A(96, result);
            } else if (character == '{') {
                WebUtil.A(123, result);
            } else if (character == '|') {
                WebUtil.A(124, result);
            } else if (character == '}') {
                WebUtil.A(125, result);
            } else if (character == '~') {
                WebUtil.A(126, result);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String xmlEscape(String text) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String xmlUnescape(String text) {
        return text.replaceAll("\\&lt\\;", "<").replaceAll("\\&gt\\;", ">").replaceAll("\\&quot\\;", "\"").replaceAll("\\&\\#039\\;", "'").replaceAll("\\&amp\\;", "&");
    }

    private static void A(int aIdx, StringBuffer aBuilder) {
        String padding = "";
        if (aIdx <= 9) {
            padding = "00";
        } else if (aIdx <= 99) {
            padding = "0";
        }
        String number = padding + aIdx;
        aBuilder.append("&#" + number + ";");
    }

    public static StringBuffer appendShapeDirect(SVGContext context, StringBuffer sb, Shape shape, Object fillObject, Object outlineObject, Object stroke, float fillOpacity) {
        return twaver.base.A.H.I.A(context, sb, shape, fillObject, outlineObject, stroke, fillOpacity, 0.0, null);
    }

    public static StringBuffer getRectStringBuffer(SVGContext context, String id, Rectangle rect, Object fillColor, Object outlineColor, Object stroke, float alpha) {
        return twaver.base.A.H.I.A(context, id, rect, fillColor, outlineColor, stroke, alpha, 0.0, null);
    }

    public static void appendCurrentSubNetworkIDtoBackGround(SVGContext context, StringBuffer sbBackground) {
        twaver.base.A.H.I.C(context, sbBackground);
    }

    public static void appendText(SVGContext context, StringBuffer result, String text, Color color, Font font, int x, int y, int orientation, int position) {
        twaver.base.A.H.I.A(context, result, text, color, font, x, y, orientation, position);
    }

    public static String toText(SVGContext context, String text, boolean enableTextInteract, Color color, Object font, Point location, boolean underline, String rotate) {
        return twaver.base.A.H.I.A(context, text, enableTextInteract, color, font, location, underline, rotate);
    }
}

