/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;
import twaver.ShapeNode;
import twaver.TSubNetwork;
import twaver.network.background.Background;
import twaver.network.background.ColorBackground;
import twaver.network.background.ImageBackground;
import twaver.network.background.TextureBackground;

public class ShapeSubNetwork
extends ShapeNode
implements TSubNetwork {
    private Background Q = null;
    private String S = null;
    private boolean R = false;
    private Point P = null;

    public ShapeSubNetwork() {
        this.A((Shape)null);
    }

    public ShapeSubNetwork(Object id) {
        super(id);
        this.A((Shape)null);
    }

    public ShapeSubNetwork(Shape baseShape) {
        this.A(baseShape);
    }

    public ShapeSubNetwork(Object id, Shape baseShape) {
        super(id);
        this.A(baseShape);
    }

    private void A(Shape baseShape) {
        this.setShapeNodeType(1);
        this.getClientProperties().put("texture.factory", "stipple.middle");
        this.getClientProperties().put("custom.draw.gradient", Boolean.FALSE);
        this.getClientProperties().put("custom.draw.fill", Boolean.TRUE);
        if (baseShape == null) {
            ArrayList<Point> ps = new ArrayList<Point>();
            ps.add(new Point(125, 75));
            ps.add(new Point(100, 118));
            ps.add(new Point(51, 118));
            ps.add(new Point(25, 75));
            ps.add(new Point(50, 32));
            ps.add(new Point(100, 32));
            this.setPoints(ps);
        } else {
            this.setBaseShape(baseShape);
        }
    }

    public Point getViewPoint() {
        return this.P;
    }

    public void setViewPoint(Point viewPoint) {
        Point oldValue = this.P;
        this.P = viewPoint;
        this.firePropertyChange("viewPoint", oldValue, viewPoint);
    }

    public Background getBackground() {
        return this.Q;
    }

    public void setBackground(Background background) {
        Background oldvalue = this.Q;
        this.Q = background;
        this.firePropertyChange("background", oldvalue, this.Q);
    }

    public void setTextureBackground(String imageURL) {
        this.setBackground(new TextureBackground(imageURL));
    }

    public void setImageBackground(String imageURL) {
        this.setBackground(new ImageBackground(imageURL));
    }

    public void setColorBackground(Color color) {
        this.setBackground(new ColorBackground(color));
    }

    public String getDataSource() {
        return this.S;
    }

    public void setDataSource(String dataSource) {
        String oldValue = this.S;
        this.S = dataSource;
        this.firePropertyChange("dataSource", oldValue, dataSource);
    }

    public boolean isDataLoaded() {
        return this.R;
    }

    public void setDataLoaded(boolean dataLoaded) {
        boolean oldValue = this.R;
        this.R = dataLoaded;
        this.firePropertyChange("dataLoaded", oldValue, dataLoaded);
    }

    public String getSVGUIClassID() {
        return "ShapeSubNetworkSVGUI";
    }
}

