/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Dimension;
import java.awt.Rectangle;
import twaver.Node;
import twaver.Resizable;
import twaver.base.A.E.W;

public class ResizableNode
extends Node
implements Resizable {
    protected Dimension size = null;

    public ResizableNode() {
    }

    public ResizableNode(Object id) {
        super(id);
    }

    public void setSize(int width, int height) {
        this.setSize(new Dimension(width, height));
    }

    public void setSize(Dimension size) {
        Dimension oldSize = this.size;
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        this.size = size;
        int width = this.getWidth();
        int height = this.getHeight();
        this.firePropertyChange("size", oldSize, size);
        this.firePropertyChange("width", oldWidth, width);
        this.firePropertyChange("height", oldHeight, height);
    }

    public Dimension getSize() {
        if (this.size == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        return this.size;
    }

    public void setWidthSize(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeightSize(int height) {
        this.setSize(this.getWidth(), height);
    }

    public int getWidth() {
        if (this.size == null) {
            return W.H(this);
        }
        return this.size.width;
    }

    public int getHeight() {
        if (this.size == null) {
            return W.A(this);
        }
        return this.size.height;
    }

    public Rectangle getBounds() {
        if (this.size == null) {
            return new Rectangle((int)this.xLocation, (int)this.yLocation, this.getWidth(), this.getHeight());
        }
        return new Rectangle((int)this.xLocation, (int)this.yLocation, this.size.width, this.size.height);
    }

    public void setImage(String url) {
        super.setImage(url);
        this.resetDefaultSize();
    }

    public void resetDefaultSize() {
        this.setSize(W.H(this), W.A(this));
    }

    public String getUIClassID() {
        return "ResizableNodeUI";
    }
}

