/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TGraphManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import twaver.Element;
import twaver.MouseActionEvent;
import twaver.network.ui.Attachment;
import twaver.network.ui.ElementUI;
import twaver.network.ui.LabelAttachment;

public class TGraphMouseAdapter
implements ActionListener {
    private TGraph graph;

    public TGraphMouseAdapter(TGraph graph) {
        this.graph = graph;
        this.graph.addElementClickedActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point point;
        MouseActionEvent mouseActionEvent = (MouseActionEvent)e;
        MouseEvent mouseEvent = mouseActionEvent.getMouseEvent();
        Element element = (Element)e.getSource();
        ElementUI elementUI = this.graph.getElementUI(element);
        Attachment attachment = elementUI.getAttachmentAt(point = this.graph.getLogicalPoint(mouseEvent.getPoint()));
        if (attachment instanceof LabelAttachment) {
            return;
        }
        if (mouseEvent.getClickCount() == 1) {
            this.doClicked(mouseActionEvent);
        } else if (mouseEvent.getClickCount() > 1) {
            this.doDoubleClicked(mouseActionEvent);
        }
    }

    public TGraph getGraph() {
        return this.graph;
    }

    public void doClicked(MouseActionEvent mouseActionEvent) {
    }

    public void doDoubleClicked(MouseActionEvent mouseActionEvent) {
        TGraphManager.hideChildren(this.graph);
    }
}

