/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import twaver.Element;
import twaver.Generator;
import twaver.Group;
import twaver.Link;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.O;
import twaver.base.A.E.o;
import twaver.base.A.H.C;
import twaver.base.A.H.F;
import twaver.web.WebUtil;
import twaver.web.svg.network.SVGStruct;

public class SVGContext
implements Serializable {
    private static int H = twaver.base.A.E.o.B(1000);
    private boolean r = TUIManager.getBoolean("web.svg.use.base64");
    private boolean M = TUIManager.getBoolean("web.image.cache");
    private boolean d = TUIManager.getBoolean("web.svg.show.alarm.on.top");
    private boolean Y = TUIManager.getBoolean("web.svg.use.cdata");
    private boolean i = TUIManager.getBoolean("web.svg.text.escape");
    private String e = TUIManager.getString("web.image.file.path");
    private String R = TUIManager.getString("web.physical.path");
    private String L = TUIManager.getString("web.image.url.prefix");
    private Color s = TUIManager.getColor("web.default.background.color");
    private String n = TUIManager.getString("web.svg.xmlns");
    private String N = TUIManager.getString("web.svg.font");
    private int Q = 12;
    private Dimension h = TUIManager.getDimension("web.min.background.size");
    private Generator I = null;
    private transient Generator t;
    private transient Generator O;
    private String j = "defs_node_id";
    private String l = "out_g_node_id";
    private boolean Z = true;
    private boolean f = true;
    private boolean W = true;
    private boolean B = true;
    private boolean g = true;
    private boolean D = true;
    private boolean X = true;
    private boolean J = true;
    private double U = 0.0;
    private double S = 0.0;
    private String P = null;
    private Object c = null;
    private Map p = new HashMap();
    private Map C = new HashMap();
    private Map q = new HashMap();
    private Map a = new HashMap();
    private Map T = new HashMap();
    private Map b = new HashMap();
    private Map K = new LinkedHashMap();
    private Map E = new LinkedHashMap();
    private Set m = new HashSet();
    private Set A = new HashSet();
    private Set _ = new HashSet();
    private List G = new LinkedList();
    private Map o = new HashMap();
    private Map k = new HashMap();
    private Map V = new HashMap();
    private NumberFormat F = NumberFormat.getInstance();

    public SVGContext() {
        this.F.setMaximumFractionDigits(10);
        this.F.setMinimumFractionDigits(0);
        this.F.setGroupingUsed(false);
        this.K.put("font-family", this.N);
        this.K.put("font-size", TWaverUtil.valueOf(this.Q));
        this.K.put("stroke-width", "1");
        this.K.put("stroke-miterlimit", "10");
        this.K.put("stroke-linejoin", "round");
        this.K.put("stroke-linecap", "butt");
        this.K.put("stroke-dashoffset", "0");
        this.K.put("image-rendering", "optimizeSpeed");
        this.initTransientProperty();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientProperty();
    }

    protected void initTransientProperty() {
        this.t = TUIManager.getElementHeadCustomAttributeGenerator();
        this.O = TUIManager.getElementBodyCustomAttributeGenerator();
    }

    void A() {
        this.p.clear();
        this.C.clear();
        this.q.clear();
        this.a.clear();
        this.T.clear();
        this.b.clear();
        this.E.clear();
        this.m.clear();
        this.A.clear();
        this._.clear();
        this.G.clear();
        this.o.clear();
        this.k.clear();
    }

    public void registerAlarmAttachment(Element element, String alarmAttachmentSVG) {
        this.o.put(element, alarmAttachmentSVG);
    }

    protected String getAlarmAttachmentSVG(Element element) {
        return (String)this.o.get(element);
    }

    public void registerMessageAttachment(Element element, String messageAttachmentSVG) {
        this.k.put(element, messageAttachmentSVG);
    }

    protected String getMessageAttachmentSVG(Element element) {
        return (String)this.k.get(element);
    }

    public void registerBounds(Element element, Rectangle bounds) {
        if (bounds == null) {
            this.p.remove(element);
        } else {
            this.p.put(element, bounds.clone());
        }
    }

    public Rectangle getBounds(Element element) {
        Rectangle bounds = (Rectangle)this.p.get(element);
        if (bounds == null) {
            return element.getBounds();
        }
        return (Rectangle)bounds.clone();
    }

    public void registerGroupShape(Group group, Shape shape) {
        this.T.put(group, shape);
    }

    public Shape getGroupShape(Group group) {
        Shape shape = (Shape)this.T.get(group);
        if (shape == null) {
            return group.getBounds();
        }
        return shape;
    }

    public void registerFromPoint(Link link, Point point) {
        if (point == null) {
            this.q.remove(link);
        } else {
            this.q.put(link, point.clone());
        }
    }

    public void registerToPoint(Link link, Point point) {
        if (point == null) {
            this.a.remove(link);
        } else {
            this.a.put(link, point.clone());
        }
    }

    public Point getFromPoint(Link link) {
        Point point = (Point)this.q.get(link);
        if (point == null) {
            Rectangle bounds = link.getFromAgent().getBounds();
            return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        }
        return (Point)point.clone();
    }

    public Point getToPoint(Link link) {
        Point point = (Point)this.a.get(link);
        if (point == null) {
            Rectangle bounds = link.getToAgent().getBounds();
            return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        }
        return (Point)point.clone();
    }

    public void registerLinkPath(Link link, GeneralPath path) {
        this.C.put(link, path);
    }

    public GeneralPath getLinkPath(Link link) {
        return (GeneralPath)this.C.get(link);
    }

    public void registerSVGStruct(Element element, SVGStruct svgStruct) {
        this.b.put(element, svgStruct);
    }

    public SVGStruct getSVGStruct(Element element) {
        return (SVGStruct)this.b.get(element);
    }

    public void registerDefaultValue(String attribute, String value) {
        if (value == null) {
            this.K.remove(attribute);
        } else {
            this.K.put(attribute, value);
        }
    }

    public StringBuffer appendValue(StringBuffer sb, String attribute, int value) {
        return this.appendValue(sb, attribute, String.valueOf(value));
    }

    public StringBuffer appendValue(StringBuffer sb, String attribute, double value) {
        return this.appendValue(sb, attribute, this.format(value));
    }

    public StringBuffer appendValue(StringBuffer sb, String attribute, String value, boolean withNull) {
        if (attribute == null) {
            return sb;
        }
        if (value != null) {
            Object obj = this.K.get(attribute);
            if (value.equals(obj)) {
                return sb;
            }
            return sb.append(" ").append(attribute).append("='").append(value).append("'");
        }
        if (withNull) {
            return sb.append(" ").append(attribute).append("='").append(value).append("'");
        }
        return sb;
    }

    public void appendShapePoints(StringBuffer head, List points, int size) {
        if (this.isShapeEditable() && points != null && points.size() >= size) {
            StringBuffer pointsString = new StringBuffer("'");
            Iterator it = points.iterator();
            while (it.hasNext()) {
                Point2D point = (Point2D)it.next();
                pointsString.append((int)point.getX()).append(" ").append((int)point.getY()).append(",");
            }
            pointsString.deleteCharAt(pointsString.length() - 1);
            pointsString.append("'");
            head.append(" shapePoints=" + pointsString);
        }
    }

    public StringBuffer appendValue(StringBuffer sb, String attribute, String value) {
        return this.appendValue(sb, attribute, value, true);
    }

    public String getDefaultValue(String attribute) {
        return (String)this.K.get(attribute);
    }

    public void registerCustomDefinition(String definitionContext) {
        this.G.add(definitionContext);
    }

    public void registerGradientID(String gradientID) {
        this.m.add(gradientID);
    }

    public void registerTexturePatternID(String textureType, String texturePatternID) {
        this.A.add(textureType);
        this._.add(texturePatternID);
    }

    public String getImageID(String url, Color color) {
        C key = new C(url, color);
        String id = WebUtil.getImageID(key);
        this.E.put(key, id);
        return id;
    }

    void F(StringBuffer sb) {
        Iterator it = this.K.keySet().iterator();
        while (it.hasNext()) {
            String attribute = (String)it.next();
            Object value = this.K.get(attribute);
            if (value == null) continue;
            sb.append(" ").append(attribute).append("='").append(value.toString()).append("'");
        }
    }

    void B(StringBuffer sb) {
        if (this.P != null) {
            sb.append("<desc>").append(this.P).append("</desc>");
        }
    }

    void G(StringBuffer sb) {
        if (this.G.isEmpty()) {
            return;
        }
        Iterator it = this.G.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
    }

    public void appendGradientDefinitionSVG(StringBuffer sb) {
        if (this.m.isEmpty()) {
            return;
        }
        Iterator it = this.m.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String svg = (String)WebUtil.getGradientSVGCache().get(id);
            sb.append(svg);
        }
    }

    void E(StringBuffer sb) {
        if (this.A.isEmpty()) {
            return;
        }
        Iterator it = this.A.iterator();
        while (it.hasNext()) {
            String type = (String)it.next();
            String svg = twaver.base.A.H.F.A(type);
            sb.append(svg);
        }
    }

    void A(StringBuffer sb) {
        if (this._.isEmpty()) {
            return;
        }
        Iterator it = this._.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String svg = (String)WebUtil.getTexturePatternSVGCache().get(id);
            sb.append(svg);
        }
    }

    void C(StringBuffer sb) {
        if (this.E.isEmpty()) {
            return;
        }
        Iterator it = this.E.keySet().iterator();
        while (it.hasNext()) {
            C key = (C)it.next();
            String id = WebUtil.getImageID(key);
            ImageIcon image = TWaverUtil.getImageIcon(key.B, key.A);
            sb.append("<image id='").append(id).append("' width='").append(image.getIconWidth()).append("' height='").append(image.getIconHeight()).append("' xlink:href='");
            if (!this.r && this.e != null) {
                StringBuffer fileUrl = new StringBuffer(this.e).append(id);
                sb.append(this.L).append(id);
                if (!this.M) {
                    fileUrl = fileUrl.append(H);
                    sb.append(H);
                }
                fileUrl = fileUrl.append(".").append(WebUtil.IMAGE_FORMAT);
                sb.append(".").append(WebUtil.IMAGE_FORMAT);
                twaver.base.A.E.O.A(image.getImage(), fileUrl.toString(), WebUtil.IMAGE_FORMAT, this.W);
            } else {
                String data = WebUtil.getImageBase64(id, key);
                sb.append("data:image/").append(WebUtil.IMAGE_FORMAT).append(";base64,").append(data);
            }
            sb.append("'/>\n");
        }
    }

    public String getSVGXMLNS() {
        return this.n;
    }

    public void setSVGXMLNS(String svgXMLNS) {
        this.n = svgXMLNS;
    }

    public String getImageFilePath() {
        return this.e;
    }

    public void setImageFilePath(String imageFilePath) {
        this.e = imageFilePath;
    }

    public String getImageURLPrefix() {
        return this.L;
    }

    public void setImageURLPrefix(String imageURLPrefix) {
        this.L = imageURLPrefix;
    }

    public String getDescription() {
        return this.P;
    }

    public void setDescription(String description) {
        this.P = description;
    }

    public boolean isUseCDATA() {
        return this.Y;
    }

    public void setUseCDATA(boolean useCDATAWithElementLabel) {
        this.Y = useCDATAWithElementLabel;
    }

    public boolean isTextEscape() {
        return this.i;
    }

    public void setTextEscape(boolean textEscape) {
        this.i = textEscape;
    }

    public boolean isShowAlarmOnTop() {
        return this.d;
    }

    public void setShowAlarmOnTop(boolean showAlarmAttachmentOnTop) {
        this.d = showAlarmAttachmentOnTop;
    }

    public NumberFormat getDoubleFormat() {
        return this.F;
    }

    public void setDoubleFormat(NumberFormat doubleFormat) {
        this.F = doubleFormat;
    }

    public String format(double value) {
        return this.F.format(value);
    }

    public boolean isUseBase64() {
        return this.r;
    }

    public void setUseBase64(boolean useBase64) {
        this.r = useBase64;
    }

    public Color getDefaultBackgroundColor() {
        return this.s;
    }

    public void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        this.s = defaultBackgroundColor;
    }

    public Dimension getMinBackgroundSize() {
        return this.h;
    }

    public void setMinBackgroundSize(Dimension minBackgroundSize) {
        this.h = minBackgroundSize;
    }

    public boolean isImageCache() {
        return this.M;
    }

    public void setImageCache(boolean imageCache) {
        this.M = imageCache;
    }

    public void appendElementHeadCustomAttribute(StringBuffer sb, Object element) {
        String cuntomAttribute;
        if (this.t != null && (cuntomAttribute = (String)this.t.generate(element)) != null) {
            sb.append(" ").append(cuntomAttribute);
        }
    }

    public void appendBackgroundHeadCustomAttribute(StringBuffer sb, Object element) {
        String cuntomAttribute;
        if (this.I != null && (cuntomAttribute = (String)this.I.generate(element)) != null) {
            sb.append(" ").append(cuntomAttribute);
        }
    }

    public void appendElementBodyCustomAttribute(StringBuffer sb, Object element) {
        String cuntomAttribute;
        if (this.O != null && (cuntomAttribute = (String)this.O.generate(element)) != null) {
            sb.append(" ").append(cuntomAttribute);
        }
    }

    public Generator getBackgroundAttributeGenerator() {
        return this.I;
    }

    public void setBackgroundAttributeGenerator(Generator backgroundAttributeGenerator) {
        this.I = backgroundAttributeGenerator;
    }

    public Generator getElementHeadCustomAttributeGenerator() {
        return this.t;
    }

    public void setElementHeadCustomAttributeGenerator(Generator elementHeadCustomAttributeGenerator) {
        this.t = elementHeadCustomAttributeGenerator;
    }

    public Generator getElementBodyCustomAttributeGenerator() {
        return this.O;
    }

    public void setElementBodyCustomAttributeGenerator(Generator elementBodyAttributeGenerator) {
        this.O = elementBodyAttributeGenerator;
    }

    public boolean isSvgHeader() {
        return this.D;
    }

    public void setSvgHeader(boolean svgHeader) {
        this.D = svgHeader;
    }

    public double getStartX() {
        return this.U;
    }

    public void setStartX(double startX) {
        this.U = startX;
    }

    public double getStartY() {
        return this.S;
    }

    public void setStartY(double startY) {
        this.S = startY;
    }

    public Object getCurrentSubNetworkID() {
        return this.c;
    }

    public void setCurrentSubNetworkID(Object currentSubNetworkID) {
        this.c = currentSubNetworkID;
    }

    public String getDefsNodeID() {
        return this.j;
    }

    public void setDefsNodeID(String defsNodeID) {
        this.j = defsNodeID;
    }

    public String getOutGNodeID() {
        return this.l;
    }

    public void setOutGNodeID(String outGNodeID) {
        this.l = outGNodeID;
    }

    public boolean isEnableInteract() {
        return this.Z;
    }

    public void setEnableInteract(boolean enableInteract) {
        this.Z = enableInteract;
    }

    public boolean isEnableElementLabelInteract() {
        return this.f;
    }

    public void setEnableElementLabelInteract(boolean enableElementLabelInteract) {
        this.f = enableElementLabelInteract;
    }

    public boolean isSizeByImageBackgroundSize() {
        return this.X;
    }

    public void setSizeByImageBackgroundSize(boolean isSizeByImageBackgroundSize) {
        this.X = isSizeByImageBackgroundSize;
    }

    public boolean isShapeEditable() {
        return this.J;
    }

    public void setShapeEditable(boolean isShapeEditable) {
        this.J = isShapeEditable;
    }

    public boolean isSaveImageToFileUseCache() {
        return this.W;
    }

    public void setSaveImageToFileUseCache(boolean isSaveImageToFileUseCache) {
        this.W = isSaveImageToFileUseCache;
    }

    public boolean isEnableElementTooltip() {
        return this.B;
    }

    public void setEnableElementTooltip(boolean enableElementTooltip) {
        this.B = enableElementTooltip;
    }

    public String getDefaultFontFamily() {
        return (String)this.K.get("font-family");
    }

    public void setDefaultFontFamily(String defaultFontFamily) {
        this.K.put("font-family", defaultFontFamily);
    }

    public int getDefaultFontSize() {
        return (Integer)this.K.get("font-size");
    }

    public void setDefaultFontSize(int defaultFontSize) {
        this.K.put("font-size", TWaverUtil.valueOf(defaultFontSize));
    }

    public String getDefaultFontWeight() {
        return (String)this.K.get("font-weight");
    }

    public void setDefaultFontWeight(String defaultFontWeight) {
        this.K.put("font-weight", defaultFontWeight);
    }

    public boolean isEscapeText() {
        return this.g;
    }

    public void setEscapeText(boolean isEscapeText) {
        this.g = isEscapeText;
    }

    void D(StringBuffer result) {
        if (!this.V.isEmpty()) {
            Iterator it = this.V.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = this.V.get(key);
                result.append(" " + key + "='" + value + "'");
            }
        }
    }

    public void addSVGHeadCustomAttribute(String key, String value) {
        this.V.put(key, value);
    }

    public void removeSVGHeadCustomAttribute(String key) {
        this.V.remove(key);
    }

    public void clearSVGHeadCustomAttribute() {
        this.V.clear();
    }

    public String getWebPhysicalPath() {
        return this.R;
    }
}

