/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.style.button.flat;

import com.nepxion.swing.button.IButtonModel;
import com.nepxion.swing.style.button.AbstractButtonUI;
import com.nepxion.swing.style.button.IButtonStyle;
import com.nepxion.swing.style.button.flat.IFlatButtonStyle;
import com.nepxion.swing.style.button.flat.JFlatButtonStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class FlatButtonUI
extends AbstractButtonUI {
    public static final String ID = FlatButtonUI.class.getName();
    protected Color brightColor;
    protected Color darkColor;
    protected IFlatButtonStyle buttonStyle;

    public FlatButtonUI() {
        this(new JFlatButtonStyle());
    }

    public FlatButtonUI(IButtonStyle buttonStyle) {
        this.setButtonStyle(buttonStyle);
        this.setArrowPainted(false);
    }

    @Override
    public IButtonStyle getButtonStyle() {
        return this.buttonStyle;
    }

    @Override
    public void setButtonStyle(IButtonStyle buttonStyle) {
        this.buttonStyle = (IFlatButtonStyle)buttonStyle;
        this.brightColor = this.buttonStyle.getBrightColor();
        this.darkColor = this.buttonStyle.getDarkColor();
    }

    @Override
    public void paintMenuDropDown(IButtonModel buttonModel, Graphics g, JComponent c) {
    }

    @Override
    public void paintPressed(IButtonModel buttonModel, Graphics g, JComponent c) {
        g.setColor(this.darkColor);
        g.drawLine(0, 0, c.getWidth() - 1, 0);
        g.drawLine(0, 0, 0, c.getHeight() - 1);
        g.setColor(this.brightColor);
        g.drawLine(0, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
        g.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight() - 1);
    }

    @Override
    public void paintSelected(IButtonModel buttonModel, Graphics g, JComponent c) {
        this.paintPressed(buttonModel, g, c);
    }

    @Override
    public void paintRollover(IButtonModel buttonModel, Graphics g, JComponent c) {
        g.setColor(this.brightColor);
        g.drawLine(0, 0, c.getWidth() - 1, 0);
        g.drawLine(0, 0, 0, c.getHeight() - 1);
        g.setColor(this.darkColor);
        g.drawLine(0, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
        g.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight() - 1);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (c.getWidth() % 2 != 0) {
            ++textRect.x;
        }
        if (c.getHeight() % 2 != 0) {
            ++textRect.y;
        }
        textRect.x += this.getWidthOffset();
        textRect.y += this.getHeightOffset();
        super.paintText(g, c, textRect, text);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        if (c.getWidth() % 2 != 0) {
            ++iconRect.x;
        }
        if (c.getHeight() % 2 != 0) {
            ++iconRect.y;
        }
        iconRect.x += this.getWidthOffset();
        iconRect.y += this.getHeightOffset();
        super.paintIcon(g, c, iconRect);
    }
}

