/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.id.netease;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.id.netease.JNeteaseIDPanel;
import com.nepxion.swing.searcher.id.netease.JNeteaseIDTable;
import com.nepxion.swing.searcher.id.netease.NeteaseIDTableModel;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.id.netease.NeteaseIDEntity;
import com.nepxion.util.searcher.id.netease.NeteaseIDSearcher;
import java.awt.event.ActionEvent;

public class NeteaseIDController {
    public static JSecurityAction getSearchAction(final JNeteaseIDPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("id_code_to_info")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("id_code_to_info"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        NeteaseIDEntity entity = (NeteaseIDEntity)data;
                        if (entity == null) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        NeteaseIDTableModel tableModel = (NeteaseIDTableModel)panel.getIDTable().getModel();
                        tableModel.addRow(entity);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        String id = panel.getID();
                        if (id.equals("")) {
                            throw new IllegalArgumentException(SwingLocale.getString("id_code_not_null"));
                        }
                        if (id.length() != 15 && id.length() != 18) {
                            throw new IllegalArgumentException(SwingLocale.getString("id_code_length_15_or_18"));
                        }
                        NeteaseIDSearcher searcher = new NeteaseIDSearcher();
                        NeteaseIDEntity entity = searcher.search(id);
                        return entity;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JNeteaseIDTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                NeteaseIDTableModel tableModel = (NeteaseIDTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

