/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Timer;

public class AutoRepeatButtonUtils
implements ActionListener,
MouseListener {
    public static String AUTO_REPEAT = "AutoRepeat";
    public static String CLIENT_PROPERTY_AUTO_REPEAT = "AutoRepeat.AutoRepeatButtonUtils";
    public static int DEFAULT_DELAY = 200;
    public static int DEFAULT_INITIAL_DELAY = 500;
    private Timer _timer = null;
    private AbstractButton _button;

    public static void install(AbstractButton abstractButton) {
        AutoRepeatButtonUtils.uninstall(abstractButton);
        new AutoRepeatButtonUtils().installListeners(abstractButton, DEFAULT_DELAY, DEFAULT_INITIAL_DELAY);
    }

    public static void install(AbstractButton abstractButton, int n, int n2) {
        AutoRepeatButtonUtils.uninstall(abstractButton);
        new AutoRepeatButtonUtils().installListeners(abstractButton, n, n2);
    }

    public static void uninstall(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty(CLIENT_PROPERTY_AUTO_REPEAT);
        if (object instanceof AutoRepeatButtonUtils) {
            ((AutoRepeatButtonUtils)object).uninstallListeners();
        }
    }

    protected void installListeners(AbstractButton abstractButton, int n, int n2) {
        this._button = abstractButton;
        abstractButton.putClientProperty(CLIENT_PROPERTY_AUTO_REPEAT, this);
        abstractButton.addMouseListener(this);
        this._timer = new Timer(n, this);
        this._timer.setInitialDelay(n2);
        this._timer.setRepeats(true);
    }

    protected void uninstallListeners() {
        if (this._button != null) {
            this._button.putClientProperty(CLIENT_PROPERTY_AUTO_REPEAT, null);
            this._button.removeMouseListener(this);
            this._button = null;
        }
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._timer.start();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._timer.stop();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this._timer.stop();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this._button.getModel().isPressed()) {
            return;
        }
        ActionListener[] actionListenerArray = this._button.getActionListeners();
        ActionEvent actionEvent2 = null;
        for (int i = actionListenerArray.length - 1; i >= 0; --i) {
            ActionListener actionListener = actionListenerArray[i];
            if (actionEvent2 == null) {
                String string = actionEvent.getActionCommand();
                if (string == null) {
                    string = this._button.getActionCommand();
                }
                actionEvent2 = new ActionEvent(this._button, 1001, string, actionEvent.getWhen(), actionEvent.getModifiers());
            }
            actionListener.actionPerformed(actionEvent2);
        }
    }
}

