/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.style.checkbox.lite;

import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.icon.paint.CheckBoxIcon;
import com.nepxion.swing.style.button.IButtonStyle;
import com.nepxion.swing.style.button.IButtonUI;
import com.nepxion.swing.style.button.lite.ILiteButtonStyle;
import com.nepxion.swing.style.checkbox.AbstractCheckBoxUI;
import java.awt.Color;

public class LiteCheckBoxUI
extends AbstractCheckBoxUI
implements IButtonUI {
    public static final String CHECKBOX_THEME_PLASTIC = "theme/checkbox/plastic/";
    public static final String CHECKBOX_THEME_NIMBUS = "theme/checkbox/nimbus/";
    private String checkBoxTheme = "theme/checkbox/plastic/";
    protected ILiteButtonStyle buttonStyle;

    public LiteCheckBoxUI(String checkBoxTheme, IButtonStyle buttonStyle) {
        this.checkBoxTheme = checkBoxTheme;
        this.setButtonStyle(buttonStyle);
    }

    @Override
    public IButtonStyle getButtonStyle() {
        return this.buttonStyle;
    }

    @Override
    public void setButtonStyle(IButtonStyle buttonStyle) {
        this.buttonStyle = (ILiteButtonStyle)buttonStyle;
        this.armedIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_lower.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), false, true, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.pressedIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_lower.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), false, true, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.rolloverIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_raised.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), false, true, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.disableIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_disable.png"), Color.gray, null, false, false, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.normalIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_normal.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), false, false, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.selectionArmedIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_lower.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), true, true, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.selectionPressedIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_lower.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), true, true, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.selectionRolloverIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_raised.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), true, true, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.selectionDisableIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_disable.png"), Color.gray, null, true, false, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
        this.selectionNormalIcon = new CheckBoxIcon(IconFactory.getSwingIcon(this.checkBoxTheme + "checkbox_normal.png"), this.buttonStyle.getCheckColor(), this.buttonStyle.getCheckFocusColor(), true, false, this.checkBoxTheme.equals(CHECKBOX_THEME_PLASTIC));
    }
}

