/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.Point;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class PointEditor
extends AbstractCellEditor {
    public PointEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public PointEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        try {
            String text = value.toString();
            String xString = text.substring(0, text.indexOf(","));
            int x = Integer.valueOf(xString);
            String yString = text.substring(text.indexOf(",") + 1);
            int y = Integer.valueOf(yString);
            return new Point(x, y);
        }
        catch (Exception ex) {
            return this.value;
        }
    }

    protected Object getDisplayValue(Object originalValue) {
        if (originalValue instanceof Point) {
            Point p2 = (Point)originalValue;
            return p2.x + "," + p2.y;
        }
        return originalValue;
    }
}

