/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.ImageIcon;
import twaver.RotatableNode;
import twaver.base.A.E.O;
import twaver.network.TNetwork;
import twaver.network.ui.NodeUI;

public class RotatableNodeUI
extends NodeUI {
    private RotatableNode j;

    public RotatableNodeUI(TNetwork network, RotatableNode rotatableNode) {
        super(network, rotatableNode);
        this.j = rotatableNode;
    }

    public void paintBody(Graphics2D g2d) {
        Color bodyColor = this.getPaintBodyColor(null);
        ImageIcon image = O.A(this.element.getImageURL(), bodyColor);
        if (image == null) {
            return;
        }
        Point center = this.j.getCenterLocation();
        double angle = Math.toRadians(this.j.getAngle());
        double zoom = this.j.getZoom();
        g2d.translate(center.x, center.y);
        g2d.rotate(angle);
        Rectangle bounds = new Rectangle(-((int)((double)(image.getIconWidth() / 2) * zoom)), -((int)((double)(image.getIconHeight() / 2) * zoom)), (int)((double)image.getIconWidth() * zoom), (int)((double)image.getIconHeight() * zoom));
        g2d.drawImage(image.getImage(), bounds.x, bounds.y, bounds.width, bounds.height, null);
        if (this.textureFactory != null) {
            if (bodyColor == null) {
                this.setBodyPaint(g2d, this.color);
            } else {
                this.setBodyPaint(g2d, bodyColor);
            }
            g2d.fill(bounds);
        }
        g2d.rotate(-angle);
        g2d.translate(-center.x, -center.y);
    }

    public Shape getBorderShape() {
        if (this.customDraw) {
            return null;
        }
        return this.j.getRotatableShape();
    }

    public boolean contains(int x, int y) {
        if (this.customDraw) {
            return super.contains(x, y);
        }
        if (this.j.getRotatableShape().contains(x, y)) {
            return true;
        }
        return this.containInAttachments(x, y);
    }
}

