/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import twaver.Node;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.E.L;
import twaver.base.A.E._;
import twaver.base.A.E.b;

public class ShapeNode
extends Node {
    protected int shapeNodeType = 0;
    protected List points = new ArrayList();
    protected List segments = null;
    protected transient Shape shape = TWaverConst.EMPTY_BOUNDS;
    protected boolean isAdjusting = false;

    public ShapeNode() {
        this.I();
    }

    public ShapeNode(Object id) {
        super(id);
        this.I();
    }

    private void I() {
        this.getClientProperties().put("custom.draw.fill", Boolean.FALSE);
        this.getClientProperties().put("custom.draw.fill.color", Color.GRAY);
        this.getClientProperties().put("custom.draw.outline", Boolean.TRUE);
        this.getClientProperties().put("custom.draw.outline.3d", Boolean.TRUE);
        this.getClientProperties().put("custom.draw.outline.color", Color.LIGHT_GRAY);
        this.getClientProperties().put("custom.draw.outline.stroke", "solid.thickest");
    }

    public int getShapeNodeType() {
        return this.shapeNodeType;
    }

    public void setShapeNodeType(int shapeNodeType) {
        if (this.shapeNodeType != shapeNodeType) {
            int oldValue = this.shapeNodeType;
            if (shapeNodeType == 1 || shapeNodeType == 2 || shapeNodeType == 3 || shapeNodeType == 4 || shapeNodeType == 5 || shapeNodeType == 6 || shapeNodeType == 7 || shapeNodeType == 8 || shapeNodeType == 9) {
                this.putCustomDraw(true);
            } else {
                shapeNodeType = 0;
                this.putCustomDraw(false);
            }
            this.shapeNodeType = shapeNodeType;
            this.firePropertyChange("shapeNodeType", oldValue, shapeNodeType);
            this.firePointsChange();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.shape = this.createShape();
    }

    public String getUIClassID() {
        return "ShapeNodeUI";
    }

    public String getSVGUIClassID() {
        return "ShapeNodeSVGUI";
    }

    public List getPoints() {
        return this.points;
    }

    public Point2D getPoint(int index) {
        if (index >= 0 && index < this.points.size()) {
            return (Point2D)this.points.get(index);
        }
        return null;
    }

    public Point2D[] toPoints() {
        Point2D[] ps = (Point2D[])Array.newInstance(Point2D.class, this.points.size());
        this.points.toArray(ps);
        return ps;
    }

    public List getSegments() {
        return this.segments;
    }

    public void setSegments(List segments) {
        this.segments = segments;
        this.firePointsChange();
    }

    public void setBaseShape(Shape baseShape) {
        GeneralPath path = null;
        path = baseShape instanceof GeneralPath ? (GeneralPath)baseShape : new GeneralPath(baseShape);
        ArrayList ps = new ArrayList();
        this.segments = new ArrayList();
        L.A(path, ps, this.segments);
        this.setPoints(ps);
    }

    public void setPoints(List points) {
        this.points = L.A(points);
        this.firePointsChange();
    }

    public void setPoint(int index, Point2D point) {
        if (index >= 0 && index < this.points.size()) {
            this.points.set(index, L.A(point));
            this.firePointsChange();
        }
    }

    public void insertPoint(int index, Point2D point) {
        if (index >= 0 && index <= this.points.size()) {
            this.points.add(index, L.A(point));
            this.firePointsChange();
        }
    }

    public void removePoint(int index) {
        if (index >= 0 && index < this.points.size()) {
            this.points.remove(index);
            this.firePointsChange();
        }
    }

    public void addPoint(Point2D point) {
        if (point != null) {
            this.points.add(L.A(point));
            this.firePointsChange();
        }
    }

    public void clear() {
        if (this.points.size() > 0) {
            this.points.clear();
            this.firePointsChange();
        }
        this.segments = null;
    }

    public int getWidth() {
        return this.getBounds().width;
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    public void setLocation(Point2D.Double location) {
        if (this.isAdjusting || TWaverUtil.isXMLParsing()) {
            super.setLocation(location);
        } else {
            double xOffSet = location.getX() - this.xLocation;
            double yOffSet = location.getY() - this.yLocation;
            if (xOffSet != 0.0 || yOffSet != 0.0) {
                for (int i2 = 0; i2 < this.points.size(); ++i2) {
                    Point2D point = (Point2D)this.points.get(i2);
                    point.setLocation(point.getX() + xOffSet, point.getY() + yOffSet);
                }
                super.setLocation(location);
                this.firePointsChange();
            }
        }
    }

    protected Shape createShape() {
        return _.A(this);
    }

    public void firePointsChange() {
        if (this.isAdjusting) {
            return;
        }
        this.shape = this.createShape();
        this.isAdjusting = true;
        this.setLocation(this.shape.getBounds().getLocation());
        this.isAdjusting = false;
        this.firePropertyChange("points", null, this.points);
    }

    public Shape getShape() {
        return this.shape;
    }

    public GeneralPath getPath() {
        if (this.shape instanceof GeneralPath) {
            return (GeneralPath)this.shape;
        }
        return new GeneralPath(this.shape);
    }

    public void putShapeNodeShowDashLine(boolean shapeNodeShowDashLine) {
        this.putClientProperty((Object)"shapenode.show.dash.line", shapeNodeShowDashLine);
    }

    public boolean isShapeNodeShowDashLine() {
        return b.K(this, "shapenode.show.dash.line");
    }

    public void putShapeNodeJointPoint(int shapeNodeJointPoint) {
        this.putClientProperty((Object)"shapenode.joint.point", shapeNodeJointPoint);
    }

    public int getShapeNodeJointPoint() {
        return b.J(this, "shapenode.joint.point");
    }

    public void putShapeNodeFromArrow(boolean shapeNodeFromArrow) {
        this.putClientProperty((Object)"shapenode.from.arrow", shapeNodeFromArrow);
    }

    public void putShapeNodeToArrow(boolean shapeNodeToArrow) {
        this.putClientProperty((Object)"shapenode.to.arrow", shapeNodeToArrow);
    }

    public void putShapeNodeFromArrowXOffset(int shapeNodeFromArrowXOffset) {
        this.putClientProperty((Object)"shapenode.from.arrow.xoffset", shapeNodeFromArrowXOffset);
    }

    public void putShapeNodeFromArrowYOffset(int shapeNodeFromArrowYOffset) {
        this.putClientProperty((Object)"shapenode.from.arrow.yoffset", shapeNodeFromArrowYOffset);
    }

    public void putShapeNodeToArrowXOffset(int shapeNodeToArrowXOffset) {
        this.putClientProperty((Object)"shapenode.to.arrow.xoffset", shapeNodeToArrowXOffset);
    }

    public void putShapeNodeToArrowYOffset(int shapeNodeToArrowYOffset) {
        this.putClientProperty((Object)"shapenode.to.arrow.yoffset", shapeNodeToArrowYOffset);
    }

    public void putShapeNodeFromArrowCenter(boolean shapeNodeFromArrowCenter) {
        this.putClientProperty((Object)"shapenode.from.arrow.center", shapeNodeFromArrowCenter);
    }

    public void putShapeNodeToArrowCenter(boolean shapeNodeToArrowCenter) {
        this.putClientProperty((Object)"shapenode.to.arrow.center", shapeNodeToArrowCenter);
    }

    public void putShapeNodeFromArrowStyle(int shapeNodeFromArrowStyle) {
        this.putClientProperty((Object)"shapenode.from.arrow.style", shapeNodeFromArrowStyle);
    }

    public void putShapeNodeToArrowStyle(int shapeNodeToArrowStyle) {
        this.putClientProperty((Object)"shapenode.to.arrow.style", shapeNodeToArrowStyle);
    }

    public void putShapeNodeFromArrowColor(Color shapeNodeFromArrowColor) {
        this.putClientProperty((Object)"shapenode.from.arrow.color", shapeNodeFromArrowColor);
    }

    public void putShapeNodeToArrowColor(Color shapeNodeToArrowColor) {
        this.putClientProperty((Object)"shapenode.to.arrow.color", shapeNodeToArrowColor);
    }

    public void putShapeNodeFromArrowOutline(boolean shapeNodeFromArrowOutline) {
        this.putClientProperty((Object)"shapenode.from.arrow.outline", shapeNodeFromArrowOutline);
    }

    public void putShapeNodeToArrowOutline(boolean shapeNodeToArrowOutline) {
        this.putClientProperty((Object)"shapenode.to.arrow.outline", shapeNodeToArrowOutline);
    }

    public void putShapeNodeFromArrowOutlineColor(Color shapeNodeFromArrowOutlineColor) {
        this.putClientProperty((Object)"shapenode.from.arrow.outline.color", shapeNodeFromArrowOutlineColor);
    }

    public void putShapeNodeToArrowOutlineColor(Color shapeNodeToArrowOutlineColor) {
        this.putClientProperty((Object)"shapenode.to.arrow.outline.color", shapeNodeToArrowOutlineColor);
    }

    public boolean isShapeNodeFromArrowCenter() {
        return b.K(this, "shapenode.from.arrow.center");
    }

    public boolean isShapeNodeToArrowCenter() {
        return b.K(this, "shapenode.to.arrow.center");
    }

    public int getShapeNodeFromArrowStyle() {
        return b.J(this, "shapenode.from.arrow.style");
    }

    public int getShapeNodeToArrowStyle() {
        return b.J(this, "shapenode.to.arrow.style");
    }

    public Color getShapeNodeFromArrowColor() {
        return b.P(this, "shapenode.from.arrow.color");
    }

    public Color getShapeNodeToArrowColor() {
        return b.P(this, "shapenode.to.arrow.color");
    }

    public Color getShapeNodeFromArrowOutlineColor() {
        return b.P(this, "shapenode.from.arrow.outline.color");
    }

    public Color getShapeNodeToArrowOutlineColor() {
        return b.P(this, "shapenode.to.arrow.outline.color");
    }

    public boolean isShapeNodeFromArrowOutline() {
        return b.K(this, "shapenode.from.arrow.outline");
    }

    public boolean isShapeNodeToArrowOutline() {
        return b.K(this, "shapenode.to.arrow.outline");
    }

    public int getShapeNodeFromArrowXOffset() {
        return b.J(this, "shapenode.from.arrow.xoffset");
    }

    public int getShapeNodeFromArrowYOffset() {
        return b.J(this, "shapenode.from.arrow.yoffset");
    }

    public int getShapeNodeToArrowXOffset() {
        return b.J(this, "shapenode.to.arrow.xoffset");
    }

    public int getShapeNodeToArrowYOffset() {
        return b.J(this, "shapenode.to.arrow.yoffset");
    }

    public boolean isShapeNodeFromArrow() {
        return b.K(this, "shapenode.from.arrow");
    }

    public boolean isShapeNodeToArrow() {
        return b.K(this, "shapenode.to.arrow");
    }
}

