/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.lazyloader;

import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.swingworker.JSwingWorker;
import com.nepxion.swing.tree.lazyloader.ILazyLoaderTree;
import com.nepxion.swing.tree.lazyloader.JLazyLoaderTreeNode;
import com.nepxion.swing.tree.lazyloader.LoadingTreeNode;
import com.nepxion.swing.tree.lazyloader.SearchDescription;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class LazyLoaderSwingWorker
extends JSwingWorker {
    private ILazyLoaderTree lazyLoaderTree;
    private JLazyLoaderTreeNode lazyLoaderTreeNode;
    private LoadingTreeNode loadingTreeNode;
    private boolean isRecursive = false;
    private int recursionDepth = -1;
    private int recursionPathCount = -1;
    private SearchDescription searchDescription;

    public LazyLoaderSwingWorker(ILazyLoaderTree lazyLoaderTree, JLazyLoaderTreeNode lazyLoaderTreeNode) {
        this(lazyLoaderTree, lazyLoaderTreeNode, lazyLoaderTree.getLazyLoader().isRecursive(), lazyLoaderTree.getLazyLoader().getRecursionDepth(), lazyLoaderTree.getTreeNodePathCount(lazyLoaderTreeNode), lazyLoaderTree.getLazyLoader().getSearchDescription());
    }

    private LazyLoaderSwingWorker(ILazyLoaderTree lazyLoaderTree, JLazyLoaderTreeNode lazyLoaderTreeNode, boolean isRecursive, int recursionDepth, int recursionPathCount, SearchDescription searchDescription) {
        this.lazyLoaderTree = lazyLoaderTree;
        this.lazyLoaderTreeNode = lazyLoaderTreeNode;
        this.isRecursive = isRecursive;
        this.recursionDepth = recursionDepth;
        this.recursionPathCount = recursionPathCount;
        this.searchDescription = searchDescription;
        this.setComponent((JTree)((Object)lazyLoaderTree));
        this.loadingTreeNode = new LoadingTreeNode(this);
        if (lazyLoaderTree.getLazyLoader().isSynchronized()) {
            this.loadingTreeNode.setAction(0);
        } else {
            this.loadingTreeNode.setAction(1);
        }
        lazyLoaderTreeNode.add(this.loadingTreeNode);
        lazyLoaderTreeNode.setLoading(true);
        lazyLoaderTree.update(lazyLoaderTreeNode);
        lazyLoaderTree.expand(lazyLoaderTreeNode);
    }

    @Override
    protected void loadForeground(final Object data) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LazyLoaderSwingWorker.this.lazyLoaderTreeNode.isNodeChild(LazyLoaderSwingWorker.this.loadingTreeNode)) {
                    LazyLoaderSwingWorker.this.lazyLoaderTreeNode.remove(LazyLoaderSwingWorker.this.loadingTreeNode);
                }
                if (data instanceof Exception) {
                    return;
                }
                try {
                    LazyLoaderSwingWorker.this.lazyLoaderTree.getLazyLoader().loadForeground(data, LazyLoaderSwingWorker.this.lazyLoaderTreeNode);
                }
                catch (Exception e) {
                    LazyLoaderSwingWorker.this.fireForegroundException(e);
                    Exception exception = null;
                    exception = e.getCause() != null && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
                    ExceptionTracer.traceException(HandleManager.getFrame(LazyLoaderSwingWorker.this.getComponent()), exception);
                    return;
                }
                LazyLoaderSwingWorker.this.lazyLoaderTreeNode.setLoaded(!LazyLoaderSwingWorker.this.lazyLoaderTreeNode.isLeaf());
                LazyLoaderSwingWorker.this.lazyLoaderTree.scrollToVisible(LazyLoaderSwingWorker.this.lazyLoaderTreeNode);
                LazyLoaderSwingWorker.this.lazyLoaderTree.update(LazyLoaderSwingWorker.this.lazyLoaderTreeNode);
                LazyLoaderSwingWorker.this.recursion();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object loadBackground() throws Exception {
        if (this.lazyLoaderTree.getLazyLoader().isSynchronized()) {
            this.loadingTreeNode.setAction(0);
            return this.lazyLoaderTree.getLazyLoader().loadBackground(this.lazyLoaderTreeNode);
        }
        Object object = this.lazyLoaderTree.getLazyLoaderLock();
        synchronized (object) {
            this.loadingTreeNode.setAction(0);
            return this.lazyLoaderTree.getLazyLoader().loadBackground(this.lazyLoaderTreeNode);
        }
    }

    private void recursion() {
        if (!this.isRecursive) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.lazyLoaderTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode childTreeNode = enumeration.nextElement();
            if (!(childTreeNode instanceof JLazyLoaderTreeNode)) continue;
            JLazyLoaderTreeNode childLazyLoaderTreeNode = (JLazyLoaderTreeNode)childTreeNode;
            if (this.searchDescription != null) {
                String searchText = this.searchDescription.getSearchText();
                boolean isCaseSensitive = this.searchDescription.isCaseSensitive();
                boolean isTextMatched = this.searchDescription.isTextMatched();
                if (searchText != null && !searchText.equals("")) {
                    String treeNodeName = childLazyLoaderTreeNode.toString();
                    if (!isCaseSensitive) {
                        searchText = searchText.toLowerCase();
                        treeNodeName = treeNodeName.toLowerCase();
                    }
                    if (isTextMatched) {
                        if (treeNodeName.equals(searchText)) {
                            this.lazyLoaderTree.addSelectionTreeNode(childLazyLoaderTreeNode);
                            this.searchDescription.getResult().add(childLazyLoaderTreeNode);
                        }
                    } else if (treeNodeName.indexOf(searchText) > -1) {
                        this.lazyLoaderTree.addSelectionTreeNode(childLazyLoaderTreeNode);
                        this.searchDescription.getResult().add(childLazyLoaderTreeNode);
                    }
                }
            }
            if (this.recursionDepth < 0) {
                if (this.lazyLoaderTree.getLazyLoader().isLoaded(childLazyLoaderTreeNode) || this.lazyLoaderTree.getLazyLoader().isLoading(childLazyLoaderTreeNode) || childLazyLoaderTreeNode.isLeaf()) continue;
                LazyLoaderSwingWorker lazyLoaderSwingWorker = new LazyLoaderSwingWorker(this.lazyLoaderTree, childLazyLoaderTreeNode, this.isRecursive, this.recursionDepth, this.recursionPathCount, this.searchDescription);
                lazyLoaderSwingWorker.execute();
                continue;
            }
            int pathCount = this.lazyLoaderTree.getTreeNodePathCount(this.lazyLoaderTreeNode);
            if (pathCount - this.recursionPathCount >= this.recursionDepth - 1 || this.lazyLoaderTree.getLazyLoader().isLoaded(childLazyLoaderTreeNode) || this.lazyLoaderTree.getLazyLoader().isLoading(childLazyLoaderTreeNode) || childLazyLoaderTreeNode.isLeaf()) continue;
            LazyLoaderSwingWorker lazyLoaderSwingWorker = new LazyLoaderSwingWorker(this.lazyLoaderTree, childLazyLoaderTreeNode, this.isRecursive, this.recursionDepth, this.recursionPathCount, this.searchDescription);
            lazyLoaderSwingWorker.execute();
        }
    }

    @Override
    public void firePendingStatusChanged() {
    }

    @Override
    public void fireStartedStatusChanged() {
        this.lazyLoaderTreeNode.setLoading(true);
    }

    @Override
    public void fireDoneStatusChanged() {
        this.lazyLoaderTreeNode.setLoading(false);
    }

    @Override
    public void fireProgressValueChanged(Object value) {
    }

    @Override
    public void fireCancelledStatusChanged() {
        this.lazyLoaderTreeNode.setLoaded(false);
        if (this.lazyLoaderTreeNode.isNodeChild(this.loadingTreeNode)) {
            this.lazyLoaderTreeNode.remove(this.loadingTreeNode);
        }
        this.lazyLoaderTree.update(this.lazyLoaderTreeNode);
    }

    @Override
    public void fireForegroundException(Exception e) {
        this.fireCancelledStatusChanged();
    }

    @Override
    public void fireBackgroundException(Exception e) {
    }
}

