/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import twaver.TWaverUtil;
import twaver.network.CanvasMarker;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public abstract class RectangleInputHandler
extends InputAdapter
implements CanvasMarker {
    protected TNetwork network = null;
    protected Point mousePressedPoint = null;
    protected Point mouseCurrentPoint = null;

    public RectangleInputHandler(TNetwork network) {
        this.network = network;
    }

    public void init() {
    }

    public void mousePressed(MouseEvent e2) {
        this.mousePressedPoint = e2.getPoint();
        this.network.addCanvasMarker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e2) {
        try {
            if (this.mousePressedPoint != null && this.mouseCurrentPoint != null) {
                Rectangle rect = TWaverUtil.getRectangle(this.mousePressedPoint, this.mouseCurrentPoint);
                this.rectangleProcess(this.network, rect);
                this.network.getRenderer().repaintPhysicalBounds(rect);
            }
            Object var4_3 = null;
            this.network.addCanvasMarker(this);
            this.mousePressedPoint = null;
            this.mouseCurrentPoint = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.network.addCanvasMarker(this);
            this.mousePressedPoint = null;
            this.mouseCurrentPoint = null;
            throw throwable;
        }
    }

    public abstract void rectangleProcess(TNetwork var1, Rectangle var2);

    public void mouseDragged(MouseEvent e2) {
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.mousePressedPoint != null && this.mouseCurrentPoint != null) {
                Rectangle rect = TWaverUtil.getRectangle(this.mousePressedPoint, this.mouseCurrentPoint);
                this.network.getRenderer().repaintPhysicalBounds(rect);
            }
            this.mouseCurrentPoint = e2.getPoint();
        }
    }

    public void mark(Graphics2D g2) {
        TWaverUtil.drawDashRectangle(g2, this.mousePressedPoint, this.mouseCurrentPoint, this.network.getZoomer().getZoom());
    }

    public TNetwork getNetwork() {
        return this.network;
    }

    public Point getMouseCurrentPoint() {
        return this.mouseCurrentPoint;
    }

    public Point getMousePressedPoint() {
        return this.mousePressedPoint;
    }
}

