/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tip.balloon;

import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.textarea.JAutoResizableTextArea;
import com.nepxion.swing.tip.balloon.AbstractBalloonTip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JBalloonTip
extends AbstractBalloonTip {
    public static final ImageIcon TIP_ICON_ERROR_MESSAGE = IconFactory.getSwingIcon("error_message.png");
    public static final ImageIcon TIP_ICON_WARNING_MESSAGE = IconFactory.getSwingIcon("warning_message.png");
    public static final ImageIcon TIP_ICON_INFORMATION_MESSAGE = IconFactory.getSwingIcon("information_message.png");
    public static final ImageIcon TIP_ICON_QUESTION_MESSAGE = IconFactory.getSwingIcon("question_message.png");
    public static final ImageIcon TIP_ICON_ERROR = IconFactory.getSwingIcon("error.png");
    public static final ImageIcon TIP_ICON_WARNING = IconFactory.getSwingIcon("warning.png");
    public static final ImageIcon TIP_ICON_INFORMATION = IconFactory.getSwingIcon("information.png");
    public static final ImageIcon TIP_ICON_QUESTION = IconFactory.getSwingIcon("question.png");
    public static final int TIP_MINIMUM_ROWS = 1;
    public static final int TIP_MAXIMUM_ROWS = 50;
    public static final int TIP_COLUMNS = 20;
    public static final Border TIP_LABEL_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    public static final Border TIP_TEXTAREA_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private JLabel label = new JLabel();
    private JAutoResizableTextArea textArea;

    public JBalloonTip(Component component) {
        this(component, "");
    }

    public JBalloonTip(Component component, String tipText) {
        this(component, 1, 50, 20, tipText);
    }

    public JBalloonTip(Component component, int minimumRows, int maximumRows, int columns, String tipText) {
        this(component, minimumRows, maximumRows, columns, tipText, TIP_ICON_ERROR_MESSAGE, TIP_COLOR, 10, TIP_LABEL_BORDER, TIP_TEXTAREA_BORDER);
    }

    public JBalloonTip(Component component, int minimumRows, int maximumRows, int columns, String tipText, Icon tipIcon, Color tipColor, int tipOffset, Border tipLabelBorder, Border tipTextAreaBorder) {
        super(component, tipColor, tipOffset);
        this.label.setBackground(tipColor);
        this.label.setOpaque(true);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        labelPanel.setBackground(tipColor);
        labelPanel.add((Component)this.label, "North");
        this.textArea = new JAutoResizableTextArea(minimumRows, maximumRows, columns);
        this.textArea.setLabelStyle();
        this.textArea.setBackground(tipColor);
        this.textArea.setOpaque(true);
        JBasicScrollPane scrollPane = new JBasicScrollPane();
        scrollPane.setLabelStyle();
        scrollPane.setBackground(tipColor);
        scrollPane.getViewport().add((Component)((Object)this.textArea));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.setBackground(tipColor);
        panel.setOpaque(true);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        panel.add((Component)labelPanel, "West");
        panel.add((Component)scrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.setTipLabelBorder(tipLabelBorder);
        this.setTipTextAreaBorder(tipTextAreaBorder);
        this.setText(tipText);
        this.setIcon(tipIcon);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JBalloonTip.this.isVisible()) {
                    JBalloonTip.this.setVisible(false);
                }
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JBalloonTip.this.isVisible()) {
                    JBalloonTip.this.setVisible(false);
                }
            }
        });
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JAutoResizableTextArea getTextArea() {
        return this.textArea;
    }

    public void setText(String text) {
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setMinimumRows(int minimumRows) {
        this.textArea.setMinRows(minimumRows);
    }

    public void setMaximumRows(int maximumRows) {
        this.textArea.setMaxRows(maximumRows);
    }

    public void setColumns(int columns) {
        this.textArea.setColumns(columns);
    }

    public void setWidth(int width) {
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
    }

    public void setHeight(int height) {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, height));
    }

    private void setTipLabelBorder(Border tipLabelBorder) {
        this.label.setBorder(tipLabelBorder);
    }

    private void setTipTextAreaBorder(Border tipTextAreaBorder) {
        this.textArea.setBorder(tipTextAreaBorder);
    }
}

