/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.list;

import com.nepxion.swing.list.BasicListModel;
import com.nepxion.swing.list.IList;
import com.nepxion.swing.list.ListManager;
import com.nepxion.util.data.CollectionUtil;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JBasicList
extends JList
implements IList,
ListSelectionListener,
MouseListener {
    private int selectedIndex = -1;

    public JBasicList() {
        this.initComponents();
    }

    public JBasicList(BasicListModel listModel) {
        super(listModel);
        this.initComponents();
    }

    public JBasicList(Object[] listData) {
        this.setListData(listData);
        this.initComponents();
    }

    public JBasicList(Vector listData) {
        this.setListData(listData);
        this.initComponents();
    }

    private void initComponents() {
        ListManager.setPreferenceStyle(this);
        this.addMouseListener(this);
        this.addListSelectionListener(this);
    }

    @Override
    public Vector getListData() {
        BasicListModel listModel = (BasicListModel)this.getModel();
        return listModel.getRowDatas();
    }

    @Override
    public void setListData(Object[] listData) {
        Vector rowDatas = CollectionUtil.parseVector((Object[])listData);
        this.setListData(rowDatas);
    }

    @Override
    public void setListData(Vector listData) {
        ListModel model = this.getModel();
        if (model instanceof BasicListModel) {
            BasicListModel listModel = (BasicListModel)model;
            listModel.setRowDatas(listData);
        } else {
            BasicListModel listModel = new BasicListModel(listData);
            this.setModel(listModel);
        }
    }

    @Override
    public int[] getSelectedIndexes() {
        BasicListModel listModel = (BasicListModel)this.getModel();
        Object[] selectedValues = this.getSelectedValues();
        int[] selectedIndexes = new int[selectedValues.length];
        for (int i = 0; i < selectedValues.length; ++i) {
            int index;
            Object object = selectedValues[i];
            selectedIndexes[i] = index = listModel.indexOf(object);
        }
        return selectedIndexes;
    }

    public void moveUp(int index) {
        BasicListModel listModel = (BasicListModel)this.getModel();
        if (index > 0) {
            listModel.moveUp(index);
            this.setSelectedIndex(index - 1);
        }
    }

    public void moveDown(int index) {
        BasicListModel listModel = (BasicListModel)this.getModel();
        if (index > -1 && index < listModel.size() - 1) {
            listModel.moveDown(index);
            this.setSelectedIndex(index + 1);
        }
    }

    public int getIndex(Point point) {
        return ListManager.getIndex(this, point);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selectedRows = this.getSelectedIndexes();
        if (selectedRows.length == 0) {
            boolean isAdjusting = e.getValueIsAdjusting();
            if (isAdjusting) {
                int oldSelectedRow = this.selectedIndex;
                int newSelectedRow = -1;
                this.selectedIndex = -1;
                this.executeSelection(oldSelectedRow, newSelectedRow);
            }
        } else if (selectedRows.length == 1) {
            if (this.getSelectedIndex() == this.selectedIndex) {
                return;
            }
            this.selectedIndex = this.getSelectedIndex();
            int oldSelectedRow = -1;
            int newSelectedRow = -1;
            int firstIndex = e.getFirstIndex();
            int lastIndex = e.getLastIndex();
            if (e.getFirstIndex() == e.getLastIndex()) {
                newSelectedRow = this.selectedIndex;
            } else if (e.getFirstIndex() == this.selectedIndex) {
                oldSelectedRow = lastIndex;
                newSelectedRow = firstIndex;
            } else if (e.getLastIndex() == this.selectedIndex) {
                oldSelectedRow = firstIndex;
                newSelectedRow = lastIndex;
            } else {
                oldSelectedRow = -1;
                newSelectedRow = this.selectedIndex;
            }
            this.executeSelection(oldSelectedRow, newSelectedRow);
        }
    }

    @Override
    public void executeSelection(int oldSelectedRow, int newSelectedRow) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selectedRow = this.getSelectedIndex();
        this.executeClicked(selectedRow, e);
    }

    public void executeClicked(int selectedRow, MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.executeDoubleClicked(selectedRow);
        } else {
            this.executeClicked(selectedRow);
        }
    }

    @Override
    public void executeClicked(int selectedRow) {
    }

    @Override
    public void executeDoubleClicked(int selectedRow) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int selectedRow = this.getSelectedIndex();
        if (selectedRow > -1) {
            this.executePopupMenu(selectedRow, x, y);
        } else {
            this.executePopupMenu(x, y);
        }
    }

    @Override
    public void executePopupMenu(int selectedRow, int x, int y) {
    }

    @Override
    public void executePopupMenu(int x, int y) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

