/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import twaver.BatchAdapter;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSequenceAdapter;
import twaver.DataBoxSequenceListener;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.VisibleFilter;
import twaver.base.A.F.D;
import twaver.base.A.H.I;
import twaver.swing.RotatableLabel;
import twaver.web.TWebView;
import twaver.web.WebUtil;
import twaver.web.svg.network.SVGContext;

public abstract class AbstractSVGChart
implements TWebView {
    private String \u00f6 = "chart";
    protected String svgXMLNS = TUIManager.getString("web.svg.xmlns");
    protected boolean enableZoomAndPan = TUIManager.getBoolean("web.svg.enable.zoomandpan");
    protected TDataBox box = null;
    protected List proportionsOfSum = new ArrayList();
    protected List proportionsOfRange = new ArrayList();
    protected List publishedElements = new ArrayList();
    protected List visibleFilters = new ArrayList();
    protected Comparator sortComparator = null;
    protected boolean valueTextVisible = TUIManager.getBoolean("tchart.value.text.visible");
    protected int xGap = TUIManager.getInt("tchart.xgap");
    protected int yGap = TUIManager.getInt("tchart.ygap");
    protected int textGap = TUIManager.getInt("tchart.text.gap");
    protected String stroke = TUIManager.getString("tchart.stroke");
    protected Color backgroundColor = null;
    protected Color foregroundColor = null;
    protected Rectangle backgroundBounds = new Rectangle();
    protected float backgroundFillOpacity = 1.0f;
    protected String unit = TUIManager.getString("tchart.unit");
    protected NumberFormat format = TUIManager.getNumberFormat("tchart.format");
    protected boolean gradient = TUIManager.getBoolean("tchart.gradient");
    protected int shadowOffset = TUIManager.getInt("tchart.shadow.offset");
    protected boolean valueTextCenter = TUIManager.getBoolean("tchart.value.text.center");
    protected Color valueTextColor = TUIManager.getColor("tchart.value.text.color");
    protected Font valueTextFont = TUIManager.getFont("tchart.value.text.font");
    protected double upperLimit = TUIManager.getDouble("tchart.upper.limit");
    protected double lowerLimit = TUIManager.getDouble("tchart.lower.limit");
    protected int selectedOffset = TUIManager.getInt("tchart.selected.offset") + 3;
    protected String selectedStroke = TUIManager.getString("tchart.selected.stroke");
    protected Color selectedColor = TUIManager.getColor("tchart.selected.color");
    protected int valueTextPosition = TUIManager.getInt("tchart.value.text.positon");
    protected boolean backgroundVisible = TUIManager.getBoolean("tchart.background.visible");
    protected Color backgroundFillColor = TUIManager.getColor("tchart.background.fill.color");
    protected Color backgroundOutlineColor = TUIManager.getColor("tchart.background.outline.color");
    protected String backgroundStroke = TUIManager.getString("tchart.background.stroke");
    protected boolean backgroundGradient = TUIManager.getBoolean("tchart.background.gradient");
    protected Color backgroundGradientColor = TUIManager.getColor("tchart.background.gradient.color");
    protected int backgroundGradientFactory = TUIManager.getInt("tchart.background.gradient.factory");
    protected Color gradientColor = TUIManager.getColor("tchart.gradient.color");
    protected boolean legendVisible = true;
    protected int legendPosition = 3;
    protected Font legendFont = TUIManager.getFont("tchart.legend.font");
    protected int legendSize = this.legendFont.getSize();
    private int \u00f2 = 2;
    private int \u00ef = 5;
    private int \u00f5 = 3;
    private int \u00ee = 10;
    protected double sum = 0.0;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double range = 0.0;
    protected Map proportions = new LinkedHashMap();
    private DataBoxListener \u00f4 = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            AbstractSVGChart.this.publishData();
        }

        public void elementRemoved(DataBoxEvent e2) {
            AbstractSVGChart.this.publishData();
        }

        public void elementsCleared(DataBoxEvent e2) {
            AbstractSVGChart.this.publishData();
        }
    };
    private PropertyChangeListener \u00f0 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Element element = (Element)evt.getSource();
            if ("visible".equals(evt.getPropertyName()) && AbstractSVGChart.this.visibleFilters.size() == 1 && AbstractSVGChart.this.visibleFilters.get(0) == D.C) {
                AbstractSVGChart.this.publishData();
            } else if (AbstractSVGChart.this.isVisible(element)) {
                AbstractSVGChart.this.publishData();
            }
        }
    };
    private DataBoxSequenceListener \u00f1 = new DataBoxSequenceAdapter(){

        public void hiberarchyChanged(Element element) {
            AbstractSVGChart.this.publishData();
        }
    };
    private BatchListener \u00f3 = new BatchAdapter(){

        public void batchEnded(BatchEvent e2) {
            AbstractSVGChart.this.publishData();
        }
    };

    public AbstractSVGChart() {
        this(new TDataBox());
    }

    public AbstractSVGChart(TDataBox box) {
        this(box, null, null);
    }

    public AbstractSVGChart(TDataBox box, String title, Color backgroundColor) {
        this(box, title, backgroundColor, null);
    }

    public AbstractSVGChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        this.A(box, title, backgroundColor, foregroundColor);
    }

    private void J() {
        this.box.addBatchListener(this.\u00f3);
        this.box.addDataBoxListener(this.\u00f4);
        this.box.addDataBoxSequenceListener(this.\u00f1);
        this.box.addElementPropertyChangeListener(this.\u00f0);
    }

    private void I() {
        this.box.removeBatchListener(this.\u00f3);
        this.box.removeDataBoxListener(this.\u00f4);
        this.box.removeDataBoxSequenceListener(this.\u00f1);
        this.box.removeElementPropertyChangeListener(this.\u00f0);
    }

    private void A(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        this.visibleFilters.add(D.C);
        this.setDataBox(box);
        if (backgroundColor == null) {
            this.setBackgroundColor(Color.WHITE);
        } else {
            this.setBackgroundColor(backgroundColor);
        }
        if (foregroundColor == null) {
            this.setForegroundColor(Color.BLACK);
        } else {
            this.setForegroundColor(foregroundColor);
        }
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new IllegalArgumentException("DataBox must be non null");
        }
        if (this.box != null) {
            this.I();
        }
        this.box = box;
        this.J();
        this.publishData();
    }

    public void publishData() {
        this.publishedElements.clear();
        Enumeration e2 = this.box.breadthFirstEnumeration();
        while (e2.hasMoreElements()) {
            Element element = (Element)e2.nextElement();
            if (!this.isVisible(element)) continue;
            this.publishedElements.add(element);
        }
        if (this.sortComparator != null) {
            Collections.sort(this.publishedElements, this.sortComparator);
        }
        this.calculate();
    }

    public boolean isVisible(Element element) {
        if (!this.box.contains(element)) {
            return false;
        }
        Iterator it = this.visibleFilters.iterator();
        while (it.hasNext()) {
            VisibleFilter filter = (VisibleFilter)it.next();
            if (filter.isVisible(element)) continue;
            return false;
        }
        return true;
    }

    protected String getGradientID(SVGContext context, int type, Color gradientColor, Color fillColor) {
        String id = WebUtil.getGradientID(type, gradientColor, fillColor);
        if (id != null) {
            context.registerGradientID(id);
        }
        return id;
    }

    public TDataBox getDataBox() {
        return this.box;
    }

    public Color getColor(Element element) {
        return element.getChartColor();
    }

    protected Color getGradientColor(Element element) {
        return this.gradientColor;
    }

    protected String getFormatedText(Element element, double value) {
        return this.getFormatedText(element, value, -1);
    }

    protected String getFormatedText(Element element, double value, int index) {
        NumberFormat format = this.getFormat(element);
        String ret = format.format(value);
        if (this.unit != null) {
            ret = ret + this.unit;
        }
        return ret;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public NumberFormat getFormat(Element element) {
        NumberFormat format = (NumberFormat)element.getClientProperty("chart.format");
        if (format != null) {
            return format;
        }
        if (this.format != null) {
            return this.format;
        }
        return TUIManager.getNumberFormat("chart.format");
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public String getSVGXMLNS() {
        return this.svgXMLNS;
    }

    public void setSVGXMLNS(String svgXMLNS) {
        this.svgXMLNS = svgXMLNS;
    }

    public boolean isEnableZoomAndPan() {
        return this.enableZoomAndPan;
    }

    public void setEnableZoomAndPan(boolean enableZoomAndPan) {
        this.enableZoomAndPan = enableZoomAndPan;
    }

    public List getValues(Element element) {
        return element.getChartValues();
    }

    Dimension A(String text, Font font) {
        return this.A(1, text, font);
    }

    Dimension A(int orientation, String text, Font font) {
        JLabel label = RotatableLabel.getLabelRenderer(orientation);
        label.setFont(font);
        label.setText(text);
        return label.getPreferredSize();
    }

    protected StringBuffer insertSVGHeadBefore(SVGContext context, StringBuffer result, int width, int height) {
        StringBuffer out = new StringBuffer();
        I.B(context, out);
        out.append("<svg boxid='").append(this.getDataBox().getID()).append("' width='").append(width).append("' height='").append(height).append("' ").append(this.svgXMLNS);
        I.A(context, out);
        if (!this.enableZoomAndPan) {
            out.append(" zoomAndPan='disable'");
        }
        out.append(">");
        this.appendSVGPreDefine(context, out);
        out.append(result);
        return out;
    }

    protected void appendSVGPreDefine(SVGContext context, StringBuffer result) {
        context.appendGradientDefinitionSVG(result);
    }

    protected void appendSVGBackground(SVGContext context, StringBuffer result) {
        this.paintBackground(context, result);
    }

    protected void paintBackground(SVGContext context, StringBuffer result) {
        if (this.backgroundVisible) {
            if (this.backgroundFillColor != null) {
                if (this.backgroundGradient) {
                    String gradientID = this.getGradientID(context, this.backgroundGradientFactory, this.backgroundGradientColor, this.backgroundFillColor);
                    I.A(context, result, this.backgroundBounds, gradientID);
                } else {
                    I.A(context, result, this.backgroundBounds, this.backgroundFillColor);
                }
            }
            if (this.backgroundOutlineColor != null && this.backgroundStroke != null) {
                I.A(context, result, (Shape)this.backgroundBounds, this.backgroundOutlineColor, TUIManager.getStrokeByType(this.backgroundStroke));
            }
        }
    }

    protected void paintLegend(SVGContext context, StringBuffer result, int width, int height) {
        int legendSize;
        int size = this.publishedElements.size();
        int maxHeight = legendSize = this.getLegendSize();
        int maxWidth = legendSize;
        for (int i2 = 0; i2 < size; ++i2) {
            Element element = (Element)this.publishedElements.get(i2);
            Dimension dim = this.A(this.getLegendLabel(element), this.legendFont);
            if (dim.width > maxWidth) {
                maxWidth = dim.width;
            }
            if (dim.height <= maxHeight) continue;
            maxHeight = dim.height;
        }
        if (this.legendPosition == 5) {
            double startGap;
            int colHeight = this.\u00f5;
            int col = 1;
            int colCount = 0;
            for (int i3 = 0; i3 < size; ++i3) {
                if ((colHeight += maxHeight) + this.\u00f5 > height) {
                    colCount = i3;
                    if (colCount == 0) {
                        colCount = 1;
                    }
                    col = size / colCount;
                    if (size % colCount == 0) break;
                    ++col;
                    break;
                }
                colHeight += this.\u00ef;
            }
            double offset = col * (maxWidth + legendSize + this.\u00f2) + (col - 1) * this.\u00ee + this.\u00f5 * 2;
            if (colCount == 0) {
                colCount = size;
            }
            double x = (double)width - offset + (double)this.\u00f5;
            double useHeight = colCount * maxHeight + (colCount - 1) * this.\u00ef;
            double startPostion = startGap = (double)height / 2.0 - useHeight / 2.0;
            for (int i4 = 0; i4 < size; ++i4) {
                Element element = (Element)this.publishedElements.get(i4);
                int colIndex = i4 / colCount;
                double xPositon = x + (double)(colIndex * (legendSize + maxWidth + this.\u00f2)) + (double)(this.\u00ee * colIndex);
                Rectangle2D.Double rect = new Rectangle2D.Double(xPositon, startPostion + (double)(maxHeight - legendSize) / 2.0, legendSize, legendSize);
                I.A(context, result, rect, this.getColor(element));
                I.A(context, result, this.getLegendLabel(element), this.getColor(element), this.legendFont, (int)(xPositon + (double)legendSize + (double)this.\u00f2), (int)(startPostion + (double)maxHeight / 2.0), 5);
                startPostion += (double)(maxHeight + this.\u00ef);
                if ((i4 + 1) % colCount != 0) continue;
                startPostion = startGap;
            }
        } else {
            double startGap;
            int rowWidth = this.\u00f5;
            int row = 1;
            int rowCount = 0;
            for (int i5 = 0; i5 < size; ++i5) {
                if ((rowWidth += maxWidth + legendSize + this.\u00f2) + this.\u00f5 > width) {
                    rowCount = i5;
                    if (rowCount == 0) {
                        rowCount = 1;
                    }
                    row = size / rowCount;
                    if (size % rowCount == 0) break;
                    ++row;
                    break;
                }
                rowWidth += this.\u00ee;
            }
            if (rowCount == 0) {
                rowCount = size;
            }
            double y = height - row * maxHeight - this.\u00f5 * 2 - (row - 1) * this.\u00ef;
            double useWidth = rowCount * (maxWidth + legendSize + this.\u00f2) + (rowCount - 1) * this.\u00ee;
            double startPostion = startGap = ((double)width - useWidth) / 2.0;
            for (int i6 = 0; i6 < size; ++i6) {
                Element element = (Element)this.publishedElements.get(i6);
                int rowIndex = i6 / rowCount;
                double ypostion = y + (double)this.\u00f5 + (double)(rowIndex * maxHeight) + (double)(this.\u00ef * rowIndex);
                Rectangle2D.Double rect = new Rectangle2D.Double(startPostion, ypostion + (double)((maxHeight - legendSize) / 2), legendSize, legendSize);
                I.A(context, result, rect, this.getColor(element));
                I.A(context, result, this.getLegendLabel(element), this.getColor(element), this.legendFont, (int)(startPostion + (double)legendSize + (double)this.\u00f2), (int)(ypostion + (double)maxHeight / 2.0), 5);
                startPostion += (double)(maxWidth + legendSize + this.\u00f2 + this.\u00ee);
                if ((i6 + 1) % rowCount != 0) continue;
                startPostion = startGap;
            }
        }
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public int getXGap() {
        return this.xGap;
    }

    public void setXGap(int gap) {
        this.xGap = gap;
    }

    public int getYGap() {
        return this.yGap;
    }

    public void setYGap(int gap) {
        this.yGap = gap;
    }

    public boolean isValueTextVisible() {
        return this.valueTextVisible;
    }

    public void setValueTextVisible(boolean valueTextVisible) {
        this.valueTextVisible = valueTextVisible;
    }

    public Font getValueTextFont() {
        return this.valueTextFont;
    }

    public void setValueTextFont(Font valueTextFont) {
        this.valueTextFont = valueTextFont;
    }

    public int getTextGap() {
        return this.textGap;
    }

    public void setTextGap(int textGap) {
        this.textGap = textGap;
    }

    public Stroke getStroke(Element element) {
        String value = (String)element.getClientProperty("chart.stroke");
        if (value != null) {
            return TUIManager.getStrokeByType(value);
        }
        if (this.stroke != null) {
            return TUIManager.getStrokeByType(this.stroke);
        }
        return TUIManager.getStrokeByType(TUIManager.getString("chart.stroke"));
    }

    public String getStroke() {
        return this.stroke;
    }

    public void setStroke(String stroke) {
        this.stroke = stroke;
    }

    public double getValue(Element element) {
        return element.getChartValue();
    }

    public int getShadowOffset() {
        return this.shadowOffset;
    }

    public void setShadowOffset(int shadowOffset) {
        this.shadowOffset = shadowOffset;
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public void setGradient(boolean gradient) {
        this.gradient = gradient;
    }

    public double getMax(Element element) {
        return element.getChartMax();
    }

    public double getMin(Element element) {
        return element.getChartMin();
    }

    public String getLegendLabel(Element element) {
        return element.getName();
    }

    public int getSelectedOffset() {
        return this.selectedOffset;
    }

    public void setSelectedOffset(int selectedOffset) {
        this.selectedOffset = selectedOffset;
    }

    protected void appendElementAttributesSVG(StringBuffer result, Element element) {
        result.append(" id='").append(element.getID()).append("' ");
    }

    protected void appendElementSelectionAttribute(StringBuffer result) {
        result.append("selectstroke='2'");
    }

    public String toSVG(SVGContext context, int width, int height) {
        StringBuffer result;
        if (width <= 0 || height <= 0) {
            Dimension size = (Dimension)TUIManager.get("web.default.chart.size");
            if (width <= 0) {
                width = size.width;
            }
            if (height <= 0) {
                height = size.height;
            }
        }
        this.publishData();
        int size = this.publishedElements.size();
        if (!this.legendVisible || size == 0) {
            result = this.toSVGContent(context, width, height);
        } else {
            int legendSize;
            int maxHeight = legendSize = this.getLegendSize();
            int maxWidth = legendSize;
            for (int i2 = 0; i2 < size; ++i2) {
                Element element = (Element)this.publishedElements.get(i2);
                Dimension dim = this.A(this.getLegendLabel(element), this.legendFont);
                if (dim.height > maxHeight) {
                    maxHeight = dim.height;
                }
                if (dim.width <= maxWidth) continue;
                maxWidth = dim.width;
            }
            if (this.legendPosition == 5) {
                int colHeight = this.\u00f5;
                int col = 1;
                int colCount = 0;
                for (int i3 = 0; i3 < size; ++i3) {
                    if ((colHeight += maxHeight) + this.\u00f5 > height) {
                        colCount = i3;
                        if (colCount == 0) {
                            colCount = 1;
                        }
                        col = size / colCount;
                        if (size % colCount == 0) break;
                        ++col;
                        break;
                    }
                    colHeight += this.\u00ef;
                }
                int offset = col * (maxWidth + legendSize + this.\u00f2) + (col - 1) * this.\u00ee + this.\u00f5 * 2;
                result = this.toSVGContent(context, width - offset, height);
            } else {
                int rowWidth = this.\u00f5;
                int row = 1;
                int rowCount = 0;
                for (int i4 = 0; i4 < size; ++i4) {
                    if ((rowWidth += maxWidth + legendSize + this.\u00f2) + this.\u00f5 > width) {
                        rowCount = i4;
                        if (rowCount == 0) {
                            rowCount = 1;
                        }
                        row = size / rowCount;
                        if (size % rowCount == 0) break;
                        ++row;
                        break;
                    }
                    rowWidth += this.\u00ee;
                }
                result = this.toSVGContent(context, width, height - maxHeight * row - (row - 1) * this.\u00ee - this.\u00f5 * 2);
            }
            this.paintLegend(context, result, width, height);
        }
        result = this.insertSVGHeadBefore(context, result, width, height);
        result.append("</svg>");
        return result.toString();
    }

    public abstract StringBuffer toSVGContent(SVGContext var1, int var2, int var3);

    protected abstract void calculate();

    public float getBackgroundFillOpacity() {
        return this.backgroundFillOpacity;
    }

    public void setBackgroundFillOpacity(float backgroundFillOpacity) {
        this.backgroundFillOpacity = backgroundFillOpacity;
    }

    public Comparator getSortComparator() {
        return this.sortComparator;
    }

    public void setSortComparator(Comparator sortComparator) {
        this.sortComparator = sortComparator;
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null && !this.visibleFilters.contains(visibleFilter)) {
            this.visibleFilters.add(visibleFilter);
        }
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null) {
            this.visibleFilters.remove(visibleFilter);
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isValueTextCenter() {
        return this.valueTextCenter;
    }

    public void setValueTextCenter(boolean valueTextCenter) {
        this.valueTextCenter = valueTextCenter;
    }

    public Color getValueTextColor() {
        return this.valueTextColor;
    }

    public void setValueTextColor(Color valueTextColor) {
        this.valueTextColor = valueTextColor;
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public Stroke getSelectedStroke(Element element) {
        if (this.selectedStroke == null) {
            return TWaverConst.DOUBLE_WIDTH_STROKE;
        }
        return TUIManager.getStrokeByType(this.selectedStroke);
    }

    public Color getSelectedColor(Element element) {
        if (this.selectedColor == null) {
            return this.getColor(element).darker();
        }
        return this.selectedColor;
    }

    public int getValueTextPosition() {
        return this.valueTextPosition;
    }

    public void setValueTextPosition(int valueTextPosition) {
        this.valueTextPosition = valueTextPosition;
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean backgroundVisible) {
        this.backgroundVisible = backgroundVisible;
    }

    public Color getBackgroundFillColor() {
        return this.backgroundFillColor;
    }

    public void setBackgroundFillColor(Color backgroundFillColor) {
        this.backgroundFillColor = backgroundFillColor;
    }

    public Color getBackgroundOutlineColor() {
        return this.backgroundOutlineColor;
    }

    public void setBackgroundOutlineColor(Color backgroundOutlineColor) {
        this.backgroundOutlineColor = backgroundOutlineColor;
    }

    public String getBackgroundStroke() {
        return this.backgroundStroke;
    }

    public void setBackgroundStroke(String backgroundStroke) {
        this.backgroundStroke = backgroundStroke;
    }

    public boolean isBackgroundGradient() {
        return this.backgroundGradient;
    }

    public void setBackgroundGradient(boolean backgroundGradient) {
        this.backgroundGradient = backgroundGradient;
    }

    public Color getBackgroundGradientColor() {
        return this.backgroundGradientColor;
    }

    public void setBackgroundGradientColor(Color backgroundGradientColor) {
        this.backgroundGradientColor = backgroundGradientColor;
    }

    public int getBackgroundGradientFactory() {
        return this.backgroundGradientFactory;
    }

    public void setBackgroundGradientFactory(int backgroundGradientFactory) {
        this.backgroundGradientFactory = backgroundGradientFactory;
    }

    public Rectangle getBackgroundBounds() {
        return this.backgroundBounds;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public int getLegendSize() {
        return this.legendFont.getSize();
    }

    public void setLegendSize(int legendSize) {
        this.setLegendFont(this.legendFont.deriveFont(legendSize));
        this.legendSize = legendSize;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public void updateTViewUI() {
    }

    public String getType() {
        return this.\u00f6;
    }

    public void setType(String type) {
        this.\u00f6 = type;
    }
}

