/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import twaver.ElementAttribute;
import twaver.TUIManager;
import twaver.base.A.E.H;

public class CellEditorManager {
    protected Map registry = new HashMap();
    protected Map typeToEditorCache = new HashMap();
    protected Map attributeToEditorCache = new HashMap();

    public void registerEditor(Class propertyType, Class editorClass) {
        if (editorClass == null) {
            this.registerEditor(propertyType, (String)null);
        } else {
            this.registerEditor(propertyType, editorClass.getName());
        }
    }

    public void registerEditor(Class propertyType, String editorClass) {
        if (editorClass == null) {
            this.registry.remove(propertyType);
        } else {
            this.registry.put(propertyType, editorClass);
        }
        this.typeToEditorCache.remove(propertyType);
    }

    public void clearCache() {
        this.typeToEditorCache.clear();
        this.attributeToEditorCache.clear();
    }

    public TableCellEditor findEditor(ElementAttribute attribute, Object cellValue) {
        TableCellEditor editor = (TableCellEditor)this.attributeToEditorCache.get(attribute);
        if (editor == null && attribute != null) {
            editor = attribute.getEditor();
            if (editor == null && attribute.getJavaClass() != null) {
                editor = this.findEditor(attribute.getJavaClass());
            }
            if (editor != null) {
                this.attributeToEditorCache.put(attribute, editor);
            }
        }
        if (editor == null && cellValue != null) {
            editor = this.findEditor(cellValue.getClass());
        }
        return editor;
    }

    public TableCellEditor findEditor(Class propertyType) {
        TableCellEditor editor = (TableCellEditor)this.typeToEditorCache.get(propertyType);
        if (editor != null) {
            return editor;
        }
        String editorClass = (String)this.registry.get(propertyType);
        if (editorClass == null) {
            editorClass = TUIManager.getTableCellEditor(propertyType);
        }
        if (editorClass != null) {
            editor = (TableCellEditor)H.B(editorClass);
            this.typeToEditorCache.put(propertyType, editor);
        }
        return editor;
    }
}

