/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import twaver.Alarm;
import twaver.Element;
import twaver.TWaverUtil;
import twaver.table.AbstractPageTableModel;
import twaver.table.PageListener;
import twaver.table.TAlarmTable;
import twaver.table.TElementTable;
import twaver.table.TTable;
import twaver.table.TTableColumn;
import twaver.table.TTableListener;
import twaver.table.TTableModelEvent;
import twaver.table.TTableRowFilter;

public class TTableModel
extends AbstractPageTableModel
implements PropertyChangeListener {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = -1;
    protected static int currentSortColumnIndex;
    protected static TTableColumn currentSortColumn;
    private int B = 0;
    protected boolean isEditable = true;
    protected boolean locked = false;
    protected boolean isAdjusting = false;
    protected boolean isInitingColumn = false;
    protected List selectedRows = new ArrayList();
    protected List tableListeners = new ArrayList();
    protected TTable table;
    protected Vector rawData = new Vector(30);
    protected Vector publishedData = new Vector(30);
    protected List rawColumn = new ArrayList();
    protected List publishedColumn = new ArrayList();
    protected Map publishedColumnMap = new HashMap();
    protected List rowFilters = new ArrayList();
    protected List sortColumnList = new ArrayList();
    protected Map rawColumnIndexMap = new HashMap();
    protected TTableColumn oidColumn = null;
    protected TTableColumn checkColumn = null;
    protected Map rawColumnMap = new HashMap(){

        public Object put(Object columnName, Object column) {
            if (this.containsKey(columnName)) {
                throw new IllegalArgumentException("column with name '" + columnName + "' already exists.");
            }
            return super.put(columnName, column);
        }
    };
    private Map C = new HashMap();
    protected static final Comparator ROWDATA_COMPARATOR;
    static /* synthetic */ Class class$twaver$table$TTableColumn;

    protected TTableModel(TTable table) {
        this.table = table;
        this.pageRowSize = Integer.MAX_VALUE;
        this.addPageListener(new PageListener(){

            public void pageChanged() {
                TTableModel.this.updateSelectedRows();
                for (int i2 = 0; i2 < TTableModel.this.tableListeners.size(); ++i2) {
                    ((TTableListener)TTableModel.this.tableListeners.get(i2)).pageChanged();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (!TTableModel.this.isAdjusting) {
                    TTableModel.this.fireRowSelectionChanged(e2.getValueIsAdjusting());
                }
            }
        });
        this.createPredefindedColumn();
        this.initColumnIndexMap();
    }

    public void addTableListener(TTableListener l2) {
        if (!this.tableListeners.contains(l2)) {
            this.tableListeners.add(l2);
        }
    }

    public void removeTableListener(TTableListener l2) {
        this.tableListeners.remove(l2);
    }

    private static Object A(Object rowData) {
        if (rowData instanceof Vector) {
            return ((Vector)rowData).get(currentSortColumnIndex);
        }
        return null;
    }

    protected void createPredefindedColumn() {
        this.oidColumn = new TTableColumn("table.column.oid", TWaverUtil.getString("table.column.oid"), 40).setJavaClass(Integer.class).setVisible(false);
        this.oidColumn.addPropertyChangeListener(this);
        this.rawColumn.add(this.oidColumn);
        this.rawColumnMap.put(this.oidColumn.getName(), this.oidColumn);
        this.fireColumnAdded(this.oidColumn);
        this.checkColumn = new TTableColumn("table.column.check", TWaverUtil.getString("table.column.check"), 40).setJavaClass(Boolean.class).setEditable(true).setVisible(false);
        this.checkColumn.addPropertyChangeListener(this);
        this.rawColumn.add(this.checkColumn);
        this.rawColumnMap.put(this.checkColumn.getName(), this.checkColumn);
        this.fireColumnAdded(this.checkColumn);
    }

    protected void initColumnIndexMap() {
        this.rawColumnIndexMap.clear();
        for (int i2 = 0; i2 < this.rawColumn.size(); ++i2) {
            TTableColumn tableColumn = (TTableColumn)this.rawColumn.get(i2);
            this.rawColumnIndexMap.put(tableColumn.getName(), TWaverUtil.valueOf(i2));
        }
    }

    protected void fireCellUpdate(Vector rowData, int columnIndex, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        TTableModelEvent event = new TTableModelEvent(this, rowData, oldValue, newValue, columnIndex);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireRowDataAdded(Vector rowData) {
        TTableModelEvent event = new TTableModelEvent(this, 0, rowData);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireRowDataRemoved(Vector rowData) {
        TTableModelEvent event = new TTableModelEvent(this, 1, rowData);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireColumnRemoved(TTableColumn tableColumn) {
        TTableModelEvent event = new TTableModelEvent(this, 5, tableColumn);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireColumnSorted(TTableColumn tableColumn, boolean multiColumnSort) {
        TTableModelEvent event = new TTableModelEvent(this, 6, tableColumn, multiColumnSort);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireColumnAdded(TTableColumn tableColumn) {
        TTableModelEvent event = new TTableModelEvent(this, 4, tableColumn);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireTableDataCleared() {
        TTableModelEvent event = new TTableModelEvent(this, 2);
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).tableDataChanged(event);
        }
    }

    protected void fireLockedChanged() {
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).lockedChanged();
        }
    }

    public void fireRowClicked(int clickCount, int rowIndex, int columnIndex) {
        if (columnIndex < 0 || rowIndex < 0) {
            return;
        }
        if ((rowIndex += this.getFirstRowIndex()) <= this.getLastRowIndex()) {
            for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
                ((TTableListener)this.tableListeners.get(i2)).rowClicked(clickCount, (Vector)this.publishedData.get(rowIndex), columnIndex);
            }
        }
    }

    protected void fireRowSelectionChanged(boolean isSelectionAdjusting) {
        int i2;
        this.selectedRows.clear();
        int[] rows = this.table.getSelectedRows();
        if (rows != null) {
            for (i2 = 0; i2 < rows.length; ++i2) {
                int index = this.getFirstRowIndex() + rows[i2];
                if (index < 0 || index >= this.publishedData.size()) continue;
                this.selectedRows.add(this.publishedData.get(index));
            }
        }
        for (i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            ((TTableListener)this.tableListeners.get(i2)).rowSelectionChanged(this.selectedRows, isSelectionAdjusting);
        }
    }

    public int getColumnCount() {
        return this.publishedColumn.size();
    }

    public int getRowCount() {
        if (this.publishedData.size() == 0) {
            return 0;
        }
        if (this.currentPageIndex == 1) {
            if (this.publishedData.size() > this.pageRowSize) {
                return this.pageRowSize;
            }
            return this.publishedData.size();
        }
        if (this.currentPageIndex == this.getPageTotalCount()) {
            return this.publishedData.size() - this.getFirstRowIndex();
        }
        return this.pageRowSize;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 || columnIndex < this.publishedColumn.size()) {
            TTableColumn column = (TTableColumn)this.publishedColumn.get(columnIndex);
            String displayName = column.getDisplayName();
            if (displayName == null) {
                displayName = TWaverUtil.getString("table.column." + column.getName());
            }
            return displayName;
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.isEditable()) {
            if (!this.table.isEditable(rowIndex)) {
                return false;
            }
            if (columnIndex >= 0 || columnIndex < this.publishedColumn.size()) {
                TTableColumn column = (TTableColumn)this.publishedColumn.get(columnIndex);
                return column.isEditable();
            }
        }
        return false;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if ((rowIndex += this.getFirstRowIndex()) >= this.publishedData.size() || rowIndex < 0) {
            return;
        }
        columnIndex = (Integer)this.publishedColumnMap.get(TWaverUtil.valueOf(columnIndex));
        Vector rowData = (Vector)this.publishedData.get(rowIndex);
        if (this.A(rowData, columnIndex, value)) {
            this.publishData();
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Vector rowData;
        if ((rowIndex += this.getFirstRowIndex()) >= this.publishedData.size() || rowIndex < 0) {
            return null;
        }
        if ((columnIndex = ((Integer)this.publishedColumnMap.get(TWaverUtil.valueOf(columnIndex))).intValue()) >= (rowData = (Vector)this.publishedData.get(rowIndex)).size() || columnIndex < 0) {
            return null;
        }
        return rowData.get(columnIndex);
    }

    protected void publishColumn() {
        this.publishedColumnMap.clear();
        this.publishedColumn.clear();
        for (int i2 = 0; i2 < this.rawColumn.size(); ++i2) {
            TTableColumn column = (TTableColumn)this.rawColumn.get(i2);
            if (!this.table.isVisible(column)) continue;
            this.publishedColumn.add(column);
            Integer key = TWaverUtil.valueOf(this.publishedColumn.size() - 1);
            Integer value = TWaverUtil.valueOf(i2);
            this.publishedColumnMap.put(key, value);
        }
    }

    void A() {
        this.isInitingColumn = true;
        TableColumnModel cm = this.table.getColumnModel();
        while (cm.getColumnCount() > 0) {
            cm.removeColumn(cm.getColumn(0));
        }
        for (int i2 = 0; i2 < this.publishedColumn.size(); ++i2) {
            TTableColumn column = (TTableColumn)this.publishedColumn.get(i2);
            column.setModelIndex(i2);
            this.table.addColumn(column);
        }
        this.isInitingColumn = false;
    }

    public void sortColumn(String columnName, int sortMode) {
        TTableColumn sortedColumn = this.getColumnByName(columnName);
        this.sortColumn(sortedColumn, sortMode, false);
    }

    public void sortColumn(String columnName, int sortMode, boolean multiColumnSort) {
        TTableColumn sortedColumn = this.getColumnByName(columnName);
        this.sortColumn(sortedColumn, sortMode, multiColumnSort);
    }

    public void sortColumn(TTableColumn sortedColumn, int sortMode, boolean multiColumnSort) {
        if (sortedColumn != null && (sortMode == 0 || sortMode == 1 || sortMode == -1)) {
            sortedColumn.setSortMode(sortMode);
            if (multiColumnSort) {
                if (sortedColumn.getSortMode() == 0) {
                    this.sortColumnList.remove(sortedColumn);
                } else if (!this.sortColumnList.contains(sortedColumn)) {
                    this.sortColumnList.add(sortedColumn);
                }
            } else {
                this.sortColumnList.clear();
                for (int i2 = 0; i2 < this.rawColumn.size(); ++i2) {
                    TTableColumn column = (TTableColumn)this.rawColumn.get(i2);
                    if (sortedColumn == column) continue;
                    column.setSortMode(0);
                }
                if (sortedColumn.getSortMode() != 0) {
                    this.sortColumnList.add(sortedColumn);
                }
            }
            if (this.table.getTableHeader() != null) {
                this.table.getTableHeader().repaint();
            }
            this.publishData();
            this.fireColumnSorted(sortedColumn, multiColumnSort);
        }
    }

    public void sortNoneColumn() {
        if (this.sortColumnList.size() > 0) {
            this.sortColumnList.clear();
            for (int i2 = 0; i2 < this.rawColumn.size(); ++i2) {
                TTableColumn column = (TTableColumn)this.rawColumn.get(i2);
                column.setSortMode(0);
            }
            if (this.table.getTableHeader() != null) {
                this.table.getTableHeader().repaint();
            }
            this.publishData();
            this.fireColumnSorted(null, false);
        }
    }

    public void sortColumn(int columnIndex, boolean multiColumnSort) {
        if (columnIndex < 0 || columnIndex >= this.publishedColumn.size()) {
            return;
        }
        TTableColumn currentClickColumn = (TTableColumn)this.publishedColumn.get(columnIndex);
        int sortMode = 0;
        if (this.table.isEnableTristateSorting()) {
            switch (currentClickColumn.getSortMode()) {
                case 0: {
                    sortMode = 1;
                    break;
                }
                case 1: {
                    sortMode = -1;
                    break;
                }
                case -1: {
                    sortMode = 0;
                }
            }
        } else {
            switch (currentClickColumn.getSortMode()) {
                case 0: {
                    sortMode = 1;
                    break;
                }
                case 1: {
                    sortMode = -1;
                    break;
                }
                case -1: {
                    sortMode = 1;
                }
            }
        }
        this.sortColumn(currentClickColumn, sortMode, multiColumnSort);
    }

    public void publishData() {
        if (!this.table.isPublishable()) {
            return;
        }
        this.publishedData.clear();
        if (this.rowFilters.size() > 0) {
            int count = this.rawData.size();
            for (int i2 = 0; i2 < count; ++i2) {
                Vector rowData = (Vector)this.rawData.get(i2);
                if (!this.isVisible(rowData)) continue;
                this.publishedData.add(rowData);
            }
        } else {
            this.publishedData.addAll(this.rawData);
        }
        if (this.table.isLocalSortable()) {
            List tops = this.table.filterTopRows(this.publishedData);
            List bottoms = this.table.filterBottomRows(this.publishedData);
            for (int i3 = this.sortColumnList.size() - 1; i3 >= 0; --i3) {
                TTableColumn column = (TTableColumn)this.sortColumnList.get(i3);
                if (column.getSortComparator() == null) continue;
                currentSortColumnIndex = this.rawColumn.indexOf(column);
                currentSortColumn = column;
                Collections.sort(this.publishedData, ROWDATA_COMPARATOR);
            }
            if (tops != null && tops.size() > 0) {
                this.publishedData.addAll(0, tops);
            }
            if (bottoms != null && bottoms.size() > 0) {
                this.publishedData.addAll(bottoms);
            }
        }
        currentSortColumnIndex = -1;
        currentSortColumn = null;
        this.resetPublishedDataMap();
        this.update();
    }

    protected void resetPublishedDataMap() {
        this.C.clear();
        for (int i2 = 0; i2 < this.publishedData.size(); ++i2) {
            Vector data = (Vector)this.publishedData.get(i2);
            this.C.put(data.get(0), TWaverUtil.valueOf(i2));
        }
    }

    public int getRowIndex(Vector rowData) {
        if (rowData == null || rowData.size() == 0) {
            return -1;
        }
        Integer row = (Integer)this.C.get(rowData.get(0));
        return row == null ? -1 : row;
    }

    private boolean A(Vector rowData) {
        return this.getRowIndex(rowData) >= 0;
    }

    public int getRowIndexAtPage(Vector rowData) {
        int rowIndex = this.getRowIndex(rowData);
        if (rowIndex >= 0) {
            return rowIndex % this.pageRowSize;
        }
        return -1;
    }

    public int getPageIndex(Vector rowData) {
        int rowIndex = this.getRowIndex(rowData);
        if (rowIndex >= 0) {
            int page = ++rowIndex / this.pageRowSize;
            if (rowIndex % this.pageRowSize > 0) {
                ++page;
            }
            if (page < 1) {
                page = 1;
            }
            return page;
        }
        return -1;
    }

    protected void updateSelectedRows() {
        this.isAdjusting = true;
        this.fireTableDataChanged();
        if (this.table.getCellEditor() != null) {
            Vector rowDataByAlarmID;
            Alarm currentEditingAlarm;
            int rowIndex = -1;
            if (this.table instanceof TElementTable) {
                Element currentEditingElement = ((TElementTable)this.table).getCurrentEditingElement();
                if (currentEditingElement != null) {
                    rowIndex = ((TElementTable)this.table).getRowIndex(currentEditingElement);
                }
            } else if (this.table instanceof TAlarmTable && (currentEditingAlarm = ((TAlarmTable)this.table).getCurrentEditingAlarm()) != null && (rowDataByAlarmID = ((TAlarmTable)this.table).getRowDataByAlarmID(currentEditingAlarm.getAlarmID())) != null) {
                rowIndex = this.getRowIndex(rowDataByAlarmID);
            }
            if (rowIndex > 0 && rowIndex >= this.getFirstRowIndex() && rowIndex <= this.getLastRowIndex() && this.table.getEditingRow() != (rowIndex -= this.getFirstRowIndex())) {
                this.table.setEditingRow(rowIndex);
            }
        }
        boolean selectedRowsChanage = false;
        for (int i2 = 0; i2 < this.selectedRows.size(); ++i2) {
            Vector rowData = (Vector)this.selectedRows.get(i2);
            int index = this.getRowIndex(rowData);
            if (index >= this.getFirstRowIndex() && index <= this.getLastRowIndex()) {
                int modelIndex = index - this.getFirstRowIndex();
                this.table.getSelectionModel().addSelectionInterval(modelIndex, modelIndex);
                continue;
            }
            if (this.selectedRows.size() == 1 && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            selectedRowsChanage = true;
        }
        this.isAdjusting = false;
        if (selectedRowsChanage) {
            this.fireRowSelectionChanged(false);
        }
    }

    public void setSelectedRows(List newSelectedRows) {
        if (newSelectedRows == null) {
            this.selectedRows.clear();
        }
        this.selectedRows = newSelectedRows;
        this.updateSelectedRows();
    }

    protected boolean isVisible(Vector rowData) {
        int count = this.rowFilters.size();
        for (int i2 = 0; i2 < count; ++i2) {
            TTableRowFilter filter = (TTableRowFilter)this.rowFilters.get(i2);
            if (filter.isVisible(this.table, rowData)) continue;
            return false;
        }
        return true;
    }

    public Vector getAllCheckedRowData() {
        Vector<Vector> selectedData = new Vector<Vector>();
        for (int i2 = 0; i2 < this.publishedData.size(); ++i2) {
            Vector rowData = (Vector)this.publishedData.get(i2);
            if (!Boolean.TRUE.equals(rowData.get(1))) continue;
            selectedData.add(rowData);
        }
        return selectedData;
    }

    public int getTotalRowCount() {
        return this.publishedData.size();
    }

    public void addRowFilter(TTableRowFilter rowFilter) {
        if (rowFilter == null) {
            throw new NullPointerException("rowFilter can not be null.");
        }
        if (!this.rowFilters.contains(rowFilter)) {
            this.rowFilters.add(rowFilter);
            this.publishData();
        }
    }

    public void removeRowFilter(TTableRowFilter rowFilter) {
        if (this.rowFilters.remove(rowFilter)) {
            this.publishData();
        }
    }

    public void clearRawData() {
        if (this.rawData.size() > 0) {
            this.rawData.clear();
            this.fireTableDataCleared();
            this.publishData();
        }
    }

    public void clearPublishedData() {
        if (this.publishedData.size() > 0) {
            ArrayList<Vector> fireList = new ArrayList<Vector>();
            Vector<Vector> newTableData = new Vector<Vector>(this.rawData.size() - this.publishedData.size());
            Iterator it = this.rawData.iterator();
            while (it.hasNext()) {
                Vector rowData = (Vector)it.next();
                if (this.A(rowData)) {
                    fireList.add(rowData);
                    continue;
                }
                newTableData.add(rowData);
            }
            this.rawData = newTableData;
            for (int i2 = 0; i2 < fireList.size(); ++i2) {
                this.fireRowDataRemoved((Vector)fireList.get(i2));
            }
            this.publishData();
        }
    }

    public void setTableRawData(Vector data) {
        int i2;
        this.rawData.clear();
        this.fireTableDataCleared();
        if (data == null) {
            return;
        }
        ArrayList<Vector<Boolean>> fireList = new ArrayList<Vector<Boolean>>();
        for (i2 = 0; i2 < data.size(); ++i2) {
            Vector<Boolean> rowData = (Vector<Boolean>)data.get(i2);
            if (rowData == null) {
                rowData = new Vector<Boolean>();
            }
            rowData.add(0, Boolean.FALSE);
            rowData.add(0, (Boolean)((Object)this.getNextOID()));
            this.rawData.add(rowData);
            fireList.add(rowData);
        }
        for (i2 = 0; i2 < fireList.size(); ++i2) {
            this.fireRowDataAdded((Vector)fireList.get(i2));
        }
        this.publishData();
    }

    public void addRow(Vector rowData) {
        if (rowData == null) {
            rowData = new Vector<Boolean>();
        }
        rowData.add(0, Boolean.FALSE);
        rowData.add(0, (Boolean)((Object)this.getNextOID()));
        this.rawData.add(rowData);
        this.fireRowDataAdded(rowData);
        this.publishData();
    }

    public void insertRow(int row, Vector rowData) {
        if (rowData == null) {
            rowData = new Vector<Boolean>();
        }
        rowData.add(0, Boolean.FALSE);
        rowData.add(0, (Boolean)((Object)this.getNextOID()));
        this.rawData.insertElementAt(rowData, row);
        this.fireRowDataAdded(rowData);
        this.publishData();
    }

    public void removeRow(int row) {
        Vector rowData = (Vector)this.rawData.remove(row);
        if (rowData != null) {
            this.fireRowDataRemoved(rowData);
            this.publishData();
        }
    }

    public void removeRow(Vector rowData) {
        if (this.rawData.remove(rowData)) {
            this.fireRowDataRemoved(rowData);
            this.publishData();
        }
    }

    public void removeRowByOID(Integer oid) {
        if (oid == null) {
            return;
        }
        ArrayList<Vector> fireList = new ArrayList<Vector>();
        Iterator it = this.rawData.iterator();
        while (it.hasNext()) {
            Vector rowData = (Vector)it.next();
            if (!rowData.get(0).equals(oid)) continue;
            it.remove();
            fireList.add(rowData);
            break;
        }
        if (fireList.size() > 0) {
            for (int i2 = 0; i2 < fireList.size(); ++i2) {
                this.fireRowDataRemoved((Vector)fireList.get(i2));
            }
            this.publishData();
        }
    }

    public void removeRowsByOID(List oidList) {
        if (oidList == null) {
            return;
        }
        HashMap map = new HashMap();
        for (int i2 = 0; i2 < oidList.size(); ++i2) {
            map.put(oidList.get(i2), null);
        }
        ArrayList<Vector> fireList = new ArrayList<Vector>();
        Iterator it = this.rawData.iterator();
        while (it.hasNext()) {
            Vector rowData = (Vector)it.next();
            Object oid = rowData.get(0);
            if (!map.containsKey(oid)) continue;
            it.remove();
            fireList.add(rowData);
            map.remove(oid);
        }
        map.clear();
        if (fireList.size() > 0) {
            for (int i3 = 0; i3 < fireList.size(); ++i3) {
                this.fireRowDataRemoved((Vector)fireList.get(i3));
            }
            this.publishData();
        }
    }

    public void removeCheckedRows() {
        Vector<Vector> newTableData = new Vector<Vector>(this.rawData.size());
        ArrayList<Vector> fireList = new ArrayList<Vector>();
        Iterator it = this.rawData.iterator();
        while (it.hasNext()) {
            Vector rowData = (Vector)it.next();
            if (this.A(rowData) && Boolean.TRUE.equals(rowData.get(1))) {
                fireList.add(rowData);
                continue;
            }
            newTableData.add(rowData);
        }
        this.rawData = newTableData;
        for (int i2 = 0; i2 < fireList.size(); ++i2) {
            this.fireRowDataRemoved((Vector)fireList.get(i2));
        }
        this.publishData();
    }

    public void removeSelectedRows() {
        if (this.selectedRows.size() == 0) {
            return;
        }
        HashMap map = new HashMap();
        for (int i2 = 0; i2 < this.selectedRows.size(); ++i2) {
            Vector rowData = (Vector)this.selectedRows.get(i2);
            map.put(rowData.get(0), null);
        }
        Vector<Vector> newTableData = new Vector<Vector>(this.rawData.size());
        ArrayList<Vector> fireList = new ArrayList<Vector>();
        Iterator it = this.rawData.iterator();
        while (it.hasNext()) {
            Vector rowData = (Vector)it.next();
            if (map.containsKey(rowData.get(0))) {
                fireList.add(rowData);
                map.remove(rowData.get(0));
                continue;
            }
            newTableData.add(rowData);
        }
        map.clear();
        this.selectedRows.clear();
        this.rawData = newTableData;
        for (int i3 = 0; i3 < fireList.size(); ++i3) {
            this.fireRowDataRemoved((Vector)fireList.get(i3));
        }
        this.publishData();
    }

    public void checkPublishedRows() {
        Iterator it = this.publishedData.iterator();
        while (it.hasNext()) {
            Vector rowData = (Vector)it.next();
            this.A(rowData, 1, Boolean.TRUE);
        }
        this.publishData();
    }

    public Vector getCurrentPageData() {
        Vector<Vector> data = new Vector<Vector>();
        for (int i2 = this.getFirstRowIndex(); i2 <= this.getLastRowIndex(); ++i2) {
            Vector rowData = (Vector)this.publishedData.get(i2);
            data.add(rowData);
        }
        return data;
    }

    public void checkCurrentPageRows() {
        for (int i2 = this.getFirstRowIndex(); i2 <= this.getLastRowIndex(); ++i2) {
            Vector rowData = (Vector)this.publishedData.get(i2);
            this.A(rowData, 1, Boolean.TRUE);
        }
        this.publishData();
    }

    public void checkSelectedRows() {
        if (this.selectedRows.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.selectedRows.size(); ++i2) {
            Vector rowData = (Vector)this.selectedRows.get(i2);
            this.A(rowData, 1, Boolean.TRUE);
        }
        this.publishData();
    }

    public void uncheckPublishedRows() {
        Iterator it = this.publishedData.iterator();
        while (it.hasNext()) {
            Vector rowData = (Vector)it.next();
            this.A(rowData, 1, Boolean.FALSE);
        }
        this.publishData();
    }

    public void uncheckCurrentPageRows() {
        for (int i2 = this.getFirstRowIndex(); i2 <= this.getLastRowIndex(); ++i2) {
            Vector rowData = (Vector)this.publishedData.get(i2);
            this.A(rowData, 1, Boolean.FALSE);
        }
        this.publishData();
    }

    public TTableColumn getPublishedColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.publishedColumn.size()) {
            return null;
        }
        return (TTableColumn)this.publishedColumn.get(columnIndex);
    }

    public void reset() {
        this.unlock();
        this.sortColumnList.clear();
        for (int i2 = 0; i2 < this.rawColumn.size(); ++i2) {
            TTableColumn column = (TTableColumn)this.rawColumn.get(i2);
            column.setSortMode(0);
        }
        this.publishColumn();
        this.fireTableStructureChanged();
        this.A();
        this.publishData();
    }

    public Vector getPublishedData() {
        return this.publishedData;
    }

    public Vector getRawData() {
        return this.rawData;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        if (!this.locked) {
            this.locked = true;
            this.fireLockedChanged();
        }
    }

    public void unlock() {
        if (this.locked) {
            this.locked = false;
            this.fireLockedChanged();
        }
    }

    public void unlockAndPublish() {
        this.unlock();
        this.publishData();
    }

    public List getSelectedRows() {
        return this.selectedRows;
    }

    boolean A(Vector rowData, int columnIndex, Object newValue) {
        Object oldValue = rowData.get(columnIndex);
        if (oldValue == newValue) {
            return false;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return false;
        }
        for (int i2 = 0; i2 < this.tableListeners.size(); ++i2) {
            TTableListener l2 = (TTableListener)this.tableListeners.get(i2);
            if (l2.beforeCellValueChanged(rowData, columnIndex, oldValue, newValue)) continue;
            return false;
        }
        rowData.set(columnIndex, newValue);
        this.fireCellUpdate(rowData, columnIndex, oldValue, newValue);
        return true;
    }

    public void addColumn(TableColumn column) {
        if (!(column instanceof TTableColumn)) {
            throw new IllegalArgumentException("only twaver.table.TTableColumn instance can be added");
        }
        if (!this.rawColumn.contains(column)) {
            this.rawColumn.add(column);
            this.rawColumnMap.put(((TTableColumn)column).getName(), column);
            this.initColumnIndexMap();
            this.fireColumnAdded((TTableColumn)column);
            column.addPropertyChangeListener(this);
            this.reset();
        }
    }

    public void removeColumn(TableColumn column) {
        if (this.rawColumn.contains(column) && !this.table.isPredefinedColumn((TTableColumn)column)) {
            this.rawColumn.remove(column);
            this.rawColumnMap.remove(((TTableColumn)column).getName());
            this.initColumnIndexMap();
            this.fireColumnRemoved((TTableColumn)column);
            column.removePropertyChangeListener(this);
            this.reset();
        }
    }

    public void removeColumnByName(String columnName) {
        this.removeColumn(this.getColumnByName(columnName));
    }

    public void clearAllColumns() {
        TTableColumn column;
        int i2;
        if (this.rawColumn.size() == 0) {
            return;
        }
        ArrayList<TTableColumn> list = new ArrayList<TTableColumn>();
        for (i2 = 0; i2 < this.rawColumn.size(); ++i2) {
            column = (TTableColumn)this.rawColumn.get(i2);
            if (this.table.isPredefinedColumn(column)) continue;
            list.add(column);
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            column = (TTableColumn)list.get(i2);
            this.rawColumn.remove(column);
            this.rawColumnMap.remove(column.getName());
            this.fireColumnRemoved(column);
            column.removePropertyChangeListener(this);
        }
        this.initColumnIndexMap();
        this.reset();
    }

    public void addColumns(List columnList) {
        int i2;
        for (i2 = 0; i2 < columnList.size(); ++i2) {
            if ((class$twaver$table$TTableColumn == null ? TTableModel.class$("twaver.table.TTableColumn") : class$twaver$table$TTableColumn).isInstance(columnList.get(i2))) continue;
            throw new IllegalArgumentException("only twaver.table.TTableColumn instance can be added");
        }
        this.rawColumn.addAll(columnList);
        for (i2 = 0; i2 < columnList.size(); ++i2) {
            TTableColumn column = (TTableColumn)columnList.get(i2);
            this.rawColumnMap.put(column.getName(), column);
            ((TableColumn)column).addPropertyChangeListener(this);
        }
        this.initColumnIndexMap();
        this.fireColumnAdded(null);
        this.reset();
    }

    public boolean isInitingColumn() {
        return this.isInitingColumn;
    }

    public List getRawColumn() {
        return this.rawColumn;
    }

    public List getPublishedColumn() {
        return this.publishedColumn;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("displayName".equals(propertyName) && this.table.getTableHeader() != null) {
            this.table.getTableHeader().repaint();
        } else if ("visible".equals(propertyName)) {
            this.reset();
        } else if ("sortComparator".equals(propertyName) || "editable".equals(propertyName) || "javaClass".equals(propertyName) || "cellEditor".equals(propertyName) || "cellRenderer".equals(propertyName)) {
            this.publishData();
        }
    }

    public TTableColumn getColumnByName(String name) {
        if (name == null) {
            return null;
        }
        TTableColumn column = (TTableColumn)this.rawColumnMap.get(name);
        if (column == null && !name.startsWith("CP:")) {
            column = (TTableColumn)this.rawColumnMap.get("CP:" + name);
        }
        if (column == null && !name.startsWith("UP:")) {
            column = (TTableColumn)this.rawColumnMap.get("UP:" + name);
        }
        if (column == null && !name.startsWith("BOJP:")) {
            column = (TTableColumn)this.rawColumnMap.get("BOJP:" + name);
        }
        if (column == null && !name.startsWith("BOCP:")) {
            column = (TTableColumn)this.rawColumnMap.get("BOCP:" + name);
        }
        return column;
    }

    public int getRawColumnIndexByName(String columnName) {
        Integer value = (Integer)this.rawColumnIndexMap.get(columnName);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public TTableColumn getOIDColumn() {
        return this.oidColumn;
    }

    public TTableColumn getCheckColumn() {
        return this.checkColumn;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.table.repaint();
    }

    public List getSortColumnList() {
        return this.sortColumnList;
    }

    public TTable getTable() {
        return this.table;
    }

    protected Integer getNextOID() {
        return TWaverUtil.valueOf(++this.B);
    }

    protected int getCurrentOID() {
        return this.B;
    }

    static {
        ROWDATA_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                Comparator comparator = currentSortColumn.getSortComparator();
                int sortMode = currentSortColumn.getSortMode();
                return comparator.compare(TTableModel.A(o1), TTableModel.A(o2)) * sortMode;
            }
        };
    }
}

