/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.gadget.inputhandler;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import twaver.A.A.A.A;
import twaver.GeoCoordinate;
import twaver.TWaverConst;
import twaver.gis.GeographyMap;
import twaver.gis.GisBackground;
import twaver.gis.GisManager;
import twaver.gis.event.MapEvent;
import twaver.gis.event.MapListener;
import twaver.gis.utils.GisToolkits;
import twaver.network.CanvasMarker;
import twaver.network.InteractionMode;
import twaver.network.TNetwork;
import twaver.network.background.Background;
import twaver.network.inputhandler.InputAdapter;
import twaver.network.inputhandler.InputHandler;

public class DistanceInputHandler
extends InputAdapter
implements CanvasMarker {
    private ArrayList D = new ArrayList();
    private TNetwork C;
    private Point2D B;
    private Rectangle A;
    private GeographyMap E;
    private MapListener F;

    public DistanceInputHandler(TNetwork network, GeographyMap map) {
        this.A(network, map);
    }

    private void A(TNetwork network, GeographyMap map) {
        this.C = network;
        this.C.addCanvasMarker((CanvasMarker)this);
        this.E = map;
        if (map != null) {
            map.setMapMode(5);
            this.F = new MapListener(){

                public void mapChanged(MapEvent evt) {
                    if (5 == evt.getEventType()) {
                        DistanceInputHandler.this.E.removeMapListener(DistanceInputHandler.this.F);
                        DistanceInputHandler.this.clear();
                        DistanceInputHandler.this.C.removeCanvasMarker((CanvasMarker)DistanceInputHandler.this);
                    }
                }
            };
            map.addMapListener(this.F);
            this.A();
        }
    }

    public DistanceInputHandler(TNetwork network) {
        Background bk = network.getCurrentBackground();
        if (bk instanceof GisBackground) {
            this.E = ((GisBackground)bk).getMap();
            this.A(network, this.E);
        }
    }

    private void A() {
        MapListener listener = new MapListener(){

            public void mapChanged(MapEvent evt) {
                InteractionMode actionMode;
                if (5 == evt.getEventType() && evt.getMap().getMapMode() != 5 && (actionMode = DistanceInputHandler.this.C.getInteractionMode()) != null) {
                    InputHandler[] handlers = actionMode.getHandlers();
                    int i = 0;
                    while (i < handlers.length) {
                        if (handlers[i] instanceof DistanceInputHandler) {
                            ((DistanceInputHandler)handlers[i]).clear();
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
        if (this.E != null) {
            this.E.addMapListener(listener);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int count = e.getClickCount();
        if (count == 1) {
            Point point = e.getPoint();
            GeoCoordinate coordinate = GisToolkits.convertScreenToLatLong(this.E, e.getPoint());
            if (coordinate != null) {
                double longitude = coordinate.getLongitude();
                double latitude = coordinate.getLatitude();
                if (longitude <= 180.0 && longitude >= -180.0 && latitude <= 90.0 && latitude >= -90.0) {
                    this.D.add(point);
                }
            }
        } else if (count == 2) {
            this.D.clear();
            this.B();
        }
    }

    private void B() {
        this.C.getRenderer().repaintPhysicalBounds(this.A);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.D.isEmpty()) {
            this.B = e.getPoint();
            this.A = twaver.A.A.A.A.A(this.D);
            if (this.A != null) {
                this.A.add(this.B);
            }
            this.B();
        }
    }

    public void mark(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(TWaverConst.DASHED_STROKE);
        Color oldColor = g.getColor();
        Object color = GisManager.getDefaultSetting("distance.mark.color");
        if (color instanceof Color) {
            g.setColor((Color)color);
        } else {
            g.setColor(Color.WHITE);
        }
        if (!this.D.isEmpty()) {
            Object[] points = this.D.toArray();
            int i = 0;
            while (i < points.length - 1) {
                Point2D start = (Point2D)points[i];
                Point2D end = (Point2D)points[i + 1];
                g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
                ++i;
            }
            Point2D last = (Point2D)points[points.length - 1];
            if (this.B != null) {
                g.drawLine((int)last.getX(), (int)last.getY(), (int)this.B.getX(), (int)this.B.getY());
            }
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public void clear() {
        this.D.clear();
        this.B();
    }
}

