/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFileSystemTreeCellRenderer;
import com.jidesoft.plaf.basic.BasicFileSystemTreeModel;
import com.jidesoft.plaf.basic.BasicFileSystemTreeNode;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TreeSearchable;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

class BasicFileSystemTree
extends JTree {
    public BasicFileSystemTree(FolderChooser folderChooser) {
        super(new BasicFileSystemTreeModel(folderChooser));
        this.initComponents();
    }

    protected void initComponents() {
        this.setCellRenderer(new BasicFileSystemTreeCellRenderer());
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.setRowHeight(JideSwingUtilities.getLineHeight(this, 17));
        this.expandRow(0);
        FolderTreeListener folderTreeListener = new FolderTreeListener();
        this.addTreeWillExpandListener(folderTreeListener);
        this.addTreeExpansionListener(folderTreeListener);
        new TreeSearchable(this){

            protected String convertElementToString(Object object) {
                Object object2;
                if (object instanceof TreePath && (object2 = ((TreePath)object).getLastPathComponent()) instanceof BasicFileSystemTreeNode) {
                    return ((BasicFileSystemTreeNode)object2).getName();
                }
                return super.convertElementToString(object);
            }
        };
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && treePath.getLastPathComponent() instanceof BasicFileSystemTreeNode) {
            BasicFileSystemTreeNode basicFileSystemTreeNode = (BasicFileSystemTreeNode)treePath.getLastPathComponent();
            String string = basicFileSystemTreeNode.getTypeDescription();
            if (string == null || string.length() == 0) {
                return basicFileSystemTreeNode.toString();
            }
            return basicFileSystemTreeNode.toString() + " - " + string;
        }
        return null;
    }

    private class FolderTreeListener
    implements TreeWillExpandListener,
    TreeExpansionListener {
        private Cursor oldCursor;

        private FolderTreeListener() {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            Window window = SwingUtilities.getWindowAncestor(BasicFileSystemTree.this);
            if (window != null) {
                this.oldCursor = window.getCursor();
                window.setCursor(Cursor.getPredefinedCursor(3));
            }
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Window window = SwingUtilities.getWindowAncestor(BasicFileSystemTree.this);
            if (window != null) {
                window.setCursor(this.oldCursor != null ? this.oldCursor : Cursor.getDefaultCursor());
            }
            this.oldCursor = null;
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }
    }
}

