/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.thread.dialog;

import com.nepxion.swing.border.ShadowBorder;
import com.nepxion.swing.dialog.DialogResizer;
import com.nepxion.swing.dialog.JBasicDialog;
import com.nepxion.swing.thread.ThreadManager;
import com.nepxion.swing.timer.JTimerProgressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractThreadDialog
extends JBasicDialog {
    private JPanel layoutPanel;
    private JTimerProgressPanel progressPanel;
    private JLabel animationLabel;
    private String information;

    public AbstractThreadDialog(Frame owner, String title, JLabel animationLabel, String information) {
        super(owner, title, null);
        this.animationLabel = animationLabel;
        this.information = information;
        this.initComponents();
    }

    public AbstractThreadDialog(Dialog owner, String title, JLabel animationLabel, String information) {
        super(owner, title, null);
        this.animationLabel = animationLabel;
        this.information = information;
        this.initComponents();
    }

    private void initComponents() {
        this.progressPanel = new JTimerProgressPanel(this.animationLabel, this.information){

            @Override
            public void fireCancelled() {
                AbstractThreadDialog.this.fireCancelled();
            }

            @Override
            public void fireHidden() {
                AbstractThreadDialog.this.fireHidden();
            }
        };
        this.progressPanel.setPreferredSize(new Dimension(330, this.progressPanel.getPreferredSize().height + 10 + ThreadManager.getDecoratedMargin(this)));
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel = new JPanel();
        this.layoutPanel.setLayout(new BorderLayout());
        this.layoutPanel.add((Component)this.progressPanel, "Center");
        if (!JDialog.isDefaultLookAndFeelDecorated()) {
            this.layoutPanel.setBorder(new ShadowBorder());
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.layoutPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.setUndecorated(true);
        this.setResizable(false);
        for (int i = 0; i < this.getComponentListeners().length; ++i) {
            ComponentListener componentListener = this.getComponentListeners()[i];
            if (!(componentListener instanceof DialogResizer)) continue;
            this.removeComponentListener(componentListener);
            break;
        }
        ThreadManager.setPreferenceStyle(this);
    }

    public void reset() {
        this.progressPanel.reset();
    }

    public void start() {
        this.progressPanel.start();
    }

    public void start(int delayTime) {
        this.progressPanel.start(delayTime);
    }

    public void restart() {
        this.progressPanel.restart();
    }

    public void restart(int delayTime) {
        this.progressPanel.restart(delayTime);
    }

    public void stop() {
        this.progressPanel.stop();
    }

    public void finish() {
        this.progressPanel.finish();
    }

    public JPanel getLayoutPanel() {
        return this.layoutPanel;
    }

    public JTimerProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    public abstract void execute();

    protected abstract void fireHidden();

    protected abstract void fireCancelled();
}

